/*
 * Decompiled with CFR 0.152.
 */
package com.github.juliarn.npclib.bukkit;

import com.github.juliarn.npclib.api.PlatformTaskManager;
import java.util.Objects;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public final class BukkitPlatformTaskManager
implements PlatformTaskManager {
    private final Plugin plugin;

    private BukkitPlatformTaskManager(@NotNull Plugin plugin) {
        this.plugin = plugin;
    }

    @NotNull
    public static PlatformTaskManager taskManager(@NotNull Plugin plugin) {
        Objects.requireNonNull(plugin, "plugin");
        return new BukkitPlatformTaskManager(plugin);
    }

    @Override
    public void scheduleSync(@NotNull Runnable task) {
        this.plugin.getServer().getScheduler().runTask(this.plugin, task);
    }

    @Override
    public void scheduleDelayedSync(@NotNull Runnable task, int delayTicks) {
        this.plugin.getServer().getScheduler().runTaskLater(this.plugin, task, (long)delayTicks);
    }

    @Override
    public void scheduleAsync(@NotNull Runnable task) {
        this.plugin.getServer().getScheduler().runTaskAsynchronously(this.plugin, task);
    }

    @Override
    public void scheduleDelayedAsync(@NotNull Runnable task, int delayTicks) {
        this.plugin.getServer().getScheduler().runTaskLaterAsynchronously(this.plugin, task, (long)delayTicks);
    }
}

