/*
 * Decompiled with CFR 0.152.
 */
package com.github.juliarn.npclib.bukkit;

import com.github.juliarn.npclib.api.NpcActionController;
import com.github.juliarn.npclib.api.Platform;
import com.github.juliarn.npclib.api.log.PlatformLogger;
import com.github.juliarn.npclib.bukkit.BukkitActionController;
import com.github.juliarn.npclib.bukkit.BukkitPlatformTaskManager;
import com.github.juliarn.npclib.bukkit.BukkitProfileResolver;
import com.github.juliarn.npclib.bukkit.BukkitVersionAccessor;
import com.github.juliarn.npclib.bukkit.BukkitWorldAccessor;
import com.github.juliarn.npclib.bukkit.protocol.BukkitProtocolAdapter;
import com.github.juliarn.npclib.bukkit.util.BukkitPlatformUtil;
import com.github.juliarn.npclib.common.platform.CommonPlatform;
import com.github.juliarn.npclib.common.platform.CommonPlatformBuilder;
import com.github.juliarn.npclib.common.task.AsyncPlatformTaskManager;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public final class BukkitPlatform
extends CommonPlatformBuilder<World, Player, ItemStack, Plugin> {
    private BukkitPlatform() {
    }

    @NotNull
    public static BukkitPlatform bukkitNpcPlatformBuilder() {
        return new BukkitPlatform();
    }

    @Override
    protected void prepareBuild() {
        if (this.profileResolver == null) {
            this.profileResolver = BukkitProfileResolver.profileResolver();
        }
        if (this.taskManager == null) {
            this.taskManager = BukkitPlatformUtil.runsOnFolia() ? AsyncPlatformTaskManager.taskManager(((Plugin)this.extension).getName()) : BukkitPlatformTaskManager.taskManager((Plugin)this.extension);
        }
        if (this.versionAccessor == null) {
            this.versionAccessor = BukkitVersionAccessor.versionAccessor();
        }
        if (this.worldAccessor == null) {
            this.worldAccessor = BukkitWorldAccessor.worldAccessor();
        }
        if (this.packetAdapter == null) {
            this.packetAdapter = BukkitProtocolAdapter.packetAdapter();
        }
        if (this.logger == null) {
            this.logger = PlatformLogger.fromJul(((Plugin)this.extension).getLogger());
        }
    }

    @Override
    @NotNull
    protected Platform<World, Player, ItemStack, Plugin> doBuild() {
        NpcActionController actionController = null;
        if (this.actionControllerDecorator != null) {
            NpcActionController.Builder builder = BukkitActionController.actionControllerBuilder((Plugin)this.extension, this.eventManager, this.versionAccessor, this.npcTracker);
            this.actionControllerDecorator.accept(builder);
            actionController = builder.build();
        }
        return new CommonPlatform<World, Player, ItemStack, Plugin>(this.debug, (Plugin)this.extension, this.logger, this.npcTracker, this.profileResolver, this.taskManager, actionController, this.versionAccessor, this.eventManager, this.worldAccessor, this.packetAdapter);
    }
}

