/*
 * Decompiled with CFR 0.152.
 */
package com.github.juliarn.npclib.bukkit.protocol;

import com.github.juliarn.npclib.api.Npc;
import com.github.juliarn.npclib.api.Platform;
import com.github.juliarn.npclib.api.PlatformVersionAccessor;
import com.github.juliarn.npclib.api.Position;
import com.github.juliarn.npclib.api.event.InteractNpcEvent;
import com.github.juliarn.npclib.api.event.NpcEvent;
import com.github.juliarn.npclib.api.profile.ProfileProperty;
import com.github.juliarn.npclib.api.protocol.OutboundPacket;
import com.github.juliarn.npclib.api.protocol.PlatformPacketAdapter;
import com.github.juliarn.npclib.api.protocol.enums.EntityAnimation;
import com.github.juliarn.npclib.api.protocol.enums.ItemSlot;
import com.github.juliarn.npclib.api.protocol.enums.PlayerInfoAction;
import com.github.juliarn.npclib.api.protocol.meta.EntityMetadata;
import com.github.juliarn.npclib.api.protocol.meta.EntityMetadataFactory;
import com.github.juliarn.npclib.common.event.DefaultAttackNpcEvent;
import com.github.juliarn.npclib.common.event.DefaultInteractNpcEvent;
import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.PacketEventsAPI;
import com.github.retrooper.packetevents.event.PacketListenerCommon;
import com.github.retrooper.packetevents.event.PacketListenerPriority;
import com.github.retrooper.packetevents.event.PacketReceiveEvent;
import com.github.retrooper.packetevents.event.SimplePacketListenerAbstract;
import com.github.retrooper.packetevents.event.simple.PacketPlayReceiveEvent;
import com.github.retrooper.packetevents.manager.player.PlayerManager;
import com.github.retrooper.packetevents.manager.server.ServerVersion;
import com.github.retrooper.packetevents.protocol.entity.data.EntityData;
import com.github.retrooper.packetevents.protocol.entity.data.EntityDataType;
import com.github.retrooper.packetevents.protocol.entity.data.EntityDataTypes;
import com.github.retrooper.packetevents.protocol.entity.pose.EntityPose;
import com.github.retrooper.packetevents.protocol.entity.type.EntityTypes;
import com.github.retrooper.packetevents.protocol.packettype.PacketType;
import com.github.retrooper.packetevents.protocol.player.Equipment;
import com.github.retrooper.packetevents.protocol.player.EquipmentSlot;
import com.github.retrooper.packetevents.protocol.player.GameMode;
import com.github.retrooper.packetevents.protocol.player.InteractionHand;
import com.github.retrooper.packetevents.protocol.player.TextureProperty;
import com.github.retrooper.packetevents.protocol.player.UserProfile;
import com.github.retrooper.packetevents.protocol.world.Location;
import com.github.retrooper.packetevents.settings.PacketEventsSettings;
import com.github.retrooper.packetevents.util.TimeStampMode;
import com.github.retrooper.packetevents.util.adventure.AdventureSerializer;
import com.github.retrooper.packetevents.wrapper.PacketWrapper;
import com.github.retrooper.packetevents.wrapper.play.client.WrapperPlayClientInteractEntity;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerDestroyEntities;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntityAnimation;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntityEquipment;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntityHeadLook;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntityMetadata;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntityRotation;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntityTeleport;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerPlayerInfo;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerPlayerInfoRemove;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerPlayerInfoUpdate;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerPluginMessage;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerSpawnEntity;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerSpawnPlayer;
import com.google.common.collect.ImmutableMap;
import io.github.retrooper.packetevents.factory.spigot.SpigotPacketEventsBuilder;
import io.github.retrooper.packetevents.util.SpigotReflectionUtil;
import io.leangen.geantyref.TypeFactory;
import java.lang.reflect.Type;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiFunction;
import net.kyori.adventure.text.Component;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

final class PacketEventsPacketAdapter
implements PlatformPacketAdapter<World, Player, ItemStack, Plugin> {
    static final PacketEventsPacketAdapter INSTANCE = new PacketEventsPacketAdapter();
    private static final PacketEventsSettings PACKET_EVENTS_SETTINGS = new PacketEventsSettings().debug(false).checkForUpdates(false).reEncodeByDefault(false).timeStampMode(TimeStampMode.NONE);
    private static final Type OPTIONAL_CHAT_COMPONENT_TYPE = TypeFactory.parameterizedClass(Optional.class, (Type[])new Type[]{Component.class});
    private ServerVersion serverVersion;
    private PlayerManager packetPlayerManager;

    PacketEventsPacketAdapter() {
    }

    @NotNull
    private static Location npcLocation(@NotNull Npc<?, ?, ?, ?> npc) {
        return PacketEventsPacketAdapter.npcLocation(npc, npc.position().yaw(), npc.position().pitch());
    }

    @NotNull
    private static Location npcLocation(@NotNull Npc<?, ?, ?, ?> npc, float yaw, float pitch) {
        Position pos = npc.position();
        return new Location(pos.x(), pos.y(), pos.z(), yaw, pitch);
    }

    @NotNull
    private static EntityData createEntityData(int index, @NotNull Type type, @NotNull Object value, @NotNull PlatformVersionAccessor versionAccessor) {
        BiFunction converter = (BiFunction)Lazy.SERIALIZER_CONVERTERS.get(type);
        if (converter != null) {
            Map.Entry converted = (Map.Entry)converter.apply(versionAccessor, value);
            type = (Type)converted.getKey();
            value = converted.getValue();
        }
        return new EntityData(index, (EntityDataType)Lazy.ENTITY_DATA_TYPE_LOOKUP.get(type), value);
    }

    @NotNull
    public OutboundPacket<World, Player, ItemStack, Plugin> createEntitySpawnPacket() {
        return (player, npc) -> {
            Location location = PacketEventsPacketAdapter.npcLocation(npc);
            Object wrapper = this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_20_2) ? new WrapperPlayServerSpawnEntity(npc.entityId(), Optional.of(npc.profile().uniqueId()), EntityTypes.PLAYER, location.getPosition(), location.getPitch(), location.getYaw(), 0.0f, 0, Optional.empty()) : new WrapperPlayServerSpawnPlayer(npc.entityId(), npc.profile().uniqueId(), location, new EntityData[0]);
            this.packetPlayerManager.sendPacketSilently(player, (PacketWrapper)wrapper);
        };
    }

    @NotNull
    public OutboundPacket<World, Player, ItemStack, Plugin> createEntityRemovePacket() {
        return (player, npc) -> {
            WrapperPlayServerDestroyEntities wrapper = new WrapperPlayServerDestroyEntities(npc.entityId());
            this.packetPlayerManager.sendPacketSilently(player, (PacketWrapper)wrapper);
        };
    }

    @NotNull
    public OutboundPacket<World, Player, ItemStack, Plugin> createPlayerInfoPacket(@NotNull PlayerInfoAction action) {
        return (player, npc) -> npc.settings().profileResolver().resolveNpcProfile(player, npc).thenAcceptAsync(profile -> {
            WrapperPlayServerPlayerInfoRemove wrapper;
            UserProfile userProfile = new UserProfile(profile.uniqueId(), profile.name());
            for (ProfileProperty property : profile.properties()) {
                TextureProperty textureProperty = new TextureProperty(property.name(), property.value(), property.signature());
                userProfile.getTextureProperties().add(textureProperty);
            }
            if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_19_3)) {
                if (action == PlayerInfoAction.REMOVE_PLAYER) {
                    List<UUID> uuidsToRemove = Collections.singletonList(profile.uniqueId());
                    wrapper = new WrapperPlayServerPlayerInfoRemove(uuidsToRemove);
                } else {
                    WrapperPlayServerPlayerInfoUpdate.PlayerInfo playerInfo = new WrapperPlayServerPlayerInfoUpdate.PlayerInfo(userProfile, false, 20, GameMode.CREATIVE, null, null, 0, true);
                    wrapper = new WrapperPlayServerPlayerInfoUpdate(Lazy.ADD_ACTIONS, Collections.singletonList(playerInfo));
                }
            } else {
                WrapperPlayServerPlayerInfo.PlayerData playerData = new WrapperPlayServerPlayerInfo.PlayerData(null, userProfile, GameMode.CREATIVE, 20);
                WrapperPlayServerPlayerInfo.Action playerInfoAction = (WrapperPlayServerPlayerInfo.Action)Lazy.PLAYER_INFO_ACTION_CONVERTER.get(action);
                wrapper = new WrapperPlayServerPlayerInfo(playerInfoAction, new WrapperPlayServerPlayerInfo.PlayerData[]{playerData});
            }
            this.packetPlayerManager.sendPacketSilently(player, (PacketWrapper)wrapper);
        });
    }

    @NotNull
    public OutboundPacket<World, Player, ItemStack, Plugin> createRotationPacket(float yaw, float pitch) {
        return (player, npc) -> {
            WrapperPlayServerEntityHeadLook headRotation = new WrapperPlayServerEntityHeadLook(npc.entityId(), yaw);
            Object rotation = this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_9) ? new WrapperPlayServerEntityRotation(npc.entityId(), yaw, pitch, true) : new WrapperPlayServerEntityTeleport(npc.entityId(), PacketEventsPacketAdapter.npcLocation(npc, yaw, pitch), true);
            this.packetPlayerManager.sendPacketSilently(player, (PacketWrapper)rotation);
            this.packetPlayerManager.sendPacketSilently(player, (PacketWrapper)headRotation);
        };
    }

    @NotNull
    public OutboundPacket<World, Player, ItemStack, Plugin> createAnimationPacket(@NotNull EntityAnimation animation) {
        return (player, npc) -> {
            WrapperPlayServerEntityAnimation.EntityAnimationType animationType = (WrapperPlayServerEntityAnimation.EntityAnimationType)Lazy.ENTITY_ANIMATION_CONVERTER.get(animation);
            WrapperPlayServerEntityAnimation wrapper = new WrapperPlayServerEntityAnimation(npc.entityId(), animationType);
            this.packetPlayerManager.sendPacketSilently(player, (PacketWrapper)wrapper);
        };
    }

    @NotNull
    public OutboundPacket<World, Player, ItemStack, Plugin> createEquipmentPacket(@NotNull ItemSlot slot, @NotNull ItemStack item) {
        return (player, npc) -> {
            EquipmentSlot equipmentSlot = (EquipmentSlot)Lazy.ITEM_SLOT_CONVERTER.get(slot);
            com.github.retrooper.packetevents.protocol.item.ItemStack is = SpigotReflectionUtil.decodeBukkitItemStack((ItemStack)item);
            Equipment equipment = new Equipment(equipmentSlot, is);
            WrapperPlayServerEntityEquipment wrapper = new WrapperPlayServerEntityEquipment(npc.entityId(), Collections.singletonList(equipment));
            this.packetPlayerManager.sendPacketSilently(player, (PacketWrapper)wrapper);
        };
    }

    @NotNull
    public OutboundPacket<World, Player, ItemStack, Plugin> createCustomPayloadPacket(@NotNull String channelId, byte[] payload) {
        return (player, npc) -> {
            WrapperPlayServerPluginMessage wrapper = new WrapperPlayServerPluginMessage(channelId, payload);
            this.packetPlayerManager.sendPacketSilently(player, (PacketWrapper)wrapper);
        };
    }

    @NotNull
    public <T, O> OutboundPacket<World, Player, ItemStack, Plugin> createEntityMetaPacket(@NotNull EntityMetadataFactory<T, O> metadata, @NotNull T value) {
        return (player, npc) -> {
            PlatformVersionAccessor versionAccessor = npc.platform().versionAccessor();
            EntityMetadata entityMetadata = metadata.create(value, versionAccessor);
            if (!entityMetadata.available()) {
                return;
            }
            ArrayList<EntityData> entityData = new ArrayList<EntityData>();
            entityData.add(PacketEventsPacketAdapter.createEntityData(entityMetadata.index(), entityMetadata.type(), entityMetadata.value(), versionAccessor));
            for (EntityMetadataFactory relatedMetadata : metadata.relatedMetadata()) {
                EntityMetadata related = relatedMetadata.create(value, versionAccessor);
                if (!related.available()) continue;
                entityData.add(PacketEventsPacketAdapter.createEntityData(related.index(), related.type(), related.value(), versionAccessor));
            }
            WrapperPlayServerEntityMetadata wrapper = new WrapperPlayServerEntityMetadata(npc.entityId(), entityData);
            this.packetPlayerManager.sendPacketSilently(player, (PacketWrapper)wrapper);
        };
    }

    public void initialize(@NotNull Platform<World, Player, ItemStack, Plugin> platform) {
        PacketEventsAPI packetEventsApi = SpigotPacketEventsBuilder.buildNoCache((Plugin)((Plugin)platform.extension()), (PacketEventsSettings)PACKET_EVENTS_SETTINGS);
        PacketEvents.setAPI((PacketEventsAPI)packetEventsApi);
        packetEventsApi.init();
        this.packetPlayerManager = packetEventsApi.getPlayerManager();
        this.serverVersion = packetEventsApi.getServerManager().getVersion();
        packetEventsApi.getEventManager().registerListener((PacketListenerCommon)new NpcUsePacketAdapter(platform));
    }

    private static final class Lazy {
        private static final EnumMap<ItemSlot, EquipmentSlot> ITEM_SLOT_CONVERTER;
        private static final EnumMap<InteractionHand, InteractNpcEvent.Hand> HAND_CONVERTER;
        private static final EnumMap<PlayerInfoAction, WrapperPlayServerPlayerInfo.Action> PLAYER_INFO_ACTION_CONVERTER;
        private static final EnumMap<EntityAnimation, WrapperPlayServerEntityAnimation.EntityAnimationType> ENTITY_ANIMATION_CONVERTER;
        private static final EnumMap<com.github.juliarn.npclib.api.protocol.enums.EntityPose, EntityPose> ENTITY_POSE_CONVERTER;
        private static final Map<Type, EntityDataType<?>> ENTITY_DATA_TYPE_LOOKUP;
        private static final Map<Type, BiFunction<PlatformVersionAccessor, Object, Map.Entry<Type, Object>>> SERIALIZER_CONVERTERS;
        private static final EnumSet<WrapperPlayServerPlayerInfoUpdate.Action> ADD_ACTIONS;

        private Lazy() {
        }

        static {
            ADD_ACTIONS = EnumSet.of(WrapperPlayServerPlayerInfoUpdate.Action.ADD_PLAYER, new WrapperPlayServerPlayerInfoUpdate.Action[]{WrapperPlayServerPlayerInfoUpdate.Action.UPDATE_HAT, WrapperPlayServerPlayerInfoUpdate.Action.UPDATE_LISTED, WrapperPlayServerPlayerInfoUpdate.Action.UPDATE_LATENCY, WrapperPlayServerPlayerInfoUpdate.Action.UPDATE_GAME_MODE, WrapperPlayServerPlayerInfoUpdate.Action.UPDATE_DISPLAY_NAME});
            ITEM_SLOT_CONVERTER = new EnumMap(ItemSlot.class);
            ITEM_SLOT_CONVERTER.put(ItemSlot.MAIN_HAND, EquipmentSlot.MAIN_HAND);
            ITEM_SLOT_CONVERTER.put(ItemSlot.OFF_HAND, EquipmentSlot.OFF_HAND);
            ITEM_SLOT_CONVERTER.put(ItemSlot.FEET, EquipmentSlot.BOOTS);
            ITEM_SLOT_CONVERTER.put(ItemSlot.LEGS, EquipmentSlot.LEGGINGS);
            ITEM_SLOT_CONVERTER.put(ItemSlot.CHEST, EquipmentSlot.CHEST_PLATE);
            ITEM_SLOT_CONVERTER.put(ItemSlot.HEAD, EquipmentSlot.HELMET);
            HAND_CONVERTER = new EnumMap(InteractionHand.class);
            HAND_CONVERTER.put(InteractionHand.MAIN_HAND, InteractNpcEvent.Hand.MAIN_HAND);
            HAND_CONVERTER.put(InteractionHand.OFF_HAND, InteractNpcEvent.Hand.OFF_HAND);
            PLAYER_INFO_ACTION_CONVERTER = new EnumMap(PlayerInfoAction.class);
            PLAYER_INFO_ACTION_CONVERTER.put(PlayerInfoAction.ADD_PLAYER, WrapperPlayServerPlayerInfo.Action.ADD_PLAYER);
            PLAYER_INFO_ACTION_CONVERTER.put(PlayerInfoAction.REMOVE_PLAYER, WrapperPlayServerPlayerInfo.Action.REMOVE_PLAYER);
            ENTITY_ANIMATION_CONVERTER = new EnumMap(EntityAnimation.class);
            ENTITY_ANIMATION_CONVERTER.put(EntityAnimation.SWING_MAIN_ARM, WrapperPlayServerEntityAnimation.EntityAnimationType.SWING_MAIN_ARM);
            ENTITY_ANIMATION_CONVERTER.put(EntityAnimation.TAKE_DAMAGE, WrapperPlayServerEntityAnimation.EntityAnimationType.HURT);
            ENTITY_ANIMATION_CONVERTER.put(EntityAnimation.LEAVE_BED, WrapperPlayServerEntityAnimation.EntityAnimationType.WAKE_UP);
            ENTITY_ANIMATION_CONVERTER.put(EntityAnimation.SWING_OFF_HAND, WrapperPlayServerEntityAnimation.EntityAnimationType.SWING_OFF_HAND);
            ENTITY_ANIMATION_CONVERTER.put(EntityAnimation.CRITICAL_EFFECT, WrapperPlayServerEntityAnimation.EntityAnimationType.CRITICAL_HIT);
            ENTITY_ANIMATION_CONVERTER.put(EntityAnimation.MAGIC_CRITICAL_EFFECT, WrapperPlayServerEntityAnimation.EntityAnimationType.MAGIC_CRITICAL_HIT);
            ENTITY_POSE_CONVERTER = new EnumMap(com.github.juliarn.npclib.api.protocol.enums.EntityPose.class);
            ENTITY_POSE_CONVERTER.put(com.github.juliarn.npclib.api.protocol.enums.EntityPose.STANDING, EntityPose.STANDING);
            ENTITY_POSE_CONVERTER.put(com.github.juliarn.npclib.api.protocol.enums.EntityPose.FALL_FLYING, EntityPose.FALL_FLYING);
            ENTITY_POSE_CONVERTER.put(com.github.juliarn.npclib.api.protocol.enums.EntityPose.SLEEPING, EntityPose.SLEEPING);
            ENTITY_POSE_CONVERTER.put(com.github.juliarn.npclib.api.protocol.enums.EntityPose.SWIMMING, EntityPose.SWIMMING);
            ENTITY_POSE_CONVERTER.put(com.github.juliarn.npclib.api.protocol.enums.EntityPose.SPIN_ATTACK, EntityPose.SPIN_ATTACK);
            ENTITY_POSE_CONVERTER.put(com.github.juliarn.npclib.api.protocol.enums.EntityPose.CROUCHING, EntityPose.CROUCHING);
            ENTITY_POSE_CONVERTER.put(com.github.juliarn.npclib.api.protocol.enums.EntityPose.LONG_JUMPING, EntityPose.LONG_JUMPING);
            ENTITY_POSE_CONVERTER.put(com.github.juliarn.npclib.api.protocol.enums.EntityPose.DYING, EntityPose.DYING);
            ENTITY_POSE_CONVERTER.put(com.github.juliarn.npclib.api.protocol.enums.EntityPose.CROAKING, EntityPose.CROAKING);
            ENTITY_POSE_CONVERTER.put(com.github.juliarn.npclib.api.protocol.enums.EntityPose.USING_TONGUE, EntityPose.USING_TONGUE);
            ENTITY_POSE_CONVERTER.put(com.github.juliarn.npclib.api.protocol.enums.EntityPose.ROARING, EntityPose.ROARING);
            ENTITY_POSE_CONVERTER.put(com.github.juliarn.npclib.api.protocol.enums.EntityPose.SNIFFING, EntityPose.SNIFFING);
            ENTITY_POSE_CONVERTER.put(com.github.juliarn.npclib.api.protocol.enums.EntityPose.EMERGING, EntityPose.EMERGING);
            ENTITY_POSE_CONVERTER.put(com.github.juliarn.npclib.api.protocol.enums.EntityPose.DIGGING, EntityPose.DIGGING);
            ENTITY_POSE_CONVERTER.put(com.github.juliarn.npclib.api.protocol.enums.EntityPose.SLIDING, EntityPose.SLIDING);
            ENTITY_POSE_CONVERTER.put(com.github.juliarn.npclib.api.protocol.enums.EntityPose.SHOOTING, EntityPose.SHOOTING);
            ENTITY_POSE_CONVERTER.put(com.github.juliarn.npclib.api.protocol.enums.EntityPose.INHALING, EntityPose.INHALING);
            SERIALIZER_CONVERTERS = ImmutableMap.builder().put(com.github.juliarn.npclib.api.protocol.enums.EntityPose.class, ($, value) -> new AbstractMap.SimpleImmutableEntry<Class<EntityPose>, EntityPose>(EntityPose.class, ENTITY_POSE_CONVERTER.get(value))).put((Object)TypeFactory.parameterizedClass(Optional.class, (Type[])new Type[]{com.github.juliarn.npclib.api.protocol.chat.Component.class}), (versionAccessor, value) -> {
                Optional optionalComponent = (Optional)value;
                if (versionAccessor.atLeast(1, 13, 0)) {
                    return new AbstractMap.SimpleImmutableEntry<Type, Optional<Component>>(OPTIONAL_CHAT_COMPONENT_TYPE, optionalComponent.map(component -> {
                        if (component.rawMessage() != null) {
                            return AdventureSerializer.fromLegacyFormat((String)component.rawMessage());
                        }
                        return AdventureSerializer.parseComponent((String)component.encodedJsonMessage());
                    }));
                }
                return new AbstractMap.SimpleImmutableEntry<Class<String>, Object>(String.class, optionalComponent.map(component -> Objects.requireNonNull(component.rawMessage(), "Versions older than 1.13 don't support json component")).orElse(null));
            }).build();
            ENTITY_DATA_TYPE_LOOKUP = ImmutableMap.builder().put(Byte.class, (Object)EntityDataTypes.BYTE).put(Integer.class, (Object)EntityDataTypes.INT).put(Float.class, (Object)EntityDataTypes.FLOAT).put(Boolean.class, (Object)EntityDataTypes.BOOLEAN).put(String.class, (Object)EntityDataTypes.STRING).put((Object)OPTIONAL_CHAT_COMPONENT_TYPE, (Object)EntityDataTypes.OPTIONAL_ADV_COMPONENT).put(EntityPose.class, (Object)EntityDataTypes.ENTITY_POSE).build();
        }
    }

    private static final class NpcUsePacketAdapter
    extends SimplePacketListenerAbstract {
        private final Platform<World, Player, ItemStack, Plugin> platform;

        public NpcUsePacketAdapter(@NotNull Platform<World, Player, ItemStack, Plugin> platform) {
            super(PacketListenerPriority.MONITOR);
            this.platform = platform;
        }

        public void onPacketPlayReceive(@NotNull PacketPlayReceiveEvent event) {
            Object player = event.getPlayer();
            if (event.getPacketType() == PacketType.Play.Client.INTERACT_ENTITY) {
                WrapperPlayClientInteractEntity packet = new WrapperPlayClientInteractEntity((PacketReceiveEvent)event);
                Npc npc = this.platform.npcTracker().npcById(packet.getEntityId());
                if (npc != null) {
                    switch (packet.getAction()) {
                        case ATTACK: {
                            this.platform.eventManager().post((NpcEvent)DefaultAttackNpcEvent.attackNpc((Npc)npc, (Object)player));
                            break;
                        }
                        case INTERACT: {
                            InteractNpcEvent.Hand hand = (InteractNpcEvent.Hand)Lazy.HAND_CONVERTER.get(packet.getHand());
                            this.platform.eventManager().post((NpcEvent)DefaultInteractNpcEvent.interactNpc((Npc)npc, (Object)player, (InteractNpcEvent.Hand)hand));
                            break;
                        }
                    }
                    event.setCancelled(true);
                }
            }
        }
    }
}

