/*
 * Decompiled with CFR 0.152.
 */
package com.github.juliarn.npclib.bukkit;

import com.destroystokyo.paper.profile.PlayerProfile;
import com.github.juliarn.npclib.api.profile.Profile;
import com.github.juliarn.npclib.api.profile.ProfileProperty;
import com.github.juliarn.npclib.api.profile.ProfileResolver;
import io.papermc.lib.PaperLib;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.jetbrains.annotations.NotNull;

public final class BukkitProfileResolver {
    private BukkitProfileResolver() {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public static ProfileResolver profileResolver() {
        if (PaperLib.isPaper() && PaperLib.isVersion((int)12)) {
            return PaperProfileResolver.INSTANCE;
        }
        if (PaperLib.isSpigot() && PaperLib.isVersion((int)18, (int)2)) {
            return SpigotProfileResolver.INSTANCE;
        }
        return LegacyResolver.INSTANCE;
    }

    private static final class PaperProfileResolver
    implements ProfileResolver {
        private static final ProfileResolver INSTANCE = new PaperProfileResolver();

        private PaperProfileResolver() {
        }

        @NotNull
        public CompletableFuture<Profile.Resolved> resolveProfile(@NotNull Profile profile) {
            return CompletableFuture.supplyAsync(() -> {
                PlayerProfile playerProfile = Bukkit.createProfile((UUID)profile.uniqueId(), (String)profile.name());
                playerProfile.complete(true, true);
                Set properties = playerProfile.getProperties().stream().map(prop -> ProfileProperty.property((String)prop.getName(), (String)prop.getValue(), (String)prop.getSignature())).collect(Collectors.toSet());
                UUID profileId = playerProfile.getId();
                if (profileId == null) {
                    throw new IllegalStateException("Could not resolve profile uuid using paper resolver");
                }
                String profileName = playerProfile.getName();
                if (profileName == null) {
                    String randomId = UUID.randomUUID().toString();
                    profileName = randomId.replace("-", "").substring(0, 16);
                }
                return Profile.resolved((String)profileName, (UUID)profileId, properties);
            });
        }
    }

    private static final class SpigotProfileResolver
    implements ProfileResolver {
        private static final ProfileResolver INSTANCE = new SpigotProfileResolver();

        private SpigotProfileResolver() {
        }

        @NotNull
        public CompletableFuture<Profile.Resolved> resolveProfile(@NotNull Profile profile) {
            org.bukkit.profile.PlayerProfile playerProfile = Bukkit.createPlayerProfile((UUID)profile.uniqueId(), (String)profile.name());
            return playerProfile.update().thenApplyAsync(resolvedProfile -> {
                UUID profileId = resolvedProfile.getUniqueId();
                String profileName = resolvedProfile.getName();
                if (profileId == null || profileName == null) {
                    throw new IllegalStateException("Could not resolve profile using spigot resolver");
                }
                List props = (List)resolvedProfile.serialize().get("properties");
                if (props == null) {
                    return Profile.resolved((String)resolvedProfile.getName(), (UUID)resolvedProfile.getUniqueId());
                }
                HashSet<ProfileProperty> properties = new HashSet<ProfileProperty>();
                for (Map entry : props) {
                    ProfileProperty prop = ProfileProperty.property((String)((String)entry.get("name")), (String)((String)entry.get("value")), (String)((String)entry.get("signature")));
                    properties.add(prop);
                }
                return Profile.resolved((String)profileName, (UUID)profileId, properties);
            });
        }
    }

    private static final class LegacyResolver {
        private static final ProfileResolver INSTANCE = ProfileResolver.caching((ProfileResolver)ProfileResolver.mojang());

        private LegacyResolver() {
        }
    }
}

