/*
 * Decompiled with CFR 0.152.
 */
package com.github.juliarn.npclib.api.protocol.chat;

import com.github.juliarn.npclib.api.protocol.chat.DefaultComponent;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Component {
    @NotNull
    public static Component ofRawMessage(@NotNull String rawMessage) {
        Objects.requireNonNull(rawMessage, "rawMessage");
        return new DefaultComponent(rawMessage, null);
    }

    @NotNull
    public static Component ofJsonEncodedMessage(@NotNull String jsonEncodedMessage) {
        Objects.requireNonNull(jsonEncodedMessage, "jsonEncodedMessage");
        return new DefaultComponent(null, jsonEncodedMessage);
    }

    @Contract(value="null, null -> fail")
    @NotNull
    public static Component ofJsonEncodedOrRaw(@Nullable String rawMessage, @Nullable String jsonEncodedMessage) {
        if (rawMessage == null && jsonEncodedMessage == null) {
            throw new IllegalArgumentException("Either rawMessage or jsonEncodedMessage must be given");
        }
        return new DefaultComponent(rawMessage, jsonEncodedMessage);
    }

    @Nullable
    public String rawMessage();

    @Nullable
    public String encodedJsonMessage();
}

