/*
 * Decompiled with CFR 0.152.
 */
package com.github.juliarn.npclib.api;

import com.github.juliarn.npclib.api.Npc;
import com.github.juliarn.npclib.api.NpcActionController;
import com.github.juliarn.npclib.api.NpcTracker;
import com.github.juliarn.npclib.api.PlatformTaskManager;
import com.github.juliarn.npclib.api.PlatformVersionAccessor;
import com.github.juliarn.npclib.api.PlatformWorldAccessor;
import com.github.juliarn.npclib.api.event.manager.NpcEventManager;
import com.github.juliarn.npclib.api.log.PlatformLogger;
import com.github.juliarn.npclib.api.profile.ProfileResolver;
import com.github.juliarn.npclib.api.protocol.PlatformPacketAdapter;
import java.util.Optional;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

public interface Platform<W, P, I, E> {
    public boolean debug();

    @NotNull
    public E extension();

    @NotNull
    public PlatformLogger logger();

    @NotNull
    public NpcEventManager eventManager();

    @NotNull
    public NpcTracker<W, P, I, E> npcTracker();

    @NotNull
    public ProfileResolver profileResolver();

    @NotNull
    public PlatformTaskManager taskManager();

    @NotNull
    public Npc.Builder<W, P, I, E> newNpcBuilder();

    @NotNull
    public PlatformVersionAccessor versionAccessor();

    @NotNull
    public PlatformWorldAccessor<W> worldAccessor();

    @NotNull
    public PlatformPacketAdapter<W, P, I, E> packetFactory();

    @NotNull
    public Optional<NpcActionController> actionController();

    public static interface Builder<W, P, I, E> {
        @NotNull
        public Builder<W, P, I, E> debug(boolean var1);

        @NotNull
        public Builder<W, P, I, E> extension(@NotNull E var1);

        @NotNull
        public Builder<W, P, I, E> logger(@NotNull PlatformLogger var1);

        @NotNull
        public Builder<W, P, I, E> eventManager(@NotNull NpcEventManager var1);

        @NotNull
        public Builder<W, P, I, E> npcTracker(@NotNull NpcTracker<W, P, I, E> var1);

        @NotNull
        public Builder<W, P, I, E> taskManager(@NotNull PlatformTaskManager var1);

        @NotNull
        public Builder<W, P, I, E> profileResolver(@NotNull ProfileResolver var1);

        @NotNull
        public Builder<W, P, I, E> worldAccessor(@NotNull PlatformWorldAccessor<W> var1);

        @NotNull
        public Builder<W, P, I, E> versionAccessor(@NotNull PlatformVersionAccessor var1);

        @NotNull
        public Builder<W, P, I, E> packetFactory(@NotNull PlatformPacketAdapter<W, P, I, E> var1);

        @NotNull
        public Builder<W, P, I, E> actionController(@NotNull Consumer<NpcActionController.Builder> var1);

        @NotNull
        public Platform<W, P, I, E> build();
    }
}

