/*
 * Decompiled with CFR 0.152.
 */
package com.github.juliarn.npclib.api;

import com.github.juliarn.npclib.api.NpcTracker;
import com.github.juliarn.npclib.api.Platform;
import com.github.juliarn.npclib.api.Position;
import com.github.juliarn.npclib.api.flag.NpcFlag;
import com.github.juliarn.npclib.api.flag.NpcFlaggedBuilder;
import com.github.juliarn.npclib.api.flag.NpcFlaggedObject;
import com.github.juliarn.npclib.api.profile.Profile;
import com.github.juliarn.npclib.api.profile.ProfileResolver;
import com.github.juliarn.npclib.api.protocol.NpcSpecificOutboundPacket;
import com.github.juliarn.npclib.api.protocol.enums.EntityAnimation;
import com.github.juliarn.npclib.api.protocol.enums.ItemSlot;
import com.github.juliarn.npclib.api.protocol.meta.EntityMetadataFactory;
import com.github.juliarn.npclib.api.settings.NpcSettings;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnmodifiableView;

public interface Npc<W, P, I, E>
extends NpcFlaggedObject {
    public static final NpcFlag<Boolean> LOOK_AT_PLAYER = NpcFlag.flag("imitate_player_look", false);
    public static final NpcFlag<Boolean> HIT_WHEN_PLAYER_HITS = NpcFlag.flag("imitate_player_hit", false);
    public static final NpcFlag<Boolean> SNEAK_WHEN_PLAYER_SNEAKS = NpcFlag.flag("imitate_player_sneak", false);

    public int entityId();

    @NotNull
    public Profile.Resolved profile();

    @NotNull
    public W world();

    @NotNull
    public Position position();

    @NotNull
    public NpcSettings<P> settings();

    @NotNull
    public Platform<W, P, I, E> platform();

    @NotNull
    public NpcTracker<W, P, I, E> npcTracker();

    public boolean shouldIncludePlayer(@NotNull P var1);

    public @UnmodifiableView @NotNull Collection<P> includedPlayers();

    public boolean includesPlayer(@NotNull P var1);

    @NotNull
    public Npc<W, P, I, E> addIncludedPlayer(@NotNull P var1);

    @NotNull
    public Npc<W, P, I, E> removeIncludedPlayer(@NotNull P var1);

    @NotNull
    public Npc<W, P, I, E> unlink();

    public @UnmodifiableView @NotNull Collection<P> trackedPlayers();

    public boolean tracksPlayer(@NotNull P var1);

    @NotNull
    public Npc<W, P, I, E> trackPlayer(@NotNull P var1);

    @NotNull
    public Npc<W, P, I, E> forceTrackPlayer(@NotNull P var1);

    @NotNull
    public Npc<W, P, I, E> stopTrackingPlayer(@NotNull P var1);

    @NotNull
    public NpcSpecificOutboundPacket<W, P, I, E> lookAt(@NotNull Position var1);

    @NotNull
    public NpcSpecificOutboundPacket<W, P, I, E> playAnimation(@NotNull EntityAnimation var1);

    @NotNull
    public NpcSpecificOutboundPacket<W, P, I, E> changeItem(@NotNull ItemSlot var1, @NotNull I var2);

    @NotNull
    public <T, O> NpcSpecificOutboundPacket<W, P, I, E> changeMetadata(@NotNull EntityMetadataFactory<T, O> var1, @NotNull T var2);

    public static interface Builder<W, P, I, E>
    extends NpcFlaggedBuilder<Builder<W, P, I, E>> {
        @NotNull
        public Builder<W, P, I, E> entityId(int var1);

        @NotNull
        public Builder<W, P, I, E> position(@NotNull Position var1);

        @NotNull
        public Builder<W, P, I, E> profile(@NotNull Profile.Resolved var1);

        @NotNull
        default public CompletableFuture<Builder<W, P, I, E>> profile(@NotNull Profile profile) {
            return this.profile(null, profile);
        }

        @NotNull
        public CompletableFuture<Builder<W, P, I, E>> profile(@Nullable ProfileResolver var1, @NotNull Profile var2);

        @NotNull
        public Builder<W, P, I, E> npcSettings(@NotNull Consumer<NpcSettings.Builder<P>> var1);

        @NotNull
        public Npc<W, P, I, E> build();

        @NotNull
        public Npc<W, P, I, E> buildAndTrack();
    }
}

