/*
 * Decompiled with CFR 0.152.
 */
package com.github.juliarn.npclib.api.protocol;

import com.github.juliarn.npclib.api.Npc;
import com.github.juliarn.npclib.api.protocol.NpcSpecificOutboundPacket;
import java.util.Collection;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

@FunctionalInterface
public interface OutboundPacket<W, P, I, E> {
    public void schedule(@NotNull P var1, @NotNull Npc<W, P, I, E> var2);

    default public void scheduleForTracked(@NotNull Npc<W, P, I, E> npc) {
        this.schedule(Npc::trackedPlayers, npc);
    }

    default public void schedule(@NotNull Function<Npc<W, P, I, E>, Collection<P>> extractor, @NotNull Npc<W, P, I, E> npc) {
        this.schedule(extractor.apply(npc), npc);
    }

    default public void schedule(@NotNull Collection<P> players, @NotNull Npc<W, P, I, E> npc) {
        players.forEach(player -> this.schedule(player, npc));
    }

    @NotNull
    default public NpcSpecificOutboundPacket<W, P, I, E> toSpecific(@NotNull Npc<W, P, I, E> targetNpc) {
        return NpcSpecificOutboundPacket.fromOutboundPacket(targetNpc, this);
    }
}

