/*
 * Decompiled with CFR 0.152.
 */
package com.github.juliarn.npclib.api;

import com.github.juliarn.npclib.api.DefaultPosition;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public interface Position {
    @NotNull
    public static Position position(double x, double y, double z, @NotNull String worldId) {
        return Position.position(x, y, z, 0.0f, 0.0f, worldId);
    }

    @NotNull
    public static Position position(double x, double y, double z, float yaw, float pitch, @NotNull String worldId) {
        Objects.requireNonNull(worldId, "world id");
        return new DefaultPosition(x, y, z, yaw, pitch, worldId);
    }

    public double x();

    public double y();

    public double z();

    public float yaw();

    public float pitch();

    @NotNull
    public String worldId();

    public int blockX();

    public int blockY();

    public int blockZ();

    public int chunkX();

    public int chunkY();

    public int chunkZ();
}

