/*
 * Decompiled with CFR 0.152.
 */
package com.github.juliarn.npclib.api.event.manager;

import com.github.juliarn.npclib.api.event.NpcEvent;
import com.github.juliarn.npclib.api.event.manager.DefaultNpcEventManager;
import com.github.juliarn.npclib.api.event.manager.NpcEventConsumer;
import com.github.juliarn.npclib.api.event.manager.NpcEventSubscription;
import com.github.juliarn.npclib.api.log.PlatformLogger;
import java.util.Objects;
import java.util.function.Predicate;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public interface NpcEventManager {
    @Contract(value="_, _ -> new")
    @NotNull
    public static NpcEventManager createDefault(boolean debugEnabled, @NotNull PlatformLogger logger) {
        Objects.requireNonNull(logger, "logger");
        return new DefaultNpcEventManager(debugEnabled, logger);
    }

    @Contract(value="_ -> param1")
    @NotNull
    public <E extends NpcEvent> E post(@NotNull E var1);

    @NotNull
    public <E extends NpcEvent> NpcEventSubscription<? super E> registerEventHandler(@NotNull Class<E> var1, @NotNull NpcEventConsumer<E> var2);

    @NotNull
    public <E extends NpcEvent> NpcEventSubscription<? super E> registerEventHandler(@NotNull Class<E> var1, @NotNull NpcEventConsumer<E> var2, int var3);

    public void unregisterEventHandlerIf(@NotNull Predicate<NpcEventSubscription<? super NpcEvent>> var1);
}

