/*
 * Decompiled with CFR 0.152.
 */
package com.github.juliarn.npclib.api.event.manager;

import com.github.juliarn.npclib.api.event.CancellableNpcEvent;
import com.github.juliarn.npclib.api.event.NpcEvent;
import com.github.juliarn.npclib.api.event.manager.DefaultNpcEventSubscription;
import com.github.juliarn.npclib.api.event.manager.EventExceptionHandler;
import com.github.juliarn.npclib.api.event.manager.NpcEventConsumer;
import com.github.juliarn.npclib.api.event.manager.NpcEventManager;
import com.github.juliarn.npclib.api.event.manager.NpcEventSubscription;
import com.github.juliarn.npclib.api.log.PlatformLogger;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;

final class DefaultNpcEventManager
implements NpcEventManager {
    private static final Comparator<NpcEventSubscription<? super NpcEvent>> SUBSCRIPTION_COMPARABLE = Comparator.comparingInt(NpcEventSubscription::order);
    private final boolean debugEnabled;
    private final PlatformLogger platformLogger;
    private final Map<Class<?>, List<NpcEventSubscription<? super NpcEvent>>> registeredSubscribers = new ConcurrentHashMap(16, 0.9f, 1);

    public DefaultNpcEventManager(boolean debugEnabled, @NotNull PlatformLogger logger) {
        this.debugEnabled = debugEnabled;
        this.platformLogger = logger;
    }

    private static boolean isEventCancelled(@NotNull NpcEvent event) {
        return event instanceof CancellableNpcEvent && ((CancellableNpcEvent)event).cancelled();
    }

    @Override
    @NotNull
    public <E extends NpcEvent> E post(@NotNull E event) {
        Objects.requireNonNull(event, "event");
        block2: for (Map.Entry<Class<?>, List<NpcEventSubscription<NpcEvent>>> entry : this.registeredSubscribers.entrySet()) {
            Class<?> subscribedEventType = entry.getKey();
            List<NpcEventSubscription<? super NpcEvent>> subscriptions = entry.getValue();
            if (!subscribedEventType.isInstance(event) || subscriptions.isEmpty()) continue;
            for (NpcEventSubscription<? super NpcEvent> subscription : subscriptions) {
                boolean eventWasCancelled = DefaultNpcEventManager.isEventCancelled(event);
                if (eventWasCancelled) continue block2;
                try {
                    subscription.eventConsumer().handle(event);
                }
                catch (Throwable throwable) {
                    EventExceptionHandler.rethrowFatalException(throwable);
                    if (!this.debugEnabled) continue;
                    this.platformLogger.error(String.format("Subscriber %s was unable to handle %s", subscription.eventConsumer().getClass().getName(), event.getClass().getSimpleName()), throwable);
                }
            }
        }
        return event;
    }

    @Override
    @NotNull
    public <E extends NpcEvent> NpcEventSubscription<? super E> registerEventHandler(@NotNull Class<E> eventType, @NotNull NpcEventConsumer<E> consumer) {
        return this.registerEventHandler(eventType, consumer, 0);
    }

    @Override
    @NotNull
    public <E extends NpcEvent> NpcEventSubscription<? super E> registerEventHandler(@NotNull Class<E> eventType, @NotNull NpcEventConsumer<E> consumer, int eventHandlerPriority) {
        DefaultNpcEventSubscription<E> subscription = new DefaultNpcEventSubscription<E>(eventHandlerPriority, eventType, consumer, this);
        List eventSubscriptions = this.registeredSubscribers.computeIfAbsent(eventType, __ -> new CopyOnWriteArrayList());
        eventSubscriptions.add(subscription);
        eventSubscriptions.sort(SUBSCRIPTION_COMPARABLE);
        return subscription;
    }

    @Override
    public void unregisterEventHandlerIf(@NotNull Predicate<NpcEventSubscription<? super NpcEvent>> subscriptionFilter) {
        for (List<NpcEventSubscription<? super NpcEvent>> subscriptions : this.registeredSubscribers.values()) {
            subscriptions.removeIf(subscriptionFilter);
        }
    }

    void removeSubscription(@NotNull NpcEventSubscription<?> subscription) {
        List<NpcEventSubscription<? super NpcEvent>> subscriptions = this.registeredSubscribers.get(subscription.eventType());
        if (subscriptions != null) {
            subscriptions.remove(subscription);
        }
    }
}

