/*
 * Decompiled with CFR 0.152.
 */
package es.outlook.adriansrj.cv.api.vehicle.model;

import es.outlook.adriansrj.cv.api.interfaces.Tickable;
import es.outlook.adriansrj.cv.api.vehicle.Vehicle;
import es.outlook.adriansrj.cv.api.vehicle.VehicleSeat;
import es.outlook.adriansrj.cv.api.vehicle.VehicleState;
import es.outlook.adriansrj.cv.api.vehicle.configuration.model.VehicleModelConfiguration;
import es.outlook.adriansrj.cv.api.vehicle.configuration.model.VehicleParticleConfiguration;
import es.outlook.adriansrj.cv.api.vehicle.configuration.model.VehicleSoundConfiguration;
import es.outlook.adriansrj.cv.api.vehicle.model.VehicleModel;
import gnu.trove.set.hash.THashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import org.apache.commons.math3.geometry.euclidean.twod.Vector2D;
import org.apache.commons.math3.util.FastMath;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class VehicleModelBase<C extends VehicleModelConfiguration>
implements VehicleModel<C> {
    @NotNull
    protected final Vehicle vehicle;
    @NotNull
    protected final C configuration;
    @NotNull
    protected World world;
    protected double x;
    protected double y;
    protected double z;
    protected float rotation;
    protected boolean spawned;
    @Nullable
    protected VehicleState state;
    protected final Set<ParticleTicker> particleTickers = new THashSet();
    protected final Set<SoundTicker> soundTickers = new THashSet();

    protected VehicleModelBase(@NotNull Vehicle vehicle, @NotNull C configuration, @NotNull World world, double x, double y, double z) {
        this.vehicle = vehicle;
        this.configuration = configuration;
        this.world = world;
        this.x = x;
        this.y = y;
        this.z = z;
        for (VehicleParticleConfiguration particleConfiguration : ((VehicleModelConfiguration)configuration).getParticles()) {
            if (!particleConfiguration.isValid()) continue;
            this.particleTickers.add(new ParticleTicker(this, particleConfiguration));
        }
        for (VehicleSoundConfiguration soundConfiguration : ((VehicleModelConfiguration)configuration).getSounds()) {
            if (!soundConfiguration.isValid()) continue;
            this.soundTickers.add(new SoundTicker(this, soundConfiguration));
        }
    }

    @Override
    @NotNull
    public C getConfiguration() {
        return this.configuration;
    }

    @Override
    public boolean isSpawned() {
        return this.spawned;
    }

    @Override
    public void tick() {
        if (!this.spawned) {
            return;
        }
        this.particleTickers.forEach(ParticleTicker::tick);
        this.soundTickers.forEach(SoundTicker::tick);
    }

    @Override
    public void setState(@Nullable VehicleState state) {
        if (!Objects.equals(this.state, state)) {
            this.state = state;
            this.onStateChanged();
        }
    }

    protected abstract void onStateChanged();

    @Override
    @NotNull
    public Location getLocation() {
        return new Location(this.world, this.x, this.y, this.z, this.rotation, 0.0f);
    }

    @Override
    @NotNull
    public World getWorld() {
        return this.world;
    }

    @Override
    public double getX() {
        return this.x;
    }

    @Override
    public double getY() {
        return this.y;
    }

    @Override
    public double getZ() {
        return this.z;
    }

    @Override
    public float getRotation() {
        return this.rotation;
    }

    @Override
    public void setLocationAndRotation(double x, double y, double z, float rotation) {
        boolean locationChanged = Double.compare(x, this.x) != 0 || Double.compare(y, this.y) != 0 || Double.compare(z, this.z) != 0;
        boolean rotationChanged = Float.compare(this.rotation, rotation %= 360.0f) != 0;
        this.x = x;
        this.y = y;
        this.z = z;
        this.rotation = rotation;
        if (locationChanged && rotationChanged) {
            this.onLocationAndRotationChanged();
        } else if (locationChanged) {
            this.onLocationChanged();
        } else {
            this.onRotationChanged();
        }
        if (locationChanged || rotationChanged) {
            this.relocateParticleTickers();
        }
    }

    @Override
    public void setLocation(double x, double y, double z) {
        if (Double.compare(x, this.x) != 0 || Double.compare(y, this.y) != 0 || Double.compare(z, this.z) != 0) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.onLocationChanged();
            this.relocateParticleTickers();
        }
    }

    @Override
    public void setRotation(float rotation) {
        if (Float.compare(this.rotation, rotation %= 360.0f) != 0) {
            this.rotation = rotation;
            this.onRotationChanged();
            this.relocateParticleTickers();
        }
    }

    protected abstract void onLocationAndRotationChanged();

    protected abstract void onLocationChanged();

    protected abstract void onRotationChanged();

    protected void relocateParticleTickers() {
        this.particleTickers.forEach(ParticleTicker::updateLocation);
    }

    protected static class ParticleTicker
    implements Tickable {
        @NotNull
        protected final VehicleModelBase<?> model;
        @NotNull
        protected final VehicleParticleConfiguration configuration;
        protected final int m;
        protected final float h;
        protected final float v;
        protected double x;
        protected double y;
        protected double z;
        protected int wait;
        protected boolean firstTick;

        public ParticleTicker(@NotNull VehicleModelBase<?> model, @NotNull VehicleParticleConfiguration configuration) {
            this.model = model;
            this.configuration = configuration;
            Vector3D offset = configuration.getOffset();
            this.v = (float)offset.getY();
            this.h = (float)FastMath.sqrt((double)(offset.getX() * offset.getX() + offset.getZ() * offset.getZ()));
            this.m = this.m(new Vector2D(offset.getX(), offset.getZ()), new Vector2D(0.0, 1.0));
        }

        @Override
        public void tick() {
            if (this.firstTick) {
                this.firstTick = false;
                this.updateLocation();
            }
            if (this.wait > 0) {
                --this.wait;
                return;
            }
            if (this.model.state == null || !this.configuration.appliesTo(this.model.state)) {
                return;
            }
            int count = this.configuration.getCount();
            int delay = this.configuration.getDelay();
            float dispersion = this.configuration.getDispersion();
            this.model.getWorld().spawnParticle(this.configuration.getType(), new Location(this.model.getWorld(), this.x, this.y, this.z), count, (double)dispersion, (double)dispersion, (double)dispersion, 0.0, this.configuration.getData());
            if (delay > 0) {
                this.wait += delay;
            }
        }

        protected void updateLocation() {
            int m = (int)FastMath.floor((double)this.model.getRotation()) + this.m + 90;
            this.y = this.model.y + (double)this.v;
            this.x = this.model.x + FastMath.cos((double)FastMath.toRadians((double)m)) * (double)this.h;
            this.z = this.model.z + FastMath.sin((double)FastMath.toRadians((double)m)) * (double)this.h;
        }

        protected int m(@NotNull Vector2D f, @NotNull Vector2D s) {
            double a = f.getX() * s.getY() - f.getY() * s.getX();
            double b = f.getX() * s.getX() + f.getY() * s.getY();
            return (int)FastMath.toDegrees((double)FastMath.atan2((double)a, (double)b));
        }
    }

    protected static class SoundTicker
    implements Tickable {
        @NotNull
        protected final VehicleModelBase<?> model;
        @NotNull
        protected final VehicleSoundConfiguration configuration;
        protected int wait;

        public SoundTicker(@NotNull VehicleModelBase<?> model, @NotNull VehicleSoundConfiguration configuration) {
            this.model = model;
            this.configuration = configuration;
        }

        @Override
        public void tick() {
            if (this.wait > 0) {
                --this.wait;
                return;
            }
            if (!this.configuration.isValid()) {
                return;
            }
            if (this.model.state == null || !this.configuration.appliesTo(this.model.state)) {
                return;
            }
            Location location = this.model.getLocation();
            if (this.configuration.isGlobal()) {
                this.playGlobally(location);
            } else {
                this.playToPassengers(location);
            }
        }

        protected void playGlobally(@NotNull Location location) {
            World world = location.getWorld();
            if (world == null) {
                return;
            }
            SoundCategory category = this.configuration.getCategory();
            Sound type = this.configuration.getType();
            String typeCustom = this.configuration.getTypeCustom();
            float volume = this.configuration.getVolume();
            float pitch = this.configuration.getPitch();
            if (type != null) {
                if (category != null) {
                    world.playSound(location, type, category, volume, pitch);
                } else {
                    world.playSound(location, type, volume, pitch);
                }
            } else if (StringUtils.isNotBlank((String)typeCustom)) {
                if (category != null) {
                    world.playSound(location, typeCustom, category, volume, pitch);
                } else {
                    world.playSound(location, typeCustom, volume, pitch);
                }
            }
        }

        protected void playToPassengers(@NotNull Location location) {
            SoundCategory category = this.configuration.getCategory();
            Sound type = this.configuration.getType();
            String typeCustom = this.configuration.getTypeCustom();
            float volume = this.configuration.getVolume();
            float pitch = this.configuration.getPitch();
            for (VehicleSeat vehicleSeat : this.model.vehicle.getSeats()) {
                if (!(vehicleSeat.getPassenger() instanceof Player)) continue;
                Player player = (Player)vehicleSeat.getPassenger();
                if (type != null) {
                    if (category != null) {
                        player.playSound(location, type, category, volume, pitch);
                        continue;
                    }
                    player.playSound(location, type, volume, pitch);
                    continue;
                }
                if (!StringUtils.isNotBlank((String)typeCustom)) continue;
                if (category != null) {
                    player.playSound(location, typeCustom, category, volume, pitch);
                    continue;
                }
                player.playSound(location, typeCustom, volume, pitch);
            }
        }
    }
}

