/*
 * Decompiled with CFR 0.152.
 */
package es.outlook.adriansrj.cv.api.vehicle.input;

import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.reflect.StructureModifier;
import es.outlook.adriansrj.cv.api.interfaces.VersionSensible;
import org.jetbrains.annotations.NotNull;

@VersionSensible
public class PlayerSteerInput {
    public final int sideways;
    public final int forward;
    public final boolean jump;
    public final boolean unmount;
    public final boolean keepAlive;

    public static PlayerSteerInput fromPacket(@NotNull PacketContainer packet) {
        StructureModifier floats = packet.getFloat();
        StructureModifier booleans = packet.getBooleans();
        float sideways = ((Float)floats.read(0)).floatValue();
        float forward = ((Float)floats.read(1)).floatValue();
        boolean jump = (Boolean)booleans.read(0);
        boolean unmount = (Boolean)booleans.read(1);
        return new PlayerSteerInput(sideways != 0.0f ? (sideways < 0.0f ? -1 : 1) : 0, forward != 0.0f ? (forward < 0.0f ? -1 : 1) : 0, jump, unmount);
    }

    public PlayerSteerInput(int sideways, int forward, boolean jump, boolean unmount) {
        this.sideways = sideways;
        this.forward = forward;
        this.jump = jump;
        this.unmount = unmount;
        this.keepAlive = sideways == 0 && forward == 0 && !jump && !unmount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PlayerSteerInput that = (PlayerSteerInput)o;
        if (this.sideways != that.sideways) {
            return false;
        }
        if (this.forward != that.forward) {
            return false;
        }
        if (this.jump != that.jump) {
            return false;
        }
        if (this.unmount != that.unmount) {
            return false;
        }
        return this.keepAlive == that.keepAlive;
    }

    public int hashCode() {
        int result = this.sideways;
        result = 31 * result + this.forward;
        result = 31 * result + (this.jump ? 1 : 0);
        result = 31 * result + (this.unmount ? 1 : 0);
        result = 31 * result + (this.keepAlive ? 1 : 0);
        return result;
    }
}

