/*
 * Decompiled with CFR 0.152.
 */
package es.outlook.adriansrj.cv.api.vehicle.controller.predefined;

import es.outlook.adriansrj.cv.api.configuration.Configuration;
import es.outlook.adriansrj.cv.api.enums.EnumSurface;
import es.outlook.adriansrj.cv.api.vehicle.Vehicle;
import es.outlook.adriansrj.cv.api.vehicle.VehicleState;
import es.outlook.adriansrj.cv.api.vehicle.configuration.VehicleFuelConfiguration;
import es.outlook.adriansrj.cv.api.vehicle.controller.VehicleController;
import es.outlook.adriansrj.cv.api.vehicle.controller.VehicleControllerProperties;
import es.outlook.adriansrj.cv.api.vehicle.input.PlayerSteerInput;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.math3.util.FastMath;
import org.bukkit.GameMode;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WatercraftVehicleController
extends VehicleController {
    protected static final Collection<EnumSurface> SURFACE_SCAN_IGNORE = Arrays.asList(EnumSurface.EMPTY, EnumSurface.UNKNOWN);
    protected double maxPositiveAcceleration;
    protected double maxNegativeAcceleration;
    protected double positiveAccelerationOnWater;
    protected double positiveAccelerationOnLava;
    protected double negativeAccelerationOnWater;
    protected double negativeAccelerationOnLava;
    protected double deceleration;
    protected int turningAngleMin;
    protected int turningAngleMax;
    protected float minFuelConsumption;
    protected float maxFuelConsumption;
    protected boolean forward;
    protected boolean backward;
    protected boolean turningLeft;
    protected boolean turningRight;
    protected double currentSpeed;
    protected int currentTurningAngle;

    public WatercraftVehicleController(@NotNull Vehicle vehicle, @Nullable VehicleControllerProperties properties) {
        super(vehicle, properties);
    }

    @Override
    protected void loadProperties() {
        this.maxPositiveAcceleration = this.properties.getDoubleProperty("max-positive-acceleration", 0.12);
        this.maxNegativeAcceleration = this.properties.getDoubleProperty("max-negative-acceleration", 0.22);
        this.positiveAccelerationOnWater = this.properties.getDoubleProperty("positive-acceleration-on-water", 0.025);
        this.positiveAccelerationOnLava = this.properties.getDoubleProperty("positive-acceleration-on-lava", 0.025);
        this.negativeAccelerationOnWater = this.properties.getDoubleProperty("negative-acceleration-on-water", 0.025);
        this.negativeAccelerationOnLava = this.properties.getDoubleProperty("negative-acceleration-on-lava", 0.025);
        this.deceleration = this.properties.getDoubleProperty("deceleration", 0.015);
        this.turningAngleMin = this.properties.getIntegerProperty("turning-angle-min", 1);
        this.turningAngleMax = this.properties.getIntegerProperty("turning-angle-max", 3);
        VehicleFuelConfiguration fuelConfiguration = this.vehicle.getConfiguration().getFuel();
        this.minFuelConsumption = this.properties.getMinFuelConsumptionOverride(fuelConfiguration.getMinConsumption());
        this.maxFuelConsumption = this.properties.getMaxFuelConsumptionOverride(fuelConfiguration.getMaxConsumption());
    }

    @Override
    public void tick() {
        Map<EnumSurface, Double> surface = null;
        if ((this.forward || this.backward) && this.hasFuel()) {
            surface = this.vehicle.getCurrentSurface(SURFACE_SCAN_IGNORE);
            double acceleration = this.calculateAcceleration(surface, this.forward);
            if (acceleration != 0.0 && this.vehicle.containsAnyWithin(EnumSurface.WATER, EnumSurface.LAVA, EnumSurface.SOLID)) {
                acceleration = 0.0;
            }
            if (this.forward && acceleration != 0.0) {
                this.currentSpeed = Math.min(this.currentSpeed + acceleration, this.maxPositiveAcceleration);
            } else if (this.backward && acceleration != 0.0) {
                this.currentSpeed = Math.max(this.currentSpeed - acceleration, -this.maxNegativeAcceleration);
            }
        }
        this.tickTurning();
        if (this.currentSpeed != 0.0 && this.isOnLiquid(surface != null ? surface : this.vehicle.getCurrentSurface(SURFACE_SCAN_IGNORE))) {
            float facing = this.vehicle.getRotation();
            if (this.currentTurningAngle != 0) {
                facing = this.currentSpeed > 0.0 ? (this.turningLeft ? (facing -= (float)this.currentTurningAngle) : (facing += (float)this.currentTurningAngle)) : (this.turningLeft ? (facing += (float)this.currentTurningAngle) : (facing -= (float)this.currentTurningAngle));
                this.vehicle.setRotation(facing);
            }
            double x = -FastMath.sin((double)FastMath.toRadians((double)facing));
            double z = FastMath.cos((double)FastMath.toRadians((double)facing));
            this.vehicle.addMomentumX(this.currentSpeed * x);
            this.vehicle.addMomentumZ(this.currentSpeed * z);
            this.tickFuelConsumption();
        }
        this.tickDeceleration();
        this.tickState();
    }

    private boolean hasFuel() {
        if (this.maxFuelConsumption <= 0.0f) {
            return true;
        }
        float fuelLevel = this.vehicle.getFuelLevel();
        boolean fuelSystemDisabled = !Configuration.FUEL_ENABLE.booleanValue();
        boolean bypassCreative = Configuration.FUEL_BYPASS_CREATIVE.booleanValue();
        Entity operator = this.vehicle.getOperator();
        return fuelSystemDisabled || fuelLevel > 0.0f || bypassCreative && operator instanceof Player && ((Player)operator).getGameMode() == GameMode.CREATIVE;
    }

    private void tickFuelConsumption() {
        if (this.currentSpeed == 0.0 || this.minFuelConsumption > this.maxFuelConsumption || (double)this.maxFuelConsumption <= 0.0) {
            return;
        }
        double maxAcceleration = this.currentSpeed > 0.0 ? this.maxPositiveAcceleration : this.maxNegativeAcceleration;
        double relative = FastMath.abs((double)this.currentSpeed) / FastMath.abs((double)maxAcceleration);
        float consumption = this.minFuelConsumption + (float)FastMath.round((double)((double)(this.maxFuelConsumption - this.minFuelConsumption) * relative));
        if (consumption > 0.0f) {
            this.vehicle.consumeFuel(consumption);
        }
    }

    private void tickTurning() {
        if (this.turningLeft || this.turningRight) {
            double maxAcceleration = this.currentSpeed > 0.0 ? this.maxPositiveAcceleration : this.maxNegativeAcceleration;
            double relative = FastMath.abs((double)this.currentSpeed) / FastMath.abs((double)maxAcceleration);
            int angle = this.turningAngleMin + (int)FastMath.round((double)((double)(this.turningAngleMax - this.turningAngleMin) * relative));
            this.currentTurningAngle = Math.max(angle, 0);
        } else {
            this.currentTurningAngle = 0;
        }
    }

    private void tickDeceleration() {
        if (this.currentSpeed > 0.0) {
            this.currentSpeed = Math.max(0.0, this.currentSpeed - this.deceleration);
        } else if (this.currentSpeed < 0.0) {
            this.currentSpeed = Math.min(0.0, this.currentSpeed + this.deceleration);
        }
    }

    private void tickState() {
        if (this.vehicle.getMomentumX() != 0.0 || this.vehicle.getMomentumZ() != 0.0) {
            VehicleState state;
            boolean backwards = this.currentSpeed < 0.0;
            VehicleState vehicleState = state = backwards ? VehicleState.MOVING_BACKWARDS : VehicleState.MOVING;
            if (this.turningLeft) {
                state = backwards ? VehicleState.MOVING_BACKWARDS_TURNING_LEFT : VehicleState.MOVING_TURNING_LEFT;
            } else if (this.turningRight) {
                state = backwards ? VehicleState.MOVING_BACKWARDS_TURNING_RIGHT : VehicleState.MOVING_TURNING_RIGHT;
            }
            this.vehicle.setState(state);
        } else if (this.turningLeft) {
            this.vehicle.setState(VehicleState.TURNING_LEFT);
        } else if (this.turningRight) {
            this.vehicle.setState(VehicleState.TURNING_RIGHT);
        } else {
            this.vehicle.setState(VehicleState.IDLE);
        }
    }

    protected boolean isOnLiquid(@NotNull Map<EnumSurface, Double> surface) {
        return surface.containsKey((Object)EnumSurface.WATER) || surface.containsKey((Object)EnumSurface.LAVA);
    }

    protected double calculateAcceleration(@NotNull Map<EnumSurface, Double> surface, boolean positive) {
        double acceleration = 0.0;
        for (Map.Entry<EnumSurface, Double> entry : surface.entrySet()) {
            acceleration += this.getAccelerationOn(entry.getKey(), positive) * entry.getValue();
        }
        return acceleration;
    }

    protected double getAccelerationOn(@NotNull EnumSurface surface, boolean positive) {
        switch (surface) {
            case WATER: {
                return positive ? this.positiveAccelerationOnWater : this.negativeAccelerationOnWater;
            }
            case LAVA: {
                return positive ? this.positiveAccelerationOnLava : this.negativeAccelerationOnLava;
            }
        }
        return 0.0;
    }

    @Override
    public void process(@NotNull PlayerSteerInput input) {
        this.forward = input.forward > 0;
        this.backward = input.forward < 0;
        this.turningLeft = input.sideways > 0;
        this.turningRight = input.sideways < 0;
    }

    @Override
    public void standby() {
        this.forward = false;
        this.backward = false;
        this.turningLeft = false;
        this.turningRight = false;
    }
}

