/*
 * Decompiled with CFR 0.152.
 */
package es.outlook.adriansrj.cv.api.vehicle.controller.predefined;

import es.outlook.adriansrj.cv.api.configuration.Configuration;
import es.outlook.adriansrj.cv.api.enums.EnumSurface;
import es.outlook.adriansrj.cv.api.vehicle.Vehicle;
import es.outlook.adriansrj.cv.api.vehicle.VehicleState;
import es.outlook.adriansrj.cv.api.vehicle.configuration.VehicleFuelConfiguration;
import es.outlook.adriansrj.cv.api.vehicle.controller.VehicleController;
import es.outlook.adriansrj.cv.api.vehicle.controller.VehicleControllerProperties;
import es.outlook.adriansrj.cv.api.vehicle.input.PlayerSteerInput;
import org.apache.commons.math3.util.FastMath;
import org.bukkit.GameMode;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RotorcraftVehicleController
extends VehicleController {
    protected double maxPositiveAcceleration;
    protected double maxNegativeAcceleration;
    protected double positiveAcceleration;
    protected double negativeAcceleration;
    protected double deceleration;
    protected double increaseHeightSpeed;
    protected double decreaseHeightSpeed;
    protected int rotationAngle;
    protected float minFuelConsumption;
    protected float maxFuelConsumption;
    protected boolean forward;
    protected boolean backward;
    protected boolean increasingHeight;
    protected boolean decreasingHeight;
    protected boolean rotatingLeft;
    protected boolean rotatingRight;
    protected double currentSpeed;

    public RotorcraftVehicleController(@NotNull Vehicle vehicle, @Nullable VehicleControllerProperties properties) {
        super(vehicle, properties);
    }

    @Override
    protected void loadProperties() {
        this.maxPositiveAcceleration = this.properties.getDoubleProperty("max-positive-acceleration", 0.95);
        this.maxNegativeAcceleration = this.properties.getDoubleProperty("max-negative-acceleration", 0.25);
        this.positiveAcceleration = this.properties.getDoubleProperty("positive-acceleration", 0.055);
        this.negativeAcceleration = this.properties.getDoubleProperty("negative-acceleration", 0.035);
        this.deceleration = this.properties.getDoubleProperty("deceleration", 0.04);
        this.increaseHeightSpeed = this.properties.getDoubleProperty("increase-height-speed", 0.23);
        this.decreaseHeightSpeed = this.properties.getDoubleProperty("decrease-height-speed", 0.23);
        this.rotationAngle = this.properties.getIntegerProperty("rotation-angle", 3);
        VehicleFuelConfiguration fuelConfiguration = this.vehicle.getConfiguration().getFuel();
        this.minFuelConsumption = this.properties.getMinFuelConsumptionOverride(fuelConfiguration.getMinConsumption());
        this.maxFuelConsumption = this.properties.getMaxFuelConsumptionOverride(fuelConfiguration.getMaxConsumption());
    }

    @Override
    public void tick() {
        boolean consumeFuel = false;
        if ((this.forward || this.backward) && this.hasFuel() && !this.vehicle.containsAnyWithin(EnumSurface.WATER, EnumSurface.LAVA, EnumSurface.SOLID)) {
            if (this.forward && this.positiveAcceleration != 0.0) {
                this.currentSpeed = Math.min(this.currentSpeed + this.positiveAcceleration, this.maxPositiveAcceleration);
            } else if (this.backward && this.negativeAcceleration != 0.0) {
                this.currentSpeed = Math.max(this.currentSpeed - this.negativeAcceleration, -this.maxNegativeAcceleration);
            }
        }
        if (this.increasingHeight || this.decreasingHeight) {
            if (this.increasingHeight) {
                this.vehicle.addMomentumY(this.increaseHeightSpeed);
            } else {
                this.vehicle.addMomentumY(-this.decreaseHeightSpeed);
            }
            consumeFuel = true;
        }
        this.tickRotation();
        if (this.currentSpeed != 0.0 && this.vehicle.isInTheAir()) {
            float facing = this.vehicle.getRotation();
            double x = -FastMath.sin((double)FastMath.toRadians((double)facing));
            double z = FastMath.cos((double)FastMath.toRadians((double)facing));
            this.vehicle.addMomentumX(this.currentSpeed * x);
            this.vehicle.addMomentumZ(this.currentSpeed * z);
        }
        if (consumeFuel) {
            this.tickFuelConsumption();
        }
        this.tickDeceleration();
        this.tickState();
    }

    private boolean hasFuel() {
        if (this.maxFuelConsumption <= 0.0f) {
            return true;
        }
        float fuelLevel = this.vehicle.getFuelLevel();
        boolean fuelSystemDisabled = !Configuration.FUEL_ENABLE.booleanValue();
        boolean bypassCreative = Configuration.FUEL_BYPASS_CREATIVE.booleanValue();
        Entity operator = this.vehicle.getOperator();
        return fuelSystemDisabled || fuelLevel > 0.0f || bypassCreative && operator instanceof Player && ((Player)operator).getGameMode() == GameMode.CREATIVE;
    }

    private void tickFuelConsumption() {
        if (this.currentSpeed == 0.0 || this.minFuelConsumption > this.maxFuelConsumption || (double)this.maxFuelConsumption <= 0.0) {
            return;
        }
        double maxAcceleration = this.currentSpeed > 0.0 ? this.maxPositiveAcceleration : this.maxNegativeAcceleration;
        double relative = FastMath.abs((double)this.currentSpeed) / FastMath.abs((double)maxAcceleration);
        float consumption = this.minFuelConsumption + (float)FastMath.round((double)((double)(this.maxFuelConsumption - this.minFuelConsumption) * relative));
        if (consumption > 0.0f) {
            this.vehicle.consumeFuel(consumption);
        }
    }

    private void tickRotation() {
        if (this.rotatingLeft || this.rotatingRight) {
            float facing = this.vehicle.getRotation();
            facing = this.currentSpeed >= 0.0 ? (this.rotatingLeft ? (facing -= (float)this.rotationAngle) : (facing += (float)this.rotationAngle)) : (this.rotatingLeft ? (facing += (float)this.rotationAngle) : (facing -= (float)this.rotationAngle));
            this.vehicle.setRotation(facing);
        }
    }

    private void tickDeceleration() {
        if (this.currentSpeed > 0.0) {
            this.currentSpeed = Math.max(0.0, this.currentSpeed - this.deceleration);
        } else if (this.currentSpeed < 0.0) {
            this.currentSpeed = Math.min(0.0, this.currentSpeed + this.deceleration);
        }
    }

    private void tickState() {
        if (this.increasingHeight || this.decreasingHeight) {
            VehicleState state;
            VehicleState vehicleState = state = this.increasingHeight ? VehicleState.INCREASING_HEIGHT : VehicleState.DECREASING_HEIGHT;
            if (this.rotatingLeft) {
                state = this.increasingHeight ? VehicleState.INCREASING_HEIGHT_TURNING_LEFT : VehicleState.DECREASING_HEIGHT_TURNING_LEFT;
            } else if (this.rotatingRight) {
                state = this.increasingHeight ? VehicleState.INCREASING_HEIGHT_TURNING_RIGHT : VehicleState.DECREASING_HEIGHT_TURNING_RIGHT;
            }
            this.vehicle.setState(state);
        } else if (this.vehicle.getMomentumX() != 0.0 || this.vehicle.getMomentumZ() != 0.0) {
            VehicleState state;
            boolean backwards = this.currentSpeed < 0.0;
            VehicleState vehicleState = state = backwards ? VehicleState.MOVING_BACKWARDS : VehicleState.MOVING;
            if (this.rotatingLeft) {
                state = backwards ? VehicleState.MOVING_BACKWARDS_TURNING_LEFT : VehicleState.MOVING_TURNING_LEFT;
            } else if (this.rotatingRight) {
                state = backwards ? VehicleState.MOVING_BACKWARDS_TURNING_RIGHT : VehicleState.MOVING_TURNING_RIGHT;
            }
            this.vehicle.setState(state);
        } else if (this.rotatingLeft) {
            this.vehicle.setState(VehicleState.TURNING_LEFT);
        } else if (this.rotatingRight) {
            this.vehicle.setState(VehicleState.TURNING_RIGHT);
        } else {
            this.vehicle.setState(VehicleState.IDLE);
        }
    }

    @Override
    public void process(@NotNull PlayerSteerInput input) {
        this.forward = input.forward > 0;
        this.backward = input.forward < 0;
        this.increasingHeight = input.jump;
        this.decreasingHeight = input.unmount;
        this.rotatingLeft = input.sideways > 0;
        this.rotatingRight = input.sideways < 0;
    }

    @Override
    public void standby() {
        this.forward = false;
        this.backward = false;
        this.increasingHeight = false;
        this.decreasingHeight = false;
        this.rotatingLeft = false;
        this.rotatingRight = false;
    }
}

