/*
 * Decompiled with CFR 0.152.
 */
package es.outlook.adriansrj.cv.api.vehicle.controller;

import es.outlook.adriansrj.cv.api.interfaces.ConfigurationSectionWritable;
import es.outlook.adriansrj.cv.api.interfaces.IDeyed;
import es.outlook.adriansrj.cv.api.util.reflection.EnumReflection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VehicleControllerProperties
implements ConfigurationSectionWritable {
    @NotNull
    protected final Map<String, Object> values = new HashMap<String, Object>();

    public static VehicleControllerProperties load(@NotNull ConfigurationSection section) throws InvalidConfigurationException {
        HashMap<String, Object> values = new HashMap<String, Object>();
        for (Map.Entry entry : section.getValues(false).entrySet()) {
            Object value = entry.getValue();
            if (value == null) continue;
            values.put(IDeyed.idCheck((String)entry.getKey()), value);
        }
        return new VehicleControllerProperties(values);
    }

    public VehicleControllerProperties(@Nullable Map<String, Object> values) {
        if (values != null) {
            for (Map.Entry<String, Object> entry : values.entrySet()) {
                this.values.put(IDeyed.idCheck(entry.getKey()), entry.getValue());
            }
        }
    }

    public VehicleControllerProperties() {
        this(null);
    }

    public Map<String, Object> getValues() {
        return Collections.unmodifiableMap(this.values);
    }

    public String getStringProperty(@NotNull String key, @Nullable String defaultValue) {
        return this.getProperty(String.class, key, defaultValue);
    }

    public boolean getBooleanProperty(@NotNull String key, boolean defaultValue) {
        return this.getProperty(Boolean.class, key, defaultValue);
    }

    public int getIntegerProperty(@NotNull String key, int defaultValue) {
        return this.getNumericProperty(key, defaultValue).intValue();
    }

    public float getFloatProperty(@NotNull String key, float defaultValue) {
        return this.getNumericProperty(key, Float.valueOf(defaultValue)).floatValue();
    }

    public double getDoubleProperty(@NotNull String key, double defaultValue) {
        return this.getNumericProperty(key, defaultValue).doubleValue();
    }

    public Number getNumericProperty(@NotNull String key, @Nullable Number defaultValue) {
        return this.getProperty(Number.class, key, defaultValue);
    }

    public <T extends Enum<T>> T getEnumProperty(@NotNull String key, @NotNull Class<T> enumClass, @Nullable T defaultValue) {
        T value;
        Object nameRaw = this.values.get(key);
        if (nameRaw instanceof String && (value = EnumReflection.getEnumConstant(enumClass, (String)nameRaw)) != null) {
            return value;
        }
        return defaultValue;
    }

    public <T> T getProperty(@NotNull Class<T> type, @NotNull String key, @Nullable T defaultValue) {
        Object value = this.values.get(key);
        return value != null && type.isAssignableFrom(value.getClass()) ? type.cast(value) : defaultValue;
    }

    public float getMinFuelConsumptionOverride(float original) {
        return this.getFloatProperty("min-fuel-consumption", original);
    }

    public float getMaxFuelConsumptionOverride(float original) {
        return this.getFloatProperty("max-fuel-consumption", original);
    }

    @Override
    public void write(@NotNull ConfigurationSection section) {
        for (Map.Entry<String, Object> entry : this.values.entrySet()) {
            section.set(entry.getKey(), entry.getValue());
        }
    }
}

