/*
 * Decompiled with CFR 0.152.
 */
package es.outlook.adriansrj.cv.api.vehicle.controller;

import es.outlook.adriansrj.cv.api.interfaces.IDeyed;
import es.outlook.adriansrj.cv.api.vehicle.Vehicle;
import es.outlook.adriansrj.cv.api.vehicle.controller.VehicleControllerProperties;
import es.outlook.adriansrj.cv.api.vehicle.input.PlayerSteerInput;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class VehicleController {
    @NotNull
    protected final Vehicle vehicle;
    @NotNull
    protected final VehicleControllerProperties properties;

    public VehicleController(@NotNull Vehicle vehicle, @Nullable VehicleControllerProperties properties) {
        this.vehicle = vehicle;
        this.properties = properties != null ? properties : new VehicleControllerProperties();
        this.loadProperties();
    }

    protected abstract void loadProperties();

    @NotNull
    public Vehicle getVehicle() {
        return this.vehicle;
    }

    @NotNull
    public VehicleControllerProperties getProperties() {
        return this.properties;
    }

    public abstract void tick();

    public abstract void process(@NotNull PlayerSteerInput var1);

    public abstract void standby();

    public static abstract class Factory
    implements IDeyed {
        @NotNull
        public abstract String getControllerId();

        @NotNull
        public abstract VehicleController createInstance(@NotNull Vehicle var1, @Nullable VehicleControllerProperties var2);

        @Override
        @NotNull
        public final String getId() {
            return IDeyed.idCheck(this.getControllerId());
        }
    }
}

