/*
 * Decompiled with CFR 0.152.
 */
package es.outlook.adriansrj.cv.api.vehicle.configuration.model.compound.pre19;

import es.outlook.adriansrj.cv.api.enums.EnumVehicleModelType;
import es.outlook.adriansrj.cv.api.util.ConfigurationUtil;
import es.outlook.adriansrj.cv.api.vehicle.configuration.model.VehicleHitBoxConfiguration;
import es.outlook.adriansrj.cv.api.vehicle.configuration.model.VehicleModelConfiguration;
import es.outlook.adriansrj.cv.api.vehicle.configuration.model.VehicleParticleConfiguration;
import es.outlook.adriansrj.cv.api.vehicle.configuration.model.VehicleSeatConfiguration;
import es.outlook.adriansrj.cv.api.vehicle.configuration.model.VehicleSoundConfiguration;
import es.outlook.adriansrj.cv.api.vehicle.configuration.model.compound.pre19.PartConfiguration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Pre19CompoundModelConfiguration
extends VehicleModelConfiguration {
    @NotNull
    private final Set<PartConfiguration> parts;

    public Pre19CompoundModelConfiguration(@NotNull String id, @NotNull VehicleHitBoxConfiguration hitBox, @NotNull Collection<VehicleSeatConfiguration> seats, @NotNull Collection<PartConfiguration> parts, @Nullable Collection<VehicleParticleConfiguration> particles, @Nullable Collection<VehicleSoundConfiguration> sounds) {
        super(id, hitBox, seats, particles, sounds);
        this.parts = new HashSet<PartConfiguration>(parts);
    }

    public Pre19CompoundModelConfiguration(@NotNull ConfigurationSection section) throws InvalidConfigurationException {
        super(section);
        this.parts = new HashSet<PartConfiguration>();
        for (ConfigurationSection partSection : ConfigurationUtil.getConfigurationSectionsAfter(section, "parts", false)) {
            try {
                this.parts.add(PartConfiguration.load(partSection));
            }
            catch (InvalidConfigurationException ex) {
                ex.printStackTrace();
            }
        }
        if (this.parts.size() == 0) {
            throw new InvalidConfigurationException("at least one valid part is required");
        }
    }

    @Override
    @NotNull
    public EnumVehicleModelType getType() {
        return EnumVehicleModelType.COMPOUND;
    }

    @NotNull
    public Set<PartConfiguration> getParts() {
        return Collections.unmodifiableSet(this.parts);
    }

    @Override
    public void write(@NotNull ConfigurationSection section) {
        super.write(section);
        ConfigurationUtil.writeConfigurationSectionWritables(section.createSection("parts"), this.parts, "part-");
    }

    public static Pre19CompoundModelConfigurationBuilder builder() {
        return new Pre19CompoundModelConfigurationBuilder();
    }

    public static class Pre19CompoundModelConfigurationBuilder {
        private String id;
        private VehicleHitBoxConfiguration hitBox;
        private ArrayList<VehicleSeatConfiguration> seats;
        private ArrayList<PartConfiguration> parts;
        private ArrayList<VehicleParticleConfiguration> particles;
        private ArrayList<VehicleSoundConfiguration> sounds;

        Pre19CompoundModelConfigurationBuilder() {
        }

        public Pre19CompoundModelConfigurationBuilder id(@NotNull String id) {
            if (id == null) {
                throw new NullPointerException("id is marked non-null but is null");
            }
            this.id = id;
            return this;
        }

        public Pre19CompoundModelConfigurationBuilder hitBox(@NotNull VehicleHitBoxConfiguration hitBox) {
            if (hitBox == null) {
                throw new NullPointerException("hitBox is marked non-null but is null");
            }
            this.hitBox = hitBox;
            return this;
        }

        public Pre19CompoundModelConfigurationBuilder seat(VehicleSeatConfiguration seat) {
            if (this.seats == null) {
                this.seats = new ArrayList();
            }
            this.seats.add(seat);
            return this;
        }

        public Pre19CompoundModelConfigurationBuilder seats(Collection<? extends VehicleSeatConfiguration> seats) {
            if (seats == null) {
                throw new NullPointerException("seats cannot be null");
            }
            if (this.seats == null) {
                this.seats = new ArrayList();
            }
            this.seats.addAll(seats);
            return this;
        }

        public Pre19CompoundModelConfigurationBuilder clearSeats() {
            if (this.seats != null) {
                this.seats.clear();
            }
            return this;
        }

        public Pre19CompoundModelConfigurationBuilder part(PartConfiguration part) {
            if (this.parts == null) {
                this.parts = new ArrayList();
            }
            this.parts.add(part);
            return this;
        }

        public Pre19CompoundModelConfigurationBuilder parts(Collection<? extends PartConfiguration> parts) {
            if (parts == null) {
                throw new NullPointerException("parts cannot be null");
            }
            if (this.parts == null) {
                this.parts = new ArrayList();
            }
            this.parts.addAll(parts);
            return this;
        }

        public Pre19CompoundModelConfigurationBuilder clearParts() {
            if (this.parts != null) {
                this.parts.clear();
            }
            return this;
        }

        public Pre19CompoundModelConfigurationBuilder particle(VehicleParticleConfiguration particle) {
            if (this.particles == null) {
                this.particles = new ArrayList();
            }
            this.particles.add(particle);
            return this;
        }

        public Pre19CompoundModelConfigurationBuilder particles(Collection<? extends VehicleParticleConfiguration> particles) {
            if (particles == null) {
                throw new NullPointerException("particles cannot be null");
            }
            if (this.particles == null) {
                this.particles = new ArrayList();
            }
            this.particles.addAll(particles);
            return this;
        }

        public Pre19CompoundModelConfigurationBuilder clearParticles() {
            if (this.particles != null) {
                this.particles.clear();
            }
            return this;
        }

        public Pre19CompoundModelConfigurationBuilder sound(VehicleSoundConfiguration sound) {
            if (this.sounds == null) {
                this.sounds = new ArrayList();
            }
            this.sounds.add(sound);
            return this;
        }

        public Pre19CompoundModelConfigurationBuilder sounds(Collection<? extends VehicleSoundConfiguration> sounds) {
            if (sounds == null) {
                throw new NullPointerException("sounds cannot be null");
            }
            if (this.sounds == null) {
                this.sounds = new ArrayList();
            }
            this.sounds.addAll(sounds);
            return this;
        }

        public Pre19CompoundModelConfigurationBuilder clearSounds() {
            if (this.sounds != null) {
                this.sounds.clear();
            }
            return this;
        }

        public Pre19CompoundModelConfiguration build() {
            List<VehicleSoundConfiguration> sounds;
            List<VehicleParticleConfiguration> particles;
            List<PartConfiguration> parts;
            List<VehicleSeatConfiguration> seats;
            switch (this.seats == null ? 0 : this.seats.size()) {
                case 0: {
                    seats = Collections.emptyList();
                    break;
                }
                case 1: {
                    seats = Collections.singletonList(this.seats.get(0));
                    break;
                }
                default: {
                    seats = Collections.unmodifiableList(new ArrayList<VehicleSeatConfiguration>(this.seats));
                }
            }
            switch (this.parts == null ? 0 : this.parts.size()) {
                case 0: {
                    parts = Collections.emptyList();
                    break;
                }
                case 1: {
                    parts = Collections.singletonList(this.parts.get(0));
                    break;
                }
                default: {
                    parts = Collections.unmodifiableList(new ArrayList<PartConfiguration>(this.parts));
                }
            }
            switch (this.particles == null ? 0 : this.particles.size()) {
                case 0: {
                    particles = Collections.emptyList();
                    break;
                }
                case 1: {
                    particles = Collections.singletonList(this.particles.get(0));
                    break;
                }
                default: {
                    particles = Collections.unmodifiableList(new ArrayList<VehicleParticleConfiguration>(this.particles));
                }
            }
            switch (this.sounds == null ? 0 : this.sounds.size()) {
                case 0: {
                    sounds = Collections.emptyList();
                    break;
                }
                case 1: {
                    sounds = Collections.singletonList(this.sounds.get(0));
                    break;
                }
                default: {
                    sounds = Collections.unmodifiableList(new ArrayList<VehicleSoundConfiguration>(this.sounds));
                }
            }
            return new Pre19CompoundModelConfiguration(this.id, this.hitBox, seats, parts, particles, sounds);
        }

        public String toString() {
            return "Pre19CompoundModelConfiguration.Pre19CompoundModelConfigurationBuilder(id=" + this.id + ", hitBox=" + this.hitBox + ", seats=" + this.seats + ", parts=" + this.parts + ", particles=" + this.particles + ", sounds=" + this.sounds + ")";
        }
    }
}

