/*
 * Decompiled with CFR 0.152.
 */
package es.outlook.adriansrj.cv.api.vehicle.configuration.model.compound.pre19;

import es.outlook.adriansrj.cv.api.interfaces.ConfigurationSectionWritable;
import es.outlook.adriansrj.cv.api.util.ConfigurationUtil;
import es.outlook.adriansrj.cv.api.util.inventory.ItemStackUtil;
import org.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PartTextureConfiguration
implements ConfigurationSectionWritable {
    @NotNull
    private final Material material;
    @Nullable
    private final Integer customModelData;
    @Nullable
    private final Vector3D rotation;

    public static PartTextureConfiguration load(@NotNull ConfigurationSection section) throws InvalidConfigurationException {
        Material material = ConfigurationUtil.loadEnum(Material.class, section, "material");
        if (material == null) {
            throw new InvalidConfigurationException("invalid material: " + section.getString("material"));
        }
        Vector3D rotation = ConfigurationUtil.loadLibraryObject(Vector3D.class, section, "rotation");
        Object customModelDataRaw = section.get("custom-model-data");
        Integer customModelData = customModelDataRaw instanceof Number ? Integer.valueOf(((Number)customModelDataRaw).intValue()) : null;
        return new PartTextureConfiguration(material, customModelData, rotation);
    }

    @NotNull
    public ItemStack getItemStack() {
        return ItemStackUtil.buildCustomItem(this.material, this.customModelData);
    }

    @Override
    public void write(@NotNull ConfigurationSection section) {
        section.set("material", (Object)this.material.name());
        if (this.customModelData != null) {
            section.set("custom-model-data", (Object)this.customModelData);
        }
        if (this.rotation != null) {
            ConfigurationUtil.writeLibraryObject(Vector3D.class, this.rotation, section.createSection("rotation"));
        }
    }

    public static PartTextureConfigurationBuilder builder() {
        return new PartTextureConfigurationBuilder();
    }

    @NotNull
    public Material getMaterial() {
        return this.material;
    }

    @Nullable
    public Integer getCustomModelData() {
        return this.customModelData;
    }

    @Nullable
    public Vector3D getRotation() {
        return this.rotation;
    }

    public PartTextureConfiguration(@NotNull Material material, @Nullable Integer customModelData, @Nullable Vector3D rotation) {
        if (material == null) {
            throw new NullPointerException("material is marked non-null but is null");
        }
        this.material = material;
        this.customModelData = customModelData;
        this.rotation = rotation;
    }

    public static class PartTextureConfigurationBuilder {
        private Material material;
        private Integer customModelData;
        private Vector3D rotation;

        PartTextureConfigurationBuilder() {
        }

        public PartTextureConfigurationBuilder material(@NotNull Material material) {
            if (material == null) {
                throw new NullPointerException("material is marked non-null but is null");
            }
            this.material = material;
            return this;
        }

        public PartTextureConfigurationBuilder customModelData(@Nullable Integer customModelData) {
            this.customModelData = customModelData;
            return this;
        }

        public PartTextureConfigurationBuilder rotation(@Nullable Vector3D rotation) {
            this.rotation = rotation;
            return this;
        }

        public PartTextureConfiguration build() {
            return new PartTextureConfiguration(this.material, this.customModelData, this.rotation);
        }

        public String toString() {
            return "PartTextureConfiguration.PartTextureConfigurationBuilder(material=" + this.material + ", customModelData=" + this.customModelData + ", rotation=" + this.rotation + ")";
        }
    }
}

