/*
 * Decompiled with CFR 0.152.
 */
package es.outlook.adriansrj.cv.api.vehicle.configuration.model.compound.pre19;

import es.outlook.adriansrj.cv.api.enums.EnumStandSlot;
import es.outlook.adriansrj.cv.api.interfaces.ConfigurationSectionWritable;
import es.outlook.adriansrj.cv.api.util.ConfigurationUtil;
import es.outlook.adriansrj.cv.api.util.reflection.EnumReflection;
import es.outlook.adriansrj.cv.api.vehicle.configuration.model.compound.pre19.PartAnimationConfiguration;
import es.outlook.adriansrj.cv.api.vehicle.configuration.model.compound.pre19.PartTextureConfiguration;
import gnu.trove.map.hash.THashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PartConfiguration
implements ConfigurationSectionWritable {
    @NotNull
    private final Map<EnumStandSlot, PartTextureConfiguration> textures;
    @NotNull
    private final Map<String, PartAnimationConfiguration> animations;
    private final boolean small;
    @Nullable
    private final Vector3D offset;

    public static PartConfiguration load(@NotNull ConfigurationSection section) throws InvalidConfigurationException {
        Map<EnumStandSlot, PartTextureConfiguration> textures = PartConfiguration.loadTextures(section);
        Map<String, PartAnimationConfiguration> animations = PartConfiguration.loadAnimations(section);
        boolean small = section.getBoolean("small");
        Vector3D offset = ConfigurationUtil.loadLibraryObject(Vector3D.class, section, "offset");
        return new PartConfiguration(textures, animations, small, offset);
    }

    private static Map<EnumStandSlot, PartTextureConfiguration> loadTextures(ConfigurationSection root) throws InvalidConfigurationException {
        ConfigurationSection texturesSection = root.getConfigurationSection("textures");
        if (texturesSection == null) {
            throw new InvalidConfigurationException("invalid textures");
        }
        THashMap textures = new THashMap();
        for (String key : texturesSection.getKeys(false)) {
            EnumStandSlot slot = EnumReflection.getEnumConstant(EnumStandSlot.class, key.trim().toUpperCase());
            ConfigurationSection textureSection = texturesSection.getConfigurationSection(key);
            if (slot == null || textureSection == null) continue;
            textures.put(slot, PartTextureConfiguration.load(textureSection));
        }
        if (textures.size() == 0) {
            throw new InvalidConfigurationException("at least one texture must be set");
        }
        return textures;
    }

    private static Map<String, PartAnimationConfiguration> loadAnimations(ConfigurationSection root) throws InvalidConfigurationException {
        THashMap animations = new THashMap();
        ConfigurationSection animationsSection = root.getConfigurationSection("animations");
        if (animationsSection == null) {
            return animations;
        }
        for (String key : animationsSection.getKeys(false)) {
            ConfigurationSection section = animationsSection.getConfigurationSection(key);
            PartAnimationConfiguration animation = section != null ? PartAnimationConfiguration.load(section) : null;
            if (animation == null) continue;
            animations.put(key.trim().toLowerCase(), animation);
        }
        return animations;
    }

    @Override
    public void write(@NotNull ConfigurationSection section) {
        section.set("small", (Object)this.small);
        if (this.offset != null) {
            ConfigurationUtil.writeLibraryObject(Vector3D.class, this.offset, section.createSection("offset"));
        }
        ConfigurationSection texturesSection = section.createSection("textures");
        for (Map.Entry<EnumStandSlot, PartTextureConfiguration> entry : this.textures.entrySet()) {
            entry.getValue().write(texturesSection.createSection(entry.getKey().name()));
        }
        if (this.animations.size() > 0) {
            ConfigurationSection animationsSection = section.createSection("animations");
            for (Map.Entry<String, PartAnimationConfiguration> entry : this.animations.entrySet()) {
                entry.getValue().write(animationsSection.createSection(entry.getKey().toLowerCase().trim()));
            }
        } else {
            section.set("animations", null);
        }
    }

    public static PartConfigurationBuilder builder() {
        return new PartConfigurationBuilder();
    }

    @NotNull
    public Map<EnumStandSlot, PartTextureConfiguration> getTextures() {
        return this.textures;
    }

    @NotNull
    public Map<String, PartAnimationConfiguration> getAnimations() {
        return this.animations;
    }

    public boolean isSmall() {
        return this.small;
    }

    @Nullable
    public Vector3D getOffset() {
        return this.offset;
    }

    public PartConfiguration(@NotNull Map<EnumStandSlot, PartTextureConfiguration> textures, @NotNull Map<String, PartAnimationConfiguration> animations, boolean small, @Nullable Vector3D offset) {
        if (textures == null) {
            throw new NullPointerException("textures is marked non-null but is null");
        }
        if (animations == null) {
            throw new NullPointerException("animations is marked non-null but is null");
        }
        this.textures = textures;
        this.animations = animations;
        this.small = small;
        this.offset = offset;
    }

    public static class PartConfigurationBuilder {
        private ArrayList<EnumStandSlot> textures$key;
        private ArrayList<PartTextureConfiguration> textures$value;
        private ArrayList<String> animations$key;
        private ArrayList<PartAnimationConfiguration> animations$value;
        private boolean small;
        private Vector3D offset;

        PartConfigurationBuilder() {
        }

        public PartConfigurationBuilder texture(EnumStandSlot textureKey, PartTextureConfiguration textureValue) {
            if (this.textures$key == null) {
                this.textures$key = new ArrayList();
                this.textures$value = new ArrayList();
            }
            this.textures$key.add(textureKey);
            this.textures$value.add(textureValue);
            return this;
        }

        public PartConfigurationBuilder textures(Map<? extends EnumStandSlot, ? extends PartTextureConfiguration> textures) {
            if (textures == null) {
                throw new NullPointerException("textures cannot be null");
            }
            if (this.textures$key == null) {
                this.textures$key = new ArrayList();
                this.textures$value = new ArrayList();
            }
            for (Map.Entry<? extends EnumStandSlot, ? extends PartTextureConfiguration> $lombokEntry : textures.entrySet()) {
                this.textures$key.add($lombokEntry.getKey());
                this.textures$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public PartConfigurationBuilder clearTextures() {
            if (this.textures$key != null) {
                this.textures$key.clear();
                this.textures$value.clear();
            }
            return this;
        }

        public PartConfigurationBuilder animation(String animationKey, PartAnimationConfiguration animationValue) {
            if (this.animations$key == null) {
                this.animations$key = new ArrayList();
                this.animations$value = new ArrayList();
            }
            this.animations$key.add(animationKey);
            this.animations$value.add(animationValue);
            return this;
        }

        public PartConfigurationBuilder animations(Map<? extends String, ? extends PartAnimationConfiguration> animations) {
            if (animations == null) {
                throw new NullPointerException("animations cannot be null");
            }
            if (this.animations$key == null) {
                this.animations$key = new ArrayList();
                this.animations$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends PartAnimationConfiguration> $lombokEntry : animations.entrySet()) {
                this.animations$key.add($lombokEntry.getKey());
                this.animations$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public PartConfigurationBuilder clearAnimations() {
            if (this.animations$key != null) {
                this.animations$key.clear();
                this.animations$value.clear();
            }
            return this;
        }

        public PartConfigurationBuilder small(boolean small) {
            this.small = small;
            return this;
        }

        public PartConfigurationBuilder offset(@Nullable Vector3D offset) {
            this.offset = offset;
            return this;
        }

        public PartConfiguration build() {
            Map<String, PartAnimationConfiguration> animations;
            Map<EnumStandSlot, PartTextureConfiguration> textures;
            switch (this.textures$key == null ? 0 : this.textures$key.size()) {
                case 0: {
                    textures = Collections.emptyMap();
                    break;
                }
                case 1: {
                    textures = Collections.singletonMap(this.textures$key.get(0), this.textures$value.get(0));
                    break;
                }
                default: {
                    textures = new LinkedHashMap(this.textures$key.size() < 0x40000000 ? 1 + this.textures$key.size() + (this.textures$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.textures$key.size(); ++$i) {
                        textures.put(this.textures$key.get($i), this.textures$value.get($i));
                    }
                    textures = Collections.unmodifiableMap(textures);
                }
            }
            switch (this.animations$key == null ? 0 : this.animations$key.size()) {
                case 0: {
                    animations = Collections.emptyMap();
                    break;
                }
                case 1: {
                    animations = Collections.singletonMap(this.animations$key.get(0), this.animations$value.get(0));
                    break;
                }
                default: {
                    animations = new LinkedHashMap(this.animations$key.size() < 0x40000000 ? 1 + this.animations$key.size() + (this.animations$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.animations$key.size(); ++$i) {
                        animations.put(this.animations$key.get($i), this.animations$value.get($i));
                    }
                    animations = Collections.unmodifiableMap(animations);
                }
            }
            return new PartConfiguration(textures, animations, this.small, this.offset);
        }

        public String toString() {
            return "PartConfiguration.PartConfigurationBuilder(textures$key=" + this.textures$key + ", textures$value=" + this.textures$value + ", animations$key=" + this.animations$key + ", animations$value=" + this.animations$value + ", small=" + this.small + ", offset=" + this.offset + ")";
        }
    }
}

