/*
 * Decompiled with CFR 0.152.
 */
package es.outlook.adriansrj.cv.api.vehicle.configuration.model.compound.pre19;

import es.outlook.adriansrj.cv.api.enums.EnumRotableLimb;
import es.outlook.adriansrj.cv.api.interfaces.ConfigurationSectionWritable;
import es.outlook.adriansrj.cv.api.util.ConfigurationUtil;
import es.outlook.adriansrj.cv.api.util.reflection.EnumReflection;
import gnu.trove.map.hash.THashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PartAnimationKeyframeConfiguration
implements ConfigurationSectionWritable {
    private final long duration;
    @Nullable
    private final Vector3D offset;
    @NotNull
    private final Map<EnumRotableLimb, Vector3D> rotations;

    public static PartAnimationKeyframeConfiguration load(@NotNull ConfigurationSection section) throws InvalidConfigurationException {
        long duration = section.getLong("duration");
        THashMap rotations = new THashMap();
        if (duration < 0L) {
            throw new InvalidConfigurationException("duration cannot be negative");
        }
        Vector3D offset = ConfigurationUtil.loadLibraryObject(Vector3D.class, section, "offset");
        ConfigurationSection rotationsSection = section.getConfigurationSection("rotations");
        if (rotationsSection != null) {
            for (String key : rotationsSection.getKeys(false)) {
                EnumRotableLimb limb = EnumReflection.getEnumConstant(EnumRotableLimb.class, key.trim().toUpperCase());
                Vector3D rotation = ConfigurationUtil.loadLibraryObject(Vector3D.class, rotationsSection, key);
                if (limb == null || rotation == null) continue;
                rotations.put(limb, rotation);
            }
        }
        if (offset == null && rotations.size() == 0) {
            throw new InvalidConfigurationException("at least one rotation, or offset must be set");
        }
        return new PartAnimationKeyframeConfiguration(duration, offset, (Map<EnumRotableLimb, Vector3D>)rotations);
    }

    @Override
    public void write(@NotNull ConfigurationSection section) {
        section.set("duration", (Object)this.duration);
        if (this.offset != null) {
            ConfigurationUtil.writeLibraryObject(Vector3D.class, this.offset, section.createSection("offset"));
        } else {
            section.set("offset", null);
        }
        if (this.rotations.size() > 0) {
            ConfigurationSection rotationsSection = section.createSection("rotations");
            for (Map.Entry<EnumRotableLimb, Vector3D> entry : this.rotations.entrySet()) {
                EnumRotableLimb limb = entry.getKey();
                Vector3D rotation = entry.getValue();
                ConfigurationUtil.writeLibraryObject(Vector3D.class, rotation, rotationsSection.createSection(limb.name()));
            }
        } else {
            section.set("rotations", null);
        }
    }

    public static PartAnimationKeyframeConfigurationBuilder builder() {
        return new PartAnimationKeyframeConfigurationBuilder();
    }

    public long getDuration() {
        return this.duration;
    }

    @Nullable
    public Vector3D getOffset() {
        return this.offset;
    }

    @NotNull
    public Map<EnumRotableLimb, Vector3D> getRotations() {
        return this.rotations;
    }

    public PartAnimationKeyframeConfiguration(long duration, @Nullable Vector3D offset, @NotNull Map<EnumRotableLimb, Vector3D> rotations) {
        if (rotations == null) {
            throw new NullPointerException("rotations is marked non-null but is null");
        }
        this.duration = duration;
        this.offset = offset;
        this.rotations = rotations;
    }

    public String toString() {
        return "PartAnimationKeyframeConfiguration(duration=" + this.getDuration() + ", offset=" + this.getOffset() + ", rotations=" + this.getRotations() + ")";
    }

    public static class PartAnimationKeyframeConfigurationBuilder {
        private long duration;
        private Vector3D offset;
        private ArrayList<EnumRotableLimb> rotations$key;
        private ArrayList<Vector3D> rotations$value;

        PartAnimationKeyframeConfigurationBuilder() {
        }

        public PartAnimationKeyframeConfigurationBuilder duration(long duration) {
            this.duration = duration;
            return this;
        }

        public PartAnimationKeyframeConfigurationBuilder offset(@Nullable Vector3D offset) {
            this.offset = offset;
            return this;
        }

        public PartAnimationKeyframeConfigurationBuilder rotation(EnumRotableLimb rotationKey, Vector3D rotationValue) {
            if (this.rotations$key == null) {
                this.rotations$key = new ArrayList();
                this.rotations$value = new ArrayList();
            }
            this.rotations$key.add(rotationKey);
            this.rotations$value.add(rotationValue);
            return this;
        }

        public PartAnimationKeyframeConfigurationBuilder rotations(Map<? extends EnumRotableLimb, ? extends Vector3D> rotations) {
            if (rotations == null) {
                throw new NullPointerException("rotations cannot be null");
            }
            if (this.rotations$key == null) {
                this.rotations$key = new ArrayList();
                this.rotations$value = new ArrayList();
            }
            for (Map.Entry<? extends EnumRotableLimb, ? extends Vector3D> $lombokEntry : rotations.entrySet()) {
                this.rotations$key.add($lombokEntry.getKey());
                this.rotations$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public PartAnimationKeyframeConfigurationBuilder clearRotations() {
            if (this.rotations$key != null) {
                this.rotations$key.clear();
                this.rotations$value.clear();
            }
            return this;
        }

        public PartAnimationKeyframeConfiguration build() {
            Map<EnumRotableLimb, Vector3D> rotations;
            switch (this.rotations$key == null ? 0 : this.rotations$key.size()) {
                case 0: {
                    rotations = Collections.emptyMap();
                    break;
                }
                case 1: {
                    rotations = Collections.singletonMap(this.rotations$key.get(0), this.rotations$value.get(0));
                    break;
                }
                default: {
                    rotations = new LinkedHashMap(this.rotations$key.size() < 0x40000000 ? 1 + this.rotations$key.size() + (this.rotations$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.rotations$key.size(); ++$i) {
                        rotations.put(this.rotations$key.get($i), this.rotations$value.get($i));
                    }
                    rotations = Collections.unmodifiableMap(rotations);
                }
            }
            return new PartAnimationKeyframeConfiguration(this.duration, this.offset, rotations);
        }

        public String toString() {
            return "PartAnimationKeyframeConfiguration.PartAnimationKeyframeConfigurationBuilder(duration=" + this.duration + ", offset=" + this.offset + ", rotations$key=" + this.rotations$key + ", rotations$value=" + this.rotations$value + ")";
        }
    }
}

