/*
 * Decompiled with CFR 0.152.
 */
package es.outlook.adriansrj.cv.api.vehicle.configuration.model.compound.pre19;

import es.outlook.adriansrj.cv.api.enums.EnumInterpolationMode;
import es.outlook.adriansrj.cv.api.enums.EnumLoopMode;
import es.outlook.adriansrj.cv.api.interfaces.ConfigurationSectionWritable;
import es.outlook.adriansrj.cv.api.util.ConfigurationUtil;
import es.outlook.adriansrj.cv.api.vehicle.configuration.model.compound.pre19.PartAnimationKeyframeConfiguration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.jetbrains.annotations.NotNull;

public class PartAnimationConfiguration
implements ConfigurationSectionWritable {
    @NotNull
    private final EnumInterpolationMode interpolationMode;
    @NotNull
    private final EnumLoopMode loopMode;
    @NotNull
    private final List<PartAnimationKeyframeConfiguration> keyframes;

    public static PartAnimationConfiguration load(@NotNull ConfigurationSection section) throws InvalidConfigurationException {
        EnumInterpolationMode interpolationMode = ConfigurationUtil.loadEnum(EnumInterpolationMode.class, section, "interpolation-mode");
        EnumLoopMode loopMode = ConfigurationUtil.loadEnum(EnumLoopMode.class, section, "loop-mode");
        if (interpolationMode == null) {
            throw new InvalidConfigurationException("invalid interpolation mode");
        }
        if (loopMode == null) {
            throw new InvalidConfigurationException("invalid loop mode");
        }
        ConfigurationSection keyframesSection = section.getConfigurationSection("keyframes");
        ArrayList<PartAnimationKeyframeConfiguration> keyframes = new ArrayList<PartAnimationKeyframeConfiguration>();
        if (keyframesSection != null) {
            for (String key : keyframesSection.getKeys(false)) {
                ConfigurationSection keyframeSection = keyframesSection.getConfigurationSection(key);
                PartAnimationKeyframeConfiguration keyframe = keyframeSection != null ? PartAnimationKeyframeConfiguration.load(keyframeSection) : null;
                if (keyframe == null) continue;
                keyframes.add(keyframe);
            }
        }
        if (keyframes.size() == 0) {
            throw new InvalidConfigurationException("at least one keyframe must be set");
        }
        return new PartAnimationConfiguration(interpolationMode, loopMode, keyframes);
    }

    @Override
    public void write(@NotNull ConfigurationSection section) {
        ConfigurationUtil.writeEnum(this.interpolationMode, section, "interpolation-mode");
        ConfigurationUtil.writeEnum(this.loopMode, section, "loop-mode");
        ConfigurationSection keyframesSection = section.createSection("keyframes");
        for (int i = 0; i < this.keyframes.size(); ++i) {
            this.keyframes.get(i).write(keyframesSection.createSection("keyframe-" + i));
        }
    }

    public static PartAnimationConfigurationBuilder builder() {
        return new PartAnimationConfigurationBuilder();
    }

    @NotNull
    public EnumInterpolationMode getInterpolationMode() {
        return this.interpolationMode;
    }

    @NotNull
    public EnumLoopMode getLoopMode() {
        return this.loopMode;
    }

    @NotNull
    public List<PartAnimationKeyframeConfiguration> getKeyframes() {
        return this.keyframes;
    }

    public PartAnimationConfiguration(@NotNull EnumInterpolationMode interpolationMode, @NotNull EnumLoopMode loopMode, @NotNull List<PartAnimationKeyframeConfiguration> keyframes) {
        if (interpolationMode == null) {
            throw new NullPointerException("interpolationMode is marked non-null but is null");
        }
        if (loopMode == null) {
            throw new NullPointerException("loopMode is marked non-null but is null");
        }
        if (keyframes == null) {
            throw new NullPointerException("keyframes is marked non-null but is null");
        }
        this.interpolationMode = interpolationMode;
        this.loopMode = loopMode;
        this.keyframes = keyframes;
    }

    public String toString() {
        return "PartAnimationConfiguration(interpolationMode=" + (Object)((Object)this.getInterpolationMode()) + ", loopMode=" + (Object)((Object)this.getLoopMode()) + ", keyframes=" + this.getKeyframes() + ")";
    }

    public static class PartAnimationConfigurationBuilder {
        private EnumInterpolationMode interpolationMode;
        private EnumLoopMode loopMode;
        private ArrayList<PartAnimationKeyframeConfiguration> keyframes;

        PartAnimationConfigurationBuilder() {
        }

        public PartAnimationConfigurationBuilder interpolationMode(@NotNull EnumInterpolationMode interpolationMode) {
            if (interpolationMode == null) {
                throw new NullPointerException("interpolationMode is marked non-null but is null");
            }
            this.interpolationMode = interpolationMode;
            return this;
        }

        public PartAnimationConfigurationBuilder loopMode(@NotNull EnumLoopMode loopMode) {
            if (loopMode == null) {
                throw new NullPointerException("loopMode is marked non-null but is null");
            }
            this.loopMode = loopMode;
            return this;
        }

        public PartAnimationConfigurationBuilder keyframe(PartAnimationKeyframeConfiguration keyframe) {
            if (this.keyframes == null) {
                this.keyframes = new ArrayList();
            }
            this.keyframes.add(keyframe);
            return this;
        }

        public PartAnimationConfigurationBuilder keyframes(Collection<? extends PartAnimationKeyframeConfiguration> keyframes) {
            if (keyframes == null) {
                throw new NullPointerException("keyframes cannot be null");
            }
            if (this.keyframes == null) {
                this.keyframes = new ArrayList();
            }
            this.keyframes.addAll(keyframes);
            return this;
        }

        public PartAnimationConfigurationBuilder clearKeyframes() {
            if (this.keyframes != null) {
                this.keyframes.clear();
            }
            return this;
        }

        public PartAnimationConfiguration build() {
            List<PartAnimationKeyframeConfiguration> keyframes;
            switch (this.keyframes == null ? 0 : this.keyframes.size()) {
                case 0: {
                    keyframes = Collections.emptyList();
                    break;
                }
                case 1: {
                    keyframes = Collections.singletonList(this.keyframes.get(0));
                    break;
                }
                default: {
                    keyframes = Collections.unmodifiableList(new ArrayList<PartAnimationKeyframeConfiguration>(this.keyframes));
                }
            }
            return new PartAnimationConfiguration(this.interpolationMode, this.loopMode, keyframes);
        }

        public String toString() {
            return "PartAnimationConfiguration.PartAnimationConfigurationBuilder(interpolationMode=" + (Object)((Object)this.interpolationMode) + ", loopMode=" + (Object)((Object)this.loopMode) + ", keyframes=" + this.keyframes + ")";
        }
    }
}

