/*
 * Decompiled with CFR 0.152.
 */
package es.outlook.adriansrj.cv.api.vehicle.configuration.model.compound.post19;

import es.outlook.adriansrj.cv.api.interfaces.ConfigurationSectionWritable;
import es.outlook.adriansrj.cv.api.interfaces.Identifiable;
import es.outlook.adriansrj.cv.api.util.ConfigurationUtil;
import es.outlook.adriansrj.cv.api.vehicle.configuration.model.compound.post19.BoneConfiguration;
import es.outlook.adriansrj.cv.api.vehicle.configuration.model.compound.post19.PartConfiguration;
import es.outlook.adriansrj.cv.api.vehicle.configuration.model.compound.post19.Post19CompoundModelConfiguration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RigConfiguration
implements ConfigurationSectionWritable {
    private final Map<UUID, Element<?>> elementMap = new HashMap();

    public static Builder builder() {
        return new Builder();
    }

    @Nullable
    public static RigConfiguration load(@NotNull ConfigurationSection section, @NotNull Post19CompoundModelConfiguration model) throws InvalidConfigurationException {
        Element element;
        Set<ConfigurationSection> sections = ConfigurationUtil.getConfigurationSections(section, false);
        HashMap<UUID, Element> elements = new HashMap<UUID, Element>();
        for (ConfigurationSection elementSection : sections) {
            element = Element.of(elementSection, model);
            if (element == null || elements.containsKey(element.identifier)) continue;
            elements.put(element.identifier, element);
        }
        for (ConfigurationSection elementSection : sections) {
            element = (Element)elements.get(Identifiable.loadIdentifier(elementSection));
            if (element == null) continue;
            try {
                UUID parentIdentifier = UUID.fromString(elementSection.getString("parent", ""));
                Element parentRaw = (Element)elements.get(parentIdentifier);
                if (!(parentRaw instanceof BoneElement)) continue;
                element.parent = (BoneElement)parentRaw;
            }
            catch (IllegalArgumentException parentIdentifier) {}
        }
        for (ConfigurationSection elementSection : sections) {
            BoneElement bone;
            Element elementRaw = (Element)elements.get(Identifiable.loadIdentifier(elementSection));
            BoneElement boneElement = bone = elementRaw instanceof BoneElement ? (BoneElement)elementRaw : null;
            if (bone == null) continue;
            for (String entry : elementSection.getStringList("children")) {
                try {
                    UUID childIdentifier = UUID.fromString(entry);
                    Element child = (Element)elements.get(childIdentifier);
                    if (child == null) continue;
                    bone.children.add(child);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        }
        return elements.size() > 0 ? new RigConfiguration(elements.values()) : null;
    }

    RigConfiguration(@NotNull Collection<Element<?>> elements) throws InvalidConfigurationException {
        if (elements.size() == 0) {
            throw new InvalidConfigurationException("malformed rig");
        }
        int rootCount = 0;
        for (Element<?> raw : elements) {
            if (raw instanceof PartElement && raw.parent == null) {
                throw new InvalidConfigurationException("malformed rig");
            }
            if (!(raw instanceof BoneElement) || raw.parent != null) continue;
            ++rootCount;
        }
        if (rootCount == 0) {
            throw new InvalidConfigurationException("malformed rig");
        }
        for (Element<?> element : elements) {
            this.elementMap.put(element.identifier, element);
        }
    }

    public boolean contains(@NotNull UUID elementIdentifier) {
        return this.elementMap.containsKey(elementIdentifier);
    }

    public boolean contains(@NotNull PartConfiguration part) {
        return this.contains(part.getIdentifier());
    }

    public boolean contains(@NotNull BoneConfiguration bone) {
        return this.contains(bone.getIdentifier());
    }

    @NotNull
    public List<BoneConfiguration> getAncestors(@NotNull BoneConfiguration bone) {
        ArrayList<BoneConfiguration> ancestors = new ArrayList<BoneConfiguration>();
        BoneElement wrapper = this.getWrapper(bone);
        BoneElement cursor = wrapper.parent;
        while (cursor != null) {
            ancestors.add((BoneConfiguration)cursor.value);
            cursor = cursor.parent;
        }
        Collections.reverse(ancestors);
        return ancestors;
    }

    @NotNull
    public List<BoneConfiguration> getHierarchyUp(@NotNull BoneConfiguration bone) {
        List<BoneConfiguration> ancestors = this.getAncestors(bone);
        ancestors.add(bone);
        return ancestors;
    }

    @NotNull
    public List<BoneConfiguration> getHierarchyDown(@NotNull BoneConfiguration bone) {
        List<BoneConfiguration> children = this.getChildrenBones(bone, true);
        children.add(0, bone);
        return children;
    }

    @NotNull
    public List<BoneConfiguration> getChildrenBones(@NotNull BoneConfiguration bone, boolean deep) {
        ArrayList<BoneConfiguration> children = new ArrayList<BoneConfiguration>();
        BoneElement wrapper = this.getWrapper(bone);
        for (BoneElement raw : this.getChildrenBones(wrapper, deep)) {
            children.add((BoneConfiguration)raw.value);
        }
        return children;
    }

    @NotNull
    public List<PartConfiguration> getChildrenParts(@NotNull BoneConfiguration bone, boolean deep) {
        ArrayList<PartConfiguration> children = new ArrayList<PartConfiguration>();
        BoneElement wrapper = this.getWrapper(bone);
        for (PartElement raw : this.getChildrenParts(wrapper, deep)) {
            children.add((PartConfiguration)raw.value);
        }
        return children;
    }

    @Nullable
    public BoneConfiguration getParent(@NotNull BoneConfiguration child) {
        BoneElement wrapper = this.getWrapper(child);
        BoneElement parentWrapper = wrapper.parent;
        return parentWrapper != null ? (BoneConfiguration)parentWrapper.value : null;
    }

    @Nullable
    public BoneConfiguration getParent(@NotNull PartConfiguration child) {
        return (BoneConfiguration)this.getWrapper((PartConfiguration)child).parent.value;
    }

    @Override
    public void write(@NotNull ConfigurationSection root) {
        for (Element<?> element : this.elementMap.values()) {
            element.write(root.createSection(element.identifier.toString()));
        }
    }

    private List<BoneElement> getChildrenBones(BoneElement bone, boolean deep) {
        ArrayList<BoneElement> children = new ArrayList<BoneElement>();
        for (Element<?> raw : bone.children) {
            if (!(raw instanceof BoneElement)) continue;
            children.add((BoneElement)raw);
            if (!deep) continue;
            children.addAll(this.getChildrenBones((BoneElement)raw, true));
        }
        return children;
    }

    private List<PartElement> getChildrenParts(BoneElement bone, boolean deep) {
        ArrayList<PartElement> children = new ArrayList<PartElement>();
        for (Element<?> raw : bone.children) {
            if (raw instanceof PartElement) {
                children.add((PartElement)raw);
                continue;
            }
            if (!(raw instanceof BoneElement) || !deep) continue;
            children.addAll(this.getChildrenParts((BoneElement)raw, true));
        }
        return children;
    }

    @NotNull
    private PartElement getWrapper(@NotNull PartConfiguration part) {
        PartElement wrapper = (PartElement)this.elementMap.get(part.getIdentifier());
        if (wrapper != null) {
            return wrapper;
        }
        throw new IllegalArgumentException("part with identifier '" + part.getIdentifier() + "' was not found in rig");
    }

    @NotNull
    private BoneElement getWrapper(@NotNull BoneConfiguration bone) {
        BoneElement wrapper = (BoneElement)this.elementMap.get(bone.getIdentifier());
        if (wrapper != null) {
            return wrapper;
        }
        throw new IllegalArgumentException("bone with identifier '" + bone.getIdentifier() + "' was not found in rig");
    }

    public static class Builder {
        private final List<Element<?>> wrappers = new ArrayList();

        public RigConfiguration build() throws InvalidConfigurationException {
            return new RigConfiguration(this.wrappers);
        }

        public void root(@NotNull BoneConfiguration bone) {
            this.getWrapper(bone);
        }

        public void bind(@NotNull PartConfiguration child, @NotNull BoneConfiguration parent) {
            PartElement childWrapper = this.getWrapper(child);
            BoneElement parentWrapper = this.getWrapper(parent);
            if (childWrapper.parent != null) {
                throw new IllegalStateException("provided part is already bound to another bone");
            }
            childWrapper.parent = parentWrapper;
            parentWrapper.children.add(childWrapper);
        }

        public void bind(@NotNull BoneConfiguration child, @NotNull BoneConfiguration parent) {
            BoneElement childWrapper = this.getWrapper(child);
            BoneElement parentWrapper = this.getWrapper(parent);
            if (childWrapper.parent != null) {
                throw new IllegalStateException("provided bone is already bound to another bone");
            }
            childWrapper.parent = parentWrapper;
            parentWrapper.children.add(childWrapper);
        }

        private PartElement getWrapper(PartConfiguration part) {
            Element<?> wrapperRaw = this.getWrapperRaw(part.getIdentifier());
            if (wrapperRaw instanceof PartElement) {
                return (PartElement)wrapperRaw;
            }
            PartElement wrapper = new PartElement(part);
            this.wrappers.add(wrapper);
            return wrapper;
        }

        private BoneElement getWrapper(BoneConfiguration bone) {
            Element<?> wrapperRaw = this.getWrapperRaw(bone.getIdentifier());
            if (wrapperRaw instanceof BoneElement) {
                return (BoneElement)wrapperRaw;
            }
            BoneElement wrapper = new BoneElement(bone);
            this.wrappers.add(wrapper);
            return wrapper;
        }

        private Element<?> getWrapperRaw(UUID identifier) {
            for (Element<?> wrapper : this.wrappers) {
                if (!Objects.equals(wrapper.identifier, identifier)) continue;
                return wrapper;
            }
            return null;
        }
    }

    static abstract class Element<E>
    implements ConfigurationSectionWritable {
        @NotNull
        final UUID identifier;
        @NotNull
        final E value;
        BoneElement parent;

        static Element<?> of(@NotNull ConfigurationSection section, @NotNull Post19CompoundModelConfiguration model) {
            UUID identifier = Identifiable.loadIdentifier(section);
            if (identifier == null) {
                return null;
            }
            PartConfiguration partValue = model.getPartByIdentifier(identifier);
            if (partValue != null) {
                return new PartElement(partValue);
            }
            BoneConfiguration boneValue = model.getBoneByIdentifier(identifier);
            if (boneValue != null) {
                return new BoneElement(boneValue);
            }
            return null;
        }

        private Element(@NotNull UUID identifier, @NotNull E value) {
            this.identifier = identifier;
            this.value = value;
        }

        @Override
        public void write(@NotNull ConfigurationSection section) {
            Identifiable.writeIdentifier(this.identifier, section);
            if (this.parent != null) {
                section.set("parent", (Object)this.parent.identifier.toString());
            }
        }

        public String toString() {
            return "RigConfiguration.Element(identifier=" + this.identifier + ", value=" + this.value + ", parent=" + this.parent + ")";
        }
    }

    static final class BoneElement
    extends Element<BoneConfiguration> {
        final Set<Element<?>> children = new HashSet();

        BoneElement(@NotNull BoneConfiguration bone) {
            super(bone.getIdentifier(), bone);
        }

        @Override
        public void write(@NotNull ConfigurationSection section) {
            super.write(section);
            if (this.children.size() > 0) {
                section.set("children", this.children.stream().map(child -> child.identifier.toString()).collect(Collectors.toList()));
            }
        }
    }

    static final class PartElement
    extends Element<PartConfiguration> {
        PartElement(@NotNull PartConfiguration part) {
            super(part.getIdentifier(), part);
        }
    }
}

