/*
 * Decompiled with CFR 0.152.
 */
package es.outlook.adriansrj.cv.api.vehicle.configuration.model.compound.post19;

import es.outlook.adriansrj.cv.api.enums.EnumVehicleModelType;
import es.outlook.adriansrj.cv.api.util.ConfigurationUtil;
import es.outlook.adriansrj.cv.api.vehicle.VehicleState;
import es.outlook.adriansrj.cv.api.vehicle.configuration.model.VehicleHitBoxConfiguration;
import es.outlook.adriansrj.cv.api.vehicle.configuration.model.VehicleModelConfiguration;
import es.outlook.adriansrj.cv.api.vehicle.configuration.model.VehicleParticleConfiguration;
import es.outlook.adriansrj.cv.api.vehicle.configuration.model.VehicleSeatConfiguration;
import es.outlook.adriansrj.cv.api.vehicle.configuration.model.VehicleSoundConfiguration;
import es.outlook.adriansrj.cv.api.vehicle.configuration.model.compound.post19.AnimationConfiguration;
import es.outlook.adriansrj.cv.api.vehicle.configuration.model.compound.post19.BoneConfiguration;
import es.outlook.adriansrj.cv.api.vehicle.configuration.model.compound.post19.PartConfiguration;
import es.outlook.adriansrj.cv.api.vehicle.configuration.model.compound.post19.RigConfiguration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Post19CompoundModelConfiguration
extends VehicleModelConfiguration {
    @NotNull
    private final Set<PartConfiguration> parts;
    @NotNull
    private final Set<BoneConfiguration> bones;
    @Nullable
    private final RigConfiguration rig;
    @NotNull
    private final Set<AnimationConfiguration> animations;

    public Post19CompoundModelConfiguration(@NotNull String id, @NotNull VehicleHitBoxConfiguration hitBox, @NotNull Collection<VehicleSeatConfiguration> seats, @NotNull Collection<PartConfiguration> parts, @Nullable Collection<BoneConfiguration> bones, @Nullable RigConfiguration rig, @Nullable Collection<AnimationConfiguration> animations, @Nullable Collection<VehicleParticleConfiguration> particles, @Nullable Collection<VehicleSoundConfiguration> sounds) {
        super(id, hitBox, seats, particles, sounds);
        this.parts = new HashSet<PartConfiguration>(parts);
        this.bones = new HashSet<BoneConfiguration>();
        this.animations = new HashSet<AnimationConfiguration>();
        if (bones != null) {
            this.bones.addAll(bones);
        }
        if (animations != null) {
            this.animations.addAll(animations);
        }
        this.rig = rig;
    }

    public Post19CompoundModelConfiguration(@NotNull ConfigurationSection section) throws InvalidConfigurationException {
        super(section);
        this.parts = new HashSet<PartConfiguration>();
        for (ConfigurationSection partSection : ConfigurationUtil.getConfigurationSectionsAfter(section, "parts", false)) {
            try {
                this.parts.add(PartConfiguration.load(partSection));
            }
            catch (InvalidConfigurationException ex) {
                ex.printStackTrace();
            }
        }
        if (this.parts.size() == 0) {
            throw new InvalidConfigurationException("at least one valid part is required");
        }
        this.bones = new HashSet<BoneConfiguration>();
        for (ConfigurationSection boneSection : ConfigurationUtil.getConfigurationSectionsAfter(section, "bones", false)) {
            try {
                this.bones.add(BoneConfiguration.load(boneSection));
            }
            catch (InvalidConfigurationException ex) {
                ex.printStackTrace();
            }
        }
        ConfigurationSection rigSection = section.getConfigurationSection("rig");
        this.rig = rigSection != null ? RigConfiguration.load(rigSection, this) : null;
        this.animations = new HashSet<AnimationConfiguration>();
        for (ConfigurationSection animationSection : ConfigurationUtil.getConfigurationSectionsAfter(section, "animations", false)) {
            try {
                this.animations.add(AnimationConfiguration.load(animationSection));
            }
            catch (InvalidConfigurationException ex) {
                ex.printStackTrace();
            }
        }
    }

    @Override
    @NotNull
    public EnumVehicleModelType getType() {
        return EnumVehicleModelType.COMPOUND;
    }

    @NotNull
    public Set<PartConfiguration> getParts() {
        return Collections.unmodifiableSet(this.parts);
    }

    @Nullable
    public PartConfiguration getPartByIdentifier(@NotNull UUID identifier) {
        for (PartConfiguration part : this.parts) {
            if (!Objects.equals(part.getIdentifier(), identifier)) continue;
            return part;
        }
        return null;
    }

    @NotNull
    public Set<BoneConfiguration> getBones() {
        return Collections.unmodifiableSet(this.bones);
    }

    @Nullable
    public BoneConfiguration getBoneByIdentifier(@NotNull UUID identifier) {
        for (BoneConfiguration bone : this.bones) {
            if (!Objects.equals(bone.getIdentifier(), identifier)) continue;
            return bone;
        }
        return null;
    }

    @Nullable
    public RigConfiguration getRig() {
        return this.rig;
    }

    @NotNull
    public Set<AnimationConfiguration> getAnimations() {
        return Collections.unmodifiableSet(this.animations);
    }

    @Nullable
    public AnimationConfiguration getAnimationByState(@NotNull VehicleState state) {
        for (AnimationConfiguration other : this.animations) {
            if (!other.appliesTo(state)) continue;
            return other;
        }
        return null;
    }

    @Override
    public void write(@NotNull ConfigurationSection section) {
        super.write(section);
        ConfigurationUtil.writeConfigurationSectionWritables(section.createSection("parts"), this.parts, "part-");
        ConfigurationUtil.writeConfigurationSectionWritables(section.createSection("bones"), this.bones, "bone-");
        if (this.rig != null) {
            this.rig.write(section.createSection("rig"));
        }
        ConfigurationUtil.writeConfigurationSectionWritables(section.createSection("animations"), this.animations, "animation-");
    }

    public static Post19CompoundModelConfigurationBuilder builder() {
        return new Post19CompoundModelConfigurationBuilder();
    }

    public static class Post19CompoundModelConfigurationBuilder {
        private String id;
        private VehicleHitBoxConfiguration hitBox;
        private ArrayList<VehicleSeatConfiguration> seats;
        private ArrayList<PartConfiguration> parts;
        private ArrayList<BoneConfiguration> bones;
        private RigConfiguration rig;
        private ArrayList<AnimationConfiguration> animations;
        private ArrayList<VehicleParticleConfiguration> particles;
        private ArrayList<VehicleSoundConfiguration> sounds;

        Post19CompoundModelConfigurationBuilder() {
        }

        public Post19CompoundModelConfigurationBuilder id(@NotNull String id) {
            if (id == null) {
                throw new NullPointerException("id is marked non-null but is null");
            }
            this.id = id;
            return this;
        }

        public Post19CompoundModelConfigurationBuilder hitBox(@NotNull VehicleHitBoxConfiguration hitBox) {
            if (hitBox == null) {
                throw new NullPointerException("hitBox is marked non-null but is null");
            }
            this.hitBox = hitBox;
            return this;
        }

        public Post19CompoundModelConfigurationBuilder seat(VehicleSeatConfiguration seat) {
            if (this.seats == null) {
                this.seats = new ArrayList();
            }
            this.seats.add(seat);
            return this;
        }

        public Post19CompoundModelConfigurationBuilder seats(Collection<? extends VehicleSeatConfiguration> seats) {
            if (seats == null) {
                throw new NullPointerException("seats cannot be null");
            }
            if (this.seats == null) {
                this.seats = new ArrayList();
            }
            this.seats.addAll(seats);
            return this;
        }

        public Post19CompoundModelConfigurationBuilder clearSeats() {
            if (this.seats != null) {
                this.seats.clear();
            }
            return this;
        }

        public Post19CompoundModelConfigurationBuilder part(PartConfiguration part) {
            if (this.parts == null) {
                this.parts = new ArrayList();
            }
            this.parts.add(part);
            return this;
        }

        public Post19CompoundModelConfigurationBuilder parts(Collection<? extends PartConfiguration> parts) {
            if (parts == null) {
                throw new NullPointerException("parts cannot be null");
            }
            if (this.parts == null) {
                this.parts = new ArrayList();
            }
            this.parts.addAll(parts);
            return this;
        }

        public Post19CompoundModelConfigurationBuilder clearParts() {
            if (this.parts != null) {
                this.parts.clear();
            }
            return this;
        }

        public Post19CompoundModelConfigurationBuilder bone(BoneConfiguration bone) {
            if (this.bones == null) {
                this.bones = new ArrayList();
            }
            this.bones.add(bone);
            return this;
        }

        public Post19CompoundModelConfigurationBuilder bones(Collection<? extends BoneConfiguration> bones) {
            if (bones == null) {
                throw new NullPointerException("bones cannot be null");
            }
            if (this.bones == null) {
                this.bones = new ArrayList();
            }
            this.bones.addAll(bones);
            return this;
        }

        public Post19CompoundModelConfigurationBuilder clearBones() {
            if (this.bones != null) {
                this.bones.clear();
            }
            return this;
        }

        public Post19CompoundModelConfigurationBuilder rig(@Nullable RigConfiguration rig) {
            this.rig = rig;
            return this;
        }

        public Post19CompoundModelConfigurationBuilder animation(AnimationConfiguration animation) {
            if (this.animations == null) {
                this.animations = new ArrayList();
            }
            this.animations.add(animation);
            return this;
        }

        public Post19CompoundModelConfigurationBuilder animations(Collection<? extends AnimationConfiguration> animations) {
            if (animations == null) {
                throw new NullPointerException("animations cannot be null");
            }
            if (this.animations == null) {
                this.animations = new ArrayList();
            }
            this.animations.addAll(animations);
            return this;
        }

        public Post19CompoundModelConfigurationBuilder clearAnimations() {
            if (this.animations != null) {
                this.animations.clear();
            }
            return this;
        }

        public Post19CompoundModelConfigurationBuilder particle(VehicleParticleConfiguration particle) {
            if (this.particles == null) {
                this.particles = new ArrayList();
            }
            this.particles.add(particle);
            return this;
        }

        public Post19CompoundModelConfigurationBuilder particles(Collection<? extends VehicleParticleConfiguration> particles) {
            if (particles == null) {
                throw new NullPointerException("particles cannot be null");
            }
            if (this.particles == null) {
                this.particles = new ArrayList();
            }
            this.particles.addAll(particles);
            return this;
        }

        public Post19CompoundModelConfigurationBuilder clearParticles() {
            if (this.particles != null) {
                this.particles.clear();
            }
            return this;
        }

        public Post19CompoundModelConfigurationBuilder sound(VehicleSoundConfiguration sound) {
            if (this.sounds == null) {
                this.sounds = new ArrayList();
            }
            this.sounds.add(sound);
            return this;
        }

        public Post19CompoundModelConfigurationBuilder sounds(Collection<? extends VehicleSoundConfiguration> sounds) {
            if (sounds == null) {
                throw new NullPointerException("sounds cannot be null");
            }
            if (this.sounds == null) {
                this.sounds = new ArrayList();
            }
            this.sounds.addAll(sounds);
            return this;
        }

        public Post19CompoundModelConfigurationBuilder clearSounds() {
            if (this.sounds != null) {
                this.sounds.clear();
            }
            return this;
        }

        public Post19CompoundModelConfiguration build() {
            List<VehicleSoundConfiguration> sounds;
            List<VehicleParticleConfiguration> particles;
            List<AnimationConfiguration> animations;
            List<BoneConfiguration> bones;
            List<PartConfiguration> parts;
            List<VehicleSeatConfiguration> seats;
            switch (this.seats == null ? 0 : this.seats.size()) {
                case 0: {
                    seats = Collections.emptyList();
                    break;
                }
                case 1: {
                    seats = Collections.singletonList(this.seats.get(0));
                    break;
                }
                default: {
                    seats = Collections.unmodifiableList(new ArrayList<VehicleSeatConfiguration>(this.seats));
                }
            }
            switch (this.parts == null ? 0 : this.parts.size()) {
                case 0: {
                    parts = Collections.emptyList();
                    break;
                }
                case 1: {
                    parts = Collections.singletonList(this.parts.get(0));
                    break;
                }
                default: {
                    parts = Collections.unmodifiableList(new ArrayList<PartConfiguration>(this.parts));
                }
            }
            switch (this.bones == null ? 0 : this.bones.size()) {
                case 0: {
                    bones = Collections.emptyList();
                    break;
                }
                case 1: {
                    bones = Collections.singletonList(this.bones.get(0));
                    break;
                }
                default: {
                    bones = Collections.unmodifiableList(new ArrayList<BoneConfiguration>(this.bones));
                }
            }
            switch (this.animations == null ? 0 : this.animations.size()) {
                case 0: {
                    animations = Collections.emptyList();
                    break;
                }
                case 1: {
                    animations = Collections.singletonList(this.animations.get(0));
                    break;
                }
                default: {
                    animations = Collections.unmodifiableList(new ArrayList<AnimationConfiguration>(this.animations));
                }
            }
            switch (this.particles == null ? 0 : this.particles.size()) {
                case 0: {
                    particles = Collections.emptyList();
                    break;
                }
                case 1: {
                    particles = Collections.singletonList(this.particles.get(0));
                    break;
                }
                default: {
                    particles = Collections.unmodifiableList(new ArrayList<VehicleParticleConfiguration>(this.particles));
                }
            }
            switch (this.sounds == null ? 0 : this.sounds.size()) {
                case 0: {
                    sounds = Collections.emptyList();
                    break;
                }
                case 1: {
                    sounds = Collections.singletonList(this.sounds.get(0));
                    break;
                }
                default: {
                    sounds = Collections.unmodifiableList(new ArrayList<VehicleSoundConfiguration>(this.sounds));
                }
            }
            return new Post19CompoundModelConfiguration(this.id, this.hitBox, seats, parts, bones, this.rig, animations, particles, sounds);
        }

        public String toString() {
            return "Post19CompoundModelConfiguration.Post19CompoundModelConfigurationBuilder(id=" + this.id + ", hitBox=" + this.hitBox + ", seats=" + this.seats + ", parts=" + this.parts + ", bones=" + this.bones + ", rig=" + this.rig + ", animations=" + this.animations + ", particles=" + this.particles + ", sounds=" + this.sounds + ")";
        }
    }
}

