/*
 * Decompiled with CFR 0.152.
 */
package es.outlook.adriansrj.cv.api.vehicle.configuration.model.compound.post19;

import es.outlook.adriansrj.cv.api.interfaces.ConfigurationSectionWritable;
import es.outlook.adriansrj.cv.api.interfaces.IDeyed;
import es.outlook.adriansrj.cv.api.interfaces.Identifiable;
import es.outlook.adriansrj.cv.api.util.ConfigurationUtil;
import es.outlook.adriansrj.cv.api.util.inventory.ItemStackUtil;
import es.outlook.adriansrj.cv.api.vehicle.configuration.data.BannerStyle;
import es.outlook.adriansrj.cv.api.vehicle.configuration.data.DataParser;
import es.outlook.adriansrj.cv.api.vehicle.configuration.data.DataParsers;
import es.outlook.adriansrj.cv.api.vehicle.configuration.data.HeadTexture;
import java.util.UUID;
import org.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PartConfiguration
implements Identifiable,
IDeyed,
ConfigurationSectionWritable {
    @NotNull
    private final UUID identifier;
    @NotNull
    private final String id;
    @NotNull
    private final Material material;
    @Nullable
    private final Integer customModelData;
    @Nullable
    private final Object data;
    @Nullable
    private final Vector3D offset;
    @Nullable
    private final Vector3D rotation;
    @Nullable
    private final Vector3D scale;

    public static PartConfiguration load(@NotNull ConfigurationSection section) throws InvalidConfigurationException {
        DataParser parser;
        Material material = ConfigurationUtil.loadEnum(Material.class, section, "material");
        if (material == null) {
            throw new InvalidConfigurationException("invalid material: " + section.getString("material"));
        }
        Object customModelDataRaw = section.get("custom-model-data");
        Integer customModelData = customModelDataRaw instanceof Number ? Integer.valueOf(((Number)customModelDataRaw).intValue()) : null;
        Object data = null;
        ConfigurationSection dataSection = section.getConfigurationSection("data");
        if (dataSection != null && (parser = DataParsers.matchParser(dataSection)) != null) {
            data = parser.parse(dataSection);
        }
        Vector3D offset = ConfigurationUtil.loadLibraryObject(Vector3D.class, section, "offset");
        Vector3D rotation = ConfigurationUtil.loadLibraryObject(Vector3D.class, section, "rotation");
        Vector3D scale = ConfigurationUtil.loadLibraryObject(Vector3D.class, section, "scale");
        return new PartConfiguration(Identifiable.loadIdentifierOrGenerate(section), IDeyed.loadId(section), material, customModelData, data, offset, rotation, scale);
    }

    @NotNull
    public ItemStack getItemStack() {
        ItemStack item = ItemStackUtil.buildCustomItem(this.material, this.customModelData);
        if (ItemStackUtil.isHead(this.material) && this.data instanceof HeadTexture) {
            ((HeadTexture)this.data).applyTexture(item);
        } else if (ItemStackUtil.isBanner(this.material) && this.data instanceof BannerStyle) {
            ((BannerStyle)this.data).applyStyle(item);
        }
        return item;
    }

    @Override
    public void write(@NotNull ConfigurationSection section) {
        DataParser parser;
        Identifiable.writeIdentifier(this, section);
        IDeyed.writeId(this, section);
        section.set("material", (Object)this.material.name());
        if (this.customModelData != null) {
            section.set("custom-model-data", (Object)this.customModelData);
        }
        if (this.data != null && (parser = DataParsers.getParser(this.data.getClass())) != null) {
            parser.write(this.data, section.createSection("data"));
        }
        if (this.offset != null) {
            ConfigurationUtil.writeLibraryObject(Vector3D.class, this.offset, section.createSection("offset"));
        }
        if (this.rotation != null) {
            ConfigurationUtil.writeLibraryObject(Vector3D.class, this.rotation, section.createSection("rotation"));
        }
        if (this.scale != null) {
            ConfigurationUtil.writeLibraryObject(Vector3D.class, this.scale, section.createSection("scale"));
        }
    }

    public static PartConfigurationBuilder builder() {
        return new PartConfigurationBuilder();
    }

    @Override
    @NotNull
    public UUID getIdentifier() {
        return this.identifier;
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public Material getMaterial() {
        return this.material;
    }

    @Nullable
    public Integer getCustomModelData() {
        return this.customModelData;
    }

    @Nullable
    public Object getData() {
        return this.data;
    }

    @Nullable
    public Vector3D getOffset() {
        return this.offset;
    }

    @Nullable
    public Vector3D getRotation() {
        return this.rotation;
    }

    @Nullable
    public Vector3D getScale() {
        return this.scale;
    }

    public PartConfiguration(@NotNull UUID identifier, @NotNull String id, @NotNull Material material, @Nullable Integer customModelData, @Nullable Object data, @Nullable Vector3D offset, @Nullable Vector3D rotation, @Nullable Vector3D scale) {
        if (identifier == null) {
            throw new NullPointerException("identifier is marked non-null but is null");
        }
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        if (material == null) {
            throw new NullPointerException("material is marked non-null but is null");
        }
        this.identifier = identifier;
        this.id = id;
        this.material = material;
        this.customModelData = customModelData;
        this.data = data;
        this.offset = offset;
        this.rotation = rotation;
        this.scale = scale;
    }

    public static class PartConfigurationBuilder {
        private UUID identifier;
        private String id;
        private Material material;
        private Integer customModelData;
        private Object data;
        private Vector3D offset;
        private Vector3D rotation;
        private Vector3D scale;

        PartConfigurationBuilder() {
        }

        public PartConfigurationBuilder identifier(@NotNull UUID identifier) {
            if (identifier == null) {
                throw new NullPointerException("identifier is marked non-null but is null");
            }
            this.identifier = identifier;
            return this;
        }

        public PartConfigurationBuilder id(@NotNull String id) {
            if (id == null) {
                throw new NullPointerException("id is marked non-null but is null");
            }
            this.id = id;
            return this;
        }

        public PartConfigurationBuilder material(@NotNull Material material) {
            if (material == null) {
                throw new NullPointerException("material is marked non-null but is null");
            }
            this.material = material;
            return this;
        }

        public PartConfigurationBuilder customModelData(@Nullable Integer customModelData) {
            this.customModelData = customModelData;
            return this;
        }

        public PartConfigurationBuilder data(@Nullable Object data) {
            this.data = data;
            return this;
        }

        public PartConfigurationBuilder offset(@Nullable Vector3D offset) {
            this.offset = offset;
            return this;
        }

        public PartConfigurationBuilder rotation(@Nullable Vector3D rotation) {
            this.rotation = rotation;
            return this;
        }

        public PartConfigurationBuilder scale(@Nullable Vector3D scale) {
            this.scale = scale;
            return this;
        }

        public PartConfiguration build() {
            return new PartConfiguration(this.identifier, this.id, this.material, this.customModelData, this.data, this.offset, this.rotation, this.scale);
        }

        public String toString() {
            return "PartConfiguration.PartConfigurationBuilder(identifier=" + this.identifier + ", id=" + this.id + ", material=" + this.material + ", customModelData=" + this.customModelData + ", data=" + this.data + ", offset=" + this.offset + ", rotation=" + this.rotation + ", scale=" + this.scale + ")";
        }
    }
}

