/*
 * Decompiled with CFR 0.152.
 */
package es.outlook.adriansrj.cv.api.vehicle.configuration.model.compound.post19;

import es.outlook.adriansrj.cv.api.interfaces.ConfigurationSectionWritable;
import es.outlook.adriansrj.cv.api.interfaces.IDeyed;
import es.outlook.adriansrj.cv.api.interfaces.Identifiable;
import es.outlook.adriansrj.cv.api.util.ConfigurationUtil;
import java.util.UUID;
import org.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BoneConfiguration
implements Identifiable,
IDeyed,
ConfigurationSectionWritable {
    @NotNull
    private final UUID identifier;
    @NotNull
    private final String id;
    @NotNull
    private final Vector3D pivot;
    @Nullable
    private final Vector3D rotation;

    public static BoneConfiguration load(@NotNull ConfigurationSection section) throws InvalidConfigurationException {
        Vector3D pivot = ConfigurationUtil.loadLibraryObject(Vector3D.class, section, "pivot");
        Vector3D rotation = ConfigurationUtil.loadLibraryObject(Vector3D.class, section, "rotation");
        if (pivot == null) {
            throw new InvalidConfigurationException("pivot must be set");
        }
        return new BoneConfiguration(Identifiable.loadIdentifierOrGenerate(section), IDeyed.loadId(section), pivot, rotation);
    }

    @Override
    public void write(@NotNull ConfigurationSection section) {
        Identifiable.writeIdentifier(this, section);
        IDeyed.writeId(this, section);
        ConfigurationUtil.writeLibraryObject(Vector3D.class, this.pivot, section.createSection("pivot"));
        if (this.rotation != null) {
            ConfigurationUtil.writeLibraryObject(Vector3D.class, this.rotation, section.createSection("rotation"));
        }
    }

    public static BoneConfigurationBuilder builder() {
        return new BoneConfigurationBuilder();
    }

    @Override
    @NotNull
    public UUID getIdentifier() {
        return this.identifier;
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public Vector3D getPivot() {
        return this.pivot;
    }

    @Nullable
    public Vector3D getRotation() {
        return this.rotation;
    }

    public BoneConfiguration(@NotNull UUID identifier, @NotNull String id, @NotNull Vector3D pivot, @Nullable Vector3D rotation) {
        if (identifier == null) {
            throw new NullPointerException("identifier is marked non-null but is null");
        }
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        if (pivot == null) {
            throw new NullPointerException("pivot is marked non-null but is null");
        }
        this.identifier = identifier;
        this.id = id;
        this.pivot = pivot;
        this.rotation = rotation;
    }

    public static class BoneConfigurationBuilder {
        private UUID identifier;
        private String id;
        private Vector3D pivot;
        private Vector3D rotation;

        BoneConfigurationBuilder() {
        }

        public BoneConfigurationBuilder identifier(@NotNull UUID identifier) {
            if (identifier == null) {
                throw new NullPointerException("identifier is marked non-null but is null");
            }
            this.identifier = identifier;
            return this;
        }

        public BoneConfigurationBuilder id(@NotNull String id) {
            if (id == null) {
                throw new NullPointerException("id is marked non-null but is null");
            }
            this.id = id;
            return this;
        }

        public BoneConfigurationBuilder pivot(@NotNull Vector3D pivot) {
            if (pivot == null) {
                throw new NullPointerException("pivot is marked non-null but is null");
            }
            this.pivot = pivot;
            return this;
        }

        public BoneConfigurationBuilder rotation(@Nullable Vector3D rotation) {
            this.rotation = rotation;
            return this;
        }

        public BoneConfiguration build() {
            return new BoneConfiguration(this.identifier, this.id, this.pivot, this.rotation);
        }

        public String toString() {
            return "BoneConfiguration.BoneConfigurationBuilder(identifier=" + this.identifier + ", id=" + this.id + ", pivot=" + this.pivot + ", rotation=" + this.rotation + ")";
        }
    }
}

