/*
 * Decompiled with CFR 0.152.
 */
package es.outlook.adriansrj.cv.api.vehicle.configuration.model.compound.post19;

import es.outlook.adriansrj.cv.api.interfaces.ConfigurationSectionWritable;
import es.outlook.adriansrj.cv.api.util.ConfigurationUtil;
import es.outlook.adriansrj.cv.api.vehicle.configuration.model.compound.post19.BoneConfiguration;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnimationKeyframeConfiguration
implements ConfigurationSectionWritable {
    private final int duration;
    private final Map<UUID, Vector3D> translations = new HashMap<UUID, Vector3D>();
    private final Map<UUID, Vector3D> rotations = new HashMap<UUID, Vector3D>();
    private final Map<UUID, Vector3D> scales = new HashMap<UUID, Vector3D>();

    public static AnimationKeyframeConfiguration load(@NotNull ConfigurationSection section) throws InvalidConfigurationException {
        int duration = section.getInt("duration");
        if (duration < 0) {
            throw new InvalidConfigurationException("duration cannot be negative");
        }
        Map<UUID, Vector3D> translations = AnimationKeyframeConfiguration.loadVectors(section, "translations");
        Map<UUID, Vector3D> rotations = AnimationKeyframeConfiguration.loadVectors(section, "rotations");
        Map<UUID, Vector3D> scales = AnimationKeyframeConfiguration.loadVectors(section, "scales");
        if (translations.isEmpty() && rotations.isEmpty() && scales.isEmpty()) {
            throw new InvalidConfigurationException("at least one transformation is required");
        }
        return new AnimationKeyframeConfiguration(duration, translations, rotations, scales);
    }

    private static Map<UUID, Vector3D> loadVectors(ConfigurationSection root, String sectionName) throws InvalidConfigurationException {
        HashMap<UUID, Vector3D> map = new HashMap<UUID, Vector3D>();
        for (ConfigurationSection section : ConfigurationUtil.getConfigurationSectionsAfter(root, sectionName, false)) {
            Vector3D value;
            ConfigurationSection valueSection;
            UUID identifier = ConfigurationUtil.loadLibrarySingleEntryObject(UUID.class, section, "identifier");
            if (identifier == null || (valueSection = section.getConfigurationSection("value")) == null || (value = ConfigurationUtil.loadLibraryObject(Vector3D.class, valueSection)) == null) continue;
            map.put(identifier, value);
        }
        return map;
    }

    public AnimationKeyframeConfiguration(int duration, @Nullable Map<UUID, Vector3D> translations, @Nullable Map<UUID, Vector3D> rotations, @Nullable Map<UUID, Vector3D> scales) {
        this.duration = duration;
        if (translations != null) {
            this.translations.putAll(translations);
        }
        if (rotations != null) {
            this.rotations.putAll(rotations);
        }
        if (scales != null) {
            this.scales.putAll(scales);
        }
    }

    public int getDuration() {
        return this.duration;
    }

    public Map<UUID, Vector3D> getTranslations() {
        return Collections.unmodifiableMap(this.translations);
    }

    @Nullable
    public Vector3D getTranslation(@NotNull UUID boneIdentifier) {
        return this.translations.get(boneIdentifier);
    }

    @Nullable
    public Vector3D getTranslation(@NotNull BoneConfiguration bone) {
        return this.getTranslation(bone.getIdentifier());
    }

    public Map<UUID, Vector3D> getRotations() {
        return Collections.unmodifiableMap(this.rotations);
    }

    @Nullable
    public Vector3D getRotation(@NotNull UUID boneIdentifier) {
        return this.rotations.get(boneIdentifier);
    }

    @Nullable
    public Vector3D getRotation(@NotNull BoneConfiguration bone) {
        return this.getRotation(bone.getIdentifier());
    }

    public Map<UUID, Vector3D> getScales() {
        return Collections.unmodifiableMap(this.scales);
    }

    @Nullable
    public Vector3D getScale(@NotNull UUID boneIdentifier) {
        return this.scales.get(boneIdentifier);
    }

    @Nullable
    public Vector3D getScale(@NotNull BoneConfiguration bone) {
        return this.getScale(bone.getIdentifier());
    }

    @Override
    public void write(@NotNull ConfigurationSection section) {
        section.set("duration", (Object)this.duration);
        this.writeVectors(this.translations, section, "translations");
        this.writeVectors(this.rotations, section, "rotations");
        this.writeVectors(this.scales, section, "scales");
    }

    private void writeVectors(Map<UUID, Vector3D> vectors, ConfigurationSection root, String sectionName) {
        if (vectors.size() == 0) {
            root.set(sectionName, null);
            return;
        }
        ConfigurationSection vectorsSection = root.createSection(sectionName);
        int count = 0;
        for (Map.Entry<UUID, Vector3D> entry : vectors.entrySet()) {
            ConfigurationSection section = vectorsSection.createSection("v-" + count++);
            ConfigurationUtil.writeSingleEntryLibraryObject(UUID.class, entry.getKey(), section, "identifier");
            ConfigurationUtil.writeLibraryObject(Vector3D.class, entry.getValue(), section.createSection("value"));
        }
    }

    public static AnimationKeyframeConfigurationBuilder builder() {
        return new AnimationKeyframeConfigurationBuilder();
    }

    public String toString() {
        return "AnimationKeyframeConfiguration(duration=" + this.getDuration() + ", translations=" + this.getTranslations() + ", rotations=" + this.getRotations() + ", scales=" + this.getScales() + ")";
    }

    public static class AnimationKeyframeConfigurationBuilder {
        private int duration;
        private Map<UUID, Vector3D> translations;
        private Map<UUID, Vector3D> rotations;
        private Map<UUID, Vector3D> scales;

        AnimationKeyframeConfigurationBuilder() {
        }

        public AnimationKeyframeConfigurationBuilder duration(int duration) {
            this.duration = duration;
            return this;
        }

        public AnimationKeyframeConfigurationBuilder translations(@Nullable Map<UUID, Vector3D> translations) {
            this.translations = translations;
            return this;
        }

        public AnimationKeyframeConfigurationBuilder rotations(@Nullable Map<UUID, Vector3D> rotations) {
            this.rotations = rotations;
            return this;
        }

        public AnimationKeyframeConfigurationBuilder scales(@Nullable Map<UUID, Vector3D> scales) {
            this.scales = scales;
            return this;
        }

        public AnimationKeyframeConfiguration build() {
            return new AnimationKeyframeConfiguration(this.duration, this.translations, this.rotations, this.scales);
        }

        public String toString() {
            return "AnimationKeyframeConfiguration.AnimationKeyframeConfigurationBuilder(duration=" + this.duration + ", translations=" + this.translations + ", rotations=" + this.rotations + ", scales=" + this.scales + ")";
        }
    }
}

