/*
 * Decompiled with CFR 0.152.
 */
package es.outlook.adriansrj.cv.api.vehicle.configuration.model.compound.post19;

import es.outlook.adriansrj.cv.api.enums.EnumInterpolationMode;
import es.outlook.adriansrj.cv.api.enums.EnumLoopMode;
import es.outlook.adriansrj.cv.api.interfaces.ConfigurationSectionWritable;
import es.outlook.adriansrj.cv.api.interfaces.Named;
import es.outlook.adriansrj.cv.api.util.ConfigurationUtil;
import es.outlook.adriansrj.cv.api.vehicle.VehicleState;
import es.outlook.adriansrj.cv.api.vehicle.configuration.model.compound.post19.AnimationKeyframeConfiguration;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.jetbrains.annotations.NotNull;

public class AnimationConfiguration
implements ConfigurationSectionWritable,
Named {
    @NotNull
    private final String name;
    @NotNull
    private final EnumInterpolationMode interpolationMode;
    @NotNull
    private final EnumLoopMode loopMode;
    @NotNull
    private final List<AnimationKeyframeConfiguration> keyframes;
    @NotNull
    private final Set<String> statesToApply = new THashSet();

    public static AnimationConfiguration load(@NotNull ConfigurationSection section) throws InvalidConfigurationException {
        String name = Named.loadName(section);
        EnumInterpolationMode interpolationMode = ConfigurationUtil.loadEnum(EnumInterpolationMode.class, section, "interpolation-mode");
        EnumLoopMode loopMode = ConfigurationUtil.loadEnum(EnumLoopMode.class, section, "loop-mode");
        if (interpolationMode == null) {
            throw new InvalidConfigurationException("invalid interpolation mode");
        }
        if (loopMode == null) {
            throw new InvalidConfigurationException("invalid loop mode");
        }
        ConfigurationSection keyframesSection = section.getConfigurationSection("keyframes");
        ArrayList<AnimationKeyframeConfiguration> keyframes = new ArrayList<AnimationKeyframeConfiguration>();
        if (keyframesSection != null) {
            for (String key : keyframesSection.getKeys(false)) {
                ConfigurationSection keyframeSection = keyframesSection.getConfigurationSection(key);
                AnimationKeyframeConfiguration keyframe = keyframeSection != null ? AnimationKeyframeConfiguration.load(keyframeSection) : null;
                if (keyframe == null) continue;
                keyframes.add(keyframe);
            }
        }
        if (keyframes.size() == 0) {
            throw new InvalidConfigurationException("at least one keyframe must be set");
        }
        THashSet statesToApply = new THashSet();
        String statesToApplyString = section.getString("states-to-apply");
        if (StringUtils.isNotBlank((String)statesToApplyString)) {
            String[] states = statesToApplyString.split(",");
            Arrays.stream(states).filter(StringUtils::isNotBlank).map(string -> string.toLowerCase().trim()).forEach(((Set)statesToApply)::add);
        }
        return new AnimationConfiguration(name, interpolationMode, loopMode, keyframes, (Collection<String>)statesToApply);
    }

    public AnimationConfiguration(@NotNull String name, @NotNull EnumInterpolationMode interpolationMode, @NotNull EnumLoopMode loopMode, @NotNull List<AnimationKeyframeConfiguration> keyframes, @NotNull Collection<String> statesToApply) {
        this.name = name;
        this.interpolationMode = interpolationMode;
        this.loopMode = loopMode;
        this.keyframes = keyframes;
        this.statesToApply.addAll(statesToApply);
    }

    public boolean appliesTo(@NotNull VehicleState state) {
        for (String name : this.statesToApply) {
            if (!state.getName().equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void write(@NotNull ConfigurationSection section) {
        Named.writeName(this, section);
        ConfigurationUtil.writeEnum(this.interpolationMode, section, "interpolation-mode");
        ConfigurationUtil.writeEnum(this.loopMode, section, "loop-mode");
        ConfigurationSection keyframesSection = section.createSection("keyframes");
        for (int i = 0; i < this.keyframes.size(); ++i) {
            this.keyframes.get(i).write(keyframesSection.createSection("keyframe-" + i));
        }
        if (this.statesToApply.size() > 0) {
            section.set("states-to-apply", (Object)String.join((CharSequence)",", this.statesToApply));
        } else {
            section.set("states-to-apply", null);
        }
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public EnumInterpolationMode getInterpolationMode() {
        return this.interpolationMode;
    }

    @NotNull
    public EnumLoopMode getLoopMode() {
        return this.loopMode;
    }

    @NotNull
    public List<AnimationKeyframeConfiguration> getKeyframes() {
        return this.keyframes;
    }

    @NotNull
    public Set<String> getStatesToApply() {
        return this.statesToApply;
    }

    public String toString() {
        return "AnimationConfiguration(name=" + this.getName() + ", interpolationMode=" + (Object)((Object)this.getInterpolationMode()) + ", loopMode=" + (Object)((Object)this.getLoopMode()) + ", keyframes=" + this.getKeyframes() + ", statesToApply=" + this.getStatesToApply() + ")";
    }
}

