/*
 * Decompiled with CFR 0.152.
 */
package es.outlook.adriansrj.cv.api.vehicle.configuration.model;

import com.google.common.base.Preconditions;
import es.outlook.adriansrj.cv.api.interfaces.ConfigurationSectionWritable;
import es.outlook.adriansrj.cv.api.interfaces.Validable;
import es.outlook.adriansrj.cv.api.util.ConfigurationUtil;
import es.outlook.adriansrj.cv.api.util.reflection.EnumReflection;
import es.outlook.adriansrj.cv.api.vehicle.VehicleState;
import gnu.trove.set.hash.THashSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VehicleSoundConfiguration
implements ConfigurationSectionWritable,
Validable {
    @Nullable
    protected final Sound type;
    @Nullable
    protected final String typeCustom;
    @Nullable
    protected final SoundCategory category;
    protected final int delay;
    protected final float volume;
    protected final float pitch;
    protected final boolean global;
    private final Set<String> statesToApply = new THashSet();

    public static VehicleSoundConfiguration load(@NotNull ConfigurationSection section) throws InvalidConfigurationException {
        String typeString = section.getString("type");
        String typeCustom = null;
        if (StringUtils.isBlank((String)typeString)) {
            throw new InvalidConfigurationException("sound type must be set");
        }
        Sound type = EnumReflection.getEnumConstant(Sound.class, typeString.trim().toUpperCase());
        if (type == null) {
            typeCustom = typeString;
        }
        SoundCategory category = ConfigurationUtil.loadEnum(SoundCategory.class, section, "category");
        int delay = section.getInt("delay");
        float volume = section.getInt("volume");
        float pitch = section.getInt("pitch");
        boolean global = section.getBoolean("global");
        if (delay < 0) {
            throw new InvalidConfigurationException("delay cannot be negative");
        }
        if (volume <= 0.0f) {
            throw new InvalidConfigurationException("volume must be greater than 0");
        }
        THashSet statesToApply = new THashSet();
        String statesToApplyString = section.getString("states-to-apply");
        if (StringUtils.isNotBlank((String)statesToApplyString)) {
            String[] states = statesToApplyString.split(",");
            Arrays.stream(states).filter(StringUtils::isNotBlank).map(string -> string.toLowerCase().trim()).forEach(((Set)statesToApply)::add);
        }
        return new VehicleSoundConfiguration(type, typeCustom, category, delay, volume, pitch, global, (Collection<String>)statesToApply);
    }

    public boolean appliesTo(@NotNull VehicleState state) {
        for (String name : this.statesToApply) {
            if (!state.getName().equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public VehicleSoundConfiguration(@Nullable Sound type, @Nullable String typeCustom, @Nullable SoundCategory category, int delay, float volume, float pitch, boolean global, @Nullable Collection<String> statesToApply) {
        Preconditions.checkArgument((type != null || StringUtils.isNotBlank((String)typeCustom) ? 1 : 0) != 0, (Object)"either a valid type or a valid typeCustom must be provided");
        if (type == null) {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)typeCustom), (Object)"typeCustom cannot be blank");
        }
        Preconditions.checkArgument((delay >= 0 ? 1 : 0) != 0, (Object)"delay cannot be negative");
        Preconditions.checkArgument((volume > 0.0f ? 1 : 0) != 0, (Object)"volume must be > 0");
        this.type = type;
        this.typeCustom = typeCustom;
        this.category = category;
        this.delay = delay;
        this.volume = volume;
        this.pitch = pitch;
        this.global = global;
        if (statesToApply != null) {
            this.statesToApply.addAll(statesToApply);
        }
    }

    public VehicleSoundConfiguration(@NotNull Sound type, @Nullable SoundCategory category, int delay, float volume, float pitch, boolean global, @Nullable Collection<String> statesToApply) {
        this(type, null, category, delay, volume, pitch, global, statesToApply);
    }

    public VehicleSoundConfiguration(@NotNull String typeCustom, @Nullable SoundCategory category, int delay, float volume, float pitch, boolean global, @Nullable Collection<String> statesToApply) {
        this(null, typeCustom, category, delay, volume, pitch, global, statesToApply);
    }

    @Override
    public boolean isValid() {
        return this.type != null || StringUtils.isNotBlank((String)this.typeCustom);
    }

    public boolean applies(@NotNull VehicleState state) {
        return this.statesToApply.contains(state.getName());
    }

    @Override
    public void write(@NotNull ConfigurationSection section) {
        if (this.type != null) {
            section.set("type", (Object)this.type.name());
        } else if (StringUtils.isNotBlank((String)this.typeCustom)) {
            section.set("type", (Object)this.typeCustom);
        }
        if (this.category != null) {
            ConfigurationUtil.writeEnum(this.category, section, "category");
        }
        section.set("delay", (Object)this.delay);
        section.set("volume", (Object)Float.valueOf(this.volume));
        section.set("pitch", (Object)Float.valueOf(this.pitch));
        section.set("global", (Object)this.global);
        if (this.statesToApply.size() > 0) {
            section.set("states-to-apply", (Object)String.join((CharSequence)",", this.statesToApply));
        } else {
            section.set("states-to-apply", null);
        }
    }

    public static VehicleSoundConfigurationBuilder builder() {
        return new VehicleSoundConfigurationBuilder();
    }

    public static VehicleSoundConfigurationBuilder builderCustomType() {
        return new VehicleSoundConfigurationBuilder();
    }

    @Nullable
    public Sound getType() {
        return this.type;
    }

    @Nullable
    public String getTypeCustom() {
        return this.typeCustom;
    }

    @Nullable
    public SoundCategory getCategory() {
        return this.category;
    }

    public int getDelay() {
        return this.delay;
    }

    public float getVolume() {
        return this.volume;
    }

    public float getPitch() {
        return this.pitch;
    }

    public boolean isGlobal() {
        return this.global;
    }

    public Set<String> getStatesToApply() {
        return this.statesToApply;
    }

    public static class VehicleSoundConfigurationBuilder {
        private Sound type;
        private SoundCategory category;
        private int delay;
        private float volume;
        private float pitch;
        private boolean global;
        private Collection<String> statesToApply;
        private String typeCustom;

        VehicleSoundConfigurationBuilder() {
        }

        public VehicleSoundConfigurationBuilder type(@NotNull Sound type) {
            if (type == null) {
                throw new NullPointerException("type is marked non-null but is null");
            }
            this.type = type;
            return this;
        }

        public VehicleSoundConfigurationBuilder category(@Nullable SoundCategory category) {
            this.category = category;
            return this;
        }

        public VehicleSoundConfigurationBuilder delay(int delay) {
            this.delay = delay;
            return this;
        }

        public VehicleSoundConfigurationBuilder volume(float volume) {
            this.volume = volume;
            return this;
        }

        public VehicleSoundConfigurationBuilder pitch(float pitch) {
            this.pitch = pitch;
            return this;
        }

        public VehicleSoundConfigurationBuilder global(boolean global) {
            this.global = global;
            return this;
        }

        public VehicleSoundConfigurationBuilder statesToApply(@Nullable Collection<String> statesToApply) {
            this.statesToApply = statesToApply;
            return this;
        }

        public VehicleSoundConfiguration build() {
            return new VehicleSoundConfiguration(this.type, this.category, this.delay, this.volume, this.pitch, this.global, this.statesToApply);
        }

        public String toString() {
            return "VehicleSoundConfiguration.VehicleSoundConfigurationBuilder(type=" + this.type + ", category=" + this.category + ", delay=" + this.delay + ", volume=" + this.volume + ", pitch=" + this.pitch + ", global=" + this.global + ", statesToApply=" + this.statesToApply + ")";
        }

        public VehicleSoundConfigurationBuilder typeCustom(@NotNull String typeCustom) {
            if (typeCustom == null) {
                throw new NullPointerException("typeCustom is marked non-null but is null");
            }
            this.typeCustom = typeCustom;
            return this;
        }
    }
}

