/*
 * Decompiled with CFR 0.152.
 */
package es.outlook.adriansrj.cv.api.vehicle.configuration.model;

import es.outlook.adriansrj.cv.api.interfaces.ConfigurationSectionWritable;
import es.outlook.adriansrj.cv.api.util.ConfigurationUtil;
import org.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.jetbrains.annotations.NotNull;

public class VehicleSeatConfiguration
implements ConfigurationSectionWritable {
    private final boolean main;
    @NotNull
    private final Vector3D offset;

    public static VehicleSeatConfiguration load(@NotNull ConfigurationSection section) throws InvalidConfigurationException {
        boolean main = section.getBoolean("main");
        Vector3D offset = ConfigurationUtil.loadLibraryObject(Vector3D.class, section, "offset");
        if (offset == null) {
            throw new InvalidConfigurationException("seat requires offset to be set");
        }
        return new VehicleSeatConfiguration(main, offset);
    }

    @Override
    public void write(@NotNull ConfigurationSection section) {
        section.set("main", (Object)this.main);
        ConfigurationUtil.writeLibraryObject(Vector3D.class, this.offset, section.createSection("offset"));
    }

    public static VehicleSeatConfigurationBuilder builder() {
        return new VehicleSeatConfigurationBuilder();
    }

    public boolean isMain() {
        return this.main;
    }

    @NotNull
    public Vector3D getOffset() {
        return this.offset;
    }

    public VehicleSeatConfiguration(boolean main, @NotNull Vector3D offset) {
        if (offset == null) {
            throw new NullPointerException("offset is marked non-null but is null");
        }
        this.main = main;
        this.offset = offset;
    }

    public static class VehicleSeatConfigurationBuilder {
        private boolean main;
        private Vector3D offset;

        VehicleSeatConfigurationBuilder() {
        }

        public VehicleSeatConfigurationBuilder main(boolean main) {
            this.main = main;
            return this;
        }

        public VehicleSeatConfigurationBuilder offset(@NotNull Vector3D offset) {
            if (offset == null) {
                throw new NullPointerException("offset is marked non-null but is null");
            }
            this.offset = offset;
            return this;
        }

        public VehicleSeatConfiguration build() {
            return new VehicleSeatConfiguration(this.main, this.offset);
        }

        public String toString() {
            return "VehicleSeatConfiguration.VehicleSeatConfigurationBuilder(main=" + this.main + ", offset=" + this.offset + ")";
        }
    }
}

