/*
 * Decompiled with CFR 0.152.
 */
package es.outlook.adriansrj.cv.api.vehicle.configuration.model;

import com.google.common.base.Preconditions;
import es.outlook.adriansrj.cv.api.interfaces.ConfigurationSectionWritable;
import es.outlook.adriansrj.cv.api.interfaces.Validable;
import es.outlook.adriansrj.cv.api.util.ConfigurationUtil;
import es.outlook.adriansrj.cv.api.vehicle.VehicleState;
import es.outlook.adriansrj.cv.api.vehicle.configuration.data.DataParser;
import es.outlook.adriansrj.cv.api.vehicle.configuration.data.DataParsers;
import gnu.trove.set.hash.THashSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import org.bukkit.Particle;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VehicleParticleConfiguration
implements ConfigurationSectionWritable,
Validable {
    @NotNull
    private final Particle type;
    @NotNull
    private final Vector3D offset;
    private final int delay;
    private final int count;
    private final float dispersion;
    @Nullable
    private final Object data;
    private final Set<String> statesToApply = new THashSet();

    public static VehicleParticleConfiguration load(@NotNull ConfigurationSection section) throws InvalidConfigurationException {
        DataParser parser;
        Particle type = ConfigurationUtil.loadEnum(Particle.class, section, "type");
        if (type == null) {
            throw new InvalidConfigurationException("invalid particle type");
        }
        Vector3D offset = ConfigurationUtil.loadLibraryObject(Vector3D.class, section, "offset");
        if (offset == null) {
            throw new InvalidConfigurationException("particle requires offset to be set");
        }
        int delay = section.getInt("delay");
        int count = section.getInt("count");
        float dispersion = (float)section.getDouble("dispersion");
        Object data = null;
        ConfigurationSection dataSection = section.getConfigurationSection("data");
        if (dataSection != null && (parser = DataParsers.matchParser(dataSection)) != null) {
            data = parser.parse(dataSection);
        }
        THashSet statesToApply = new THashSet();
        String statesToApplyString = section.getString("states-to-apply");
        if (StringUtils.isNotBlank((String)statesToApplyString)) {
            String[] states = statesToApplyString.split(",");
            Arrays.stream(states).filter(StringUtils::isNotBlank).map(string -> string.toLowerCase().trim()).forEach(((Set)statesToApply)::add);
        }
        return new VehicleParticleConfiguration(type, offset, delay, count, dispersion, data, (Collection<String>)statesToApply);
    }

    public VehicleParticleConfiguration(@NotNull Particle type, @NotNull Vector3D offset, int delay, int count, float dispersion, @Nullable Object data, @Nullable Collection<String> statesToApply) {
        Preconditions.checkArgument((delay >= 0 ? 1 : 0) != 0, (Object)"delay cannot be negative");
        Preconditions.checkArgument((count > 0 ? 1 : 0) != 0, (Object)"count must be > 0");
        Preconditions.checkArgument((dispersion >= 0.0f ? 1 : 0) != 0, (Object)"dispersion cannot be negative");
        this.type = type;
        this.offset = offset;
        this.delay = delay;
        this.count = count;
        this.dispersion = dispersion;
        this.data = data;
        if (statesToApply != null) {
            this.statesToApply.addAll(statesToApply);
        }
    }

    @Override
    public boolean isValid() {
        Class dataType = this.type.getDataType();
        return dataType == Void.class || this.data != null && dataType.isAssignableFrom(this.data.getClass());
    }

    @Nullable
    public <T> T getDataAs(Class<T> type) {
        return type.cast(this.data);
    }

    public boolean appliesTo(@NotNull VehicleState state) {
        for (String name : this.statesToApply) {
            if (!state.getName().equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void write(@NotNull ConfigurationSection section) {
        DataParser parser;
        ConfigurationUtil.writeEnum(this.type, section, "type");
        ConfigurationUtil.writeLibraryObject(Vector3D.class, this.offset, section.createSection("offset"));
        section.set("delay", (Object)this.delay);
        section.set("count", (Object)this.count);
        section.set("dispersion", (Object)Float.valueOf(this.dispersion));
        if (this.data != null && (parser = DataParsers.getParser(this.data.getClass())) != null) {
            parser.write(this.data, section.createSection("data"));
        }
        if (this.statesToApply.size() > 0) {
            section.set("states-to-apply", (Object)String.join((CharSequence)",", this.statesToApply));
        } else {
            section.set("states-to-apply", null);
        }
    }

    public static VehicleParticleConfigurationBuilder builder() {
        return new VehicleParticleConfigurationBuilder();
    }

    @NotNull
    public Particle getType() {
        return this.type;
    }

    @NotNull
    public Vector3D getOffset() {
        return this.offset;
    }

    public int getDelay() {
        return this.delay;
    }

    public int getCount() {
        return this.count;
    }

    public float getDispersion() {
        return this.dispersion;
    }

    @Nullable
    public Object getData() {
        return this.data;
    }

    public Set<String> getStatesToApply() {
        return this.statesToApply;
    }

    public static class VehicleParticleConfigurationBuilder {
        private Particle type;
        private Vector3D offset;
        private int delay;
        private int count;
        private float dispersion;
        private Object data;
        private Collection<String> statesToApply;

        VehicleParticleConfigurationBuilder() {
        }

        public VehicleParticleConfigurationBuilder type(@NotNull Particle type) {
            if (type == null) {
                throw new NullPointerException("type is marked non-null but is null");
            }
            this.type = type;
            return this;
        }

        public VehicleParticleConfigurationBuilder offset(@NotNull Vector3D offset) {
            if (offset == null) {
                throw new NullPointerException("offset is marked non-null but is null");
            }
            this.offset = offset;
            return this;
        }

        public VehicleParticleConfigurationBuilder delay(int delay) {
            this.delay = delay;
            return this;
        }

        public VehicleParticleConfigurationBuilder count(int count) {
            this.count = count;
            return this;
        }

        public VehicleParticleConfigurationBuilder dispersion(float dispersion) {
            this.dispersion = dispersion;
            return this;
        }

        public VehicleParticleConfigurationBuilder data(@Nullable Object data) {
            this.data = data;
            return this;
        }

        public VehicleParticleConfigurationBuilder statesToApply(@Nullable Collection<String> statesToApply) {
            this.statesToApply = statesToApply;
            return this;
        }

        public VehicleParticleConfiguration build() {
            return new VehicleParticleConfiguration(this.type, this.offset, this.delay, this.count, this.dispersion, this.data, this.statesToApply);
        }

        public String toString() {
            return "VehicleParticleConfiguration.VehicleParticleConfigurationBuilder(type=" + this.type + ", offset=" + this.offset + ", delay=" + this.delay + ", count=" + this.count + ", dispersion=" + this.dispersion + ", data=" + this.data + ", statesToApply=" + this.statesToApply + ")";
        }
    }
}

