/*
 * Decompiled with CFR 0.152.
 */
package es.outlook.adriansrj.cv.api.vehicle.configuration.model;

import com.google.common.base.Preconditions;
import es.outlook.adriansrj.cv.api.enums.EnumServerVersion;
import es.outlook.adriansrj.cv.api.enums.EnumVehicleModelType;
import es.outlook.adriansrj.cv.api.interfaces.ConfigurationSectionWritable;
import es.outlook.adriansrj.cv.api.interfaces.IDeyed;
import es.outlook.adriansrj.cv.api.util.ConfigurationUtil;
import es.outlook.adriansrj.cv.api.util.reflection.EnumReflection;
import es.outlook.adriansrj.cv.api.vehicle.configuration.model.VehicleHitBoxConfiguration;
import es.outlook.adriansrj.cv.api.vehicle.configuration.model.VehicleParticleConfiguration;
import es.outlook.adriansrj.cv.api.vehicle.configuration.model.VehicleSeatConfiguration;
import es.outlook.adriansrj.cv.api.vehicle.configuration.model.VehicleSoundConfiguration;
import es.outlook.adriansrj.cv.api.vehicle.configuration.model.compound.post19.Post19CompoundModelConfiguration;
import es.outlook.adriansrj.cv.api.vehicle.configuration.model.compound.pre19.Pre19CompoundModelConfiguration;
import gnu.trove.set.hash.THashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class VehicleModelConfiguration
implements IDeyed,
ConfigurationSectionWritable {
    @NotNull
    protected final String id;
    @NotNull
    protected final VehicleHitBoxConfiguration hitBox;
    @NotNull
    protected final Set<VehicleSeatConfiguration> seats;
    @NotNull
    protected final Set<VehicleParticleConfiguration> particles;
    @NotNull
    protected final Set<VehicleSoundConfiguration> sounds;

    public static VehicleModelConfiguration load(ConfigurationSection section) throws InvalidConfigurationException {
        EnumVehicleModelType modelType = EnumReflection.getEnumConstant(EnumVehicleModelType.class, section.getString("type", ""));
        if (modelType == null) {
            throw new InvalidConfigurationException("unknown model type");
        }
        switch (modelType) {
            case COMPOUND: {
                if (EnumServerVersion.getServerVersion().isSupportsDisplayEntities()) {
                    return new Post19CompoundModelConfiguration(section);
                }
                return new Pre19CompoundModelConfiguration(section);
            }
        }
        throw new IllegalStateException(modelType.name());
    }

    protected VehicleModelConfiguration(@NotNull String id, @NotNull VehicleHitBoxConfiguration hitBox, @NotNull Collection<VehicleSeatConfiguration> seats, @Nullable Collection<VehicleParticleConfiguration> particles, @Nullable Collection<VehicleSoundConfiguration> sounds) {
        Preconditions.checkArgument((seats.size() > 0 ? 1 : 0) != 0, (Object)"at least one seat is required");
        this.id = IDeyed.idCheck(id.toLowerCase());
        this.hitBox = hitBox;
        this.seats = new HashSet<VehicleSeatConfiguration>(seats);
        this.particles = new THashSet();
        this.sounds = new THashSet();
        if (particles != null) {
            this.particles.addAll(particles);
        }
        if (sounds != null) {
            this.sounds.addAll(sounds);
        }
    }

    protected VehicleModelConfiguration(@NotNull ConfigurationSection section) throws InvalidConfigurationException {
        this.id = IDeyed.loadId(section);
        ConfigurationSection hitBoxSection = section.getConfigurationSection("hitbox");
        if (hitBoxSection == null) {
            throw new InvalidConfigurationException("vehicles require a hitbox");
        }
        this.hitBox = VehicleHitBoxConfiguration.load(hitBoxSection);
        this.seats = new HashSet<VehicleSeatConfiguration>();
        for (ConfigurationSection seatSection : ConfigurationUtil.getConfigurationSectionsAfter(section, "seats", false)) {
            this.seats.add(VehicleSeatConfiguration.load(seatSection));
        }
        if (this.seats.size() == 0) {
            throw new InvalidConfigurationException("vehicles require at least one seat");
        }
        this.particles = new THashSet();
        for (ConfigurationSection particleSection : ConfigurationUtil.getConfigurationSectionsAfter(section, "particles", false)) {
            this.particles.add(VehicleParticleConfiguration.load(particleSection));
        }
        this.sounds = new THashSet();
        for (ConfigurationSection soundSection : ConfigurationUtil.getConfigurationSectionsAfter(section, "sounds", false)) {
            this.sounds.add(VehicleSoundConfiguration.load(soundSection));
        }
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public abstract EnumVehicleModelType getType();

    @NotNull
    public Set<VehicleSeatConfiguration> getSeats() {
        return Collections.unmodifiableSet(this.seats);
    }

    @NotNull
    public Set<VehicleParticleConfiguration> getParticles() {
        return Collections.unmodifiableSet(this.particles);
    }

    @NotNull
    public Set<VehicleSoundConfiguration> getSounds() {
        return Collections.unmodifiableSet(this.sounds);
    }

    @Override
    public void write(@NotNull ConfigurationSection section) {
        IDeyed.writeId(this, section);
        section.set("type", (Object)this.getType().name());
        this.hitBox.write(section.createSection("hitbox"));
        ConfigurationUtil.writeConfigurationSectionWritables(section.createSection("seats"), this.seats, "seat-");
        ConfigurationUtil.writeConfigurationSectionWritables(section.createSection("particles"), this.particles, "particle-");
        ConfigurationUtil.writeConfigurationSectionWritables(section.createSection("sounds"), this.sounds, "sound-");
    }

    @NotNull
    public VehicleHitBoxConfiguration getHitBox() {
        return this.hitBox;
    }
}

