/*
 * Decompiled with CFR 0.152.
 */
package es.outlook.adriansrj.cv.api.vehicle.configuration.model;

import com.google.common.base.Preconditions;
import es.outlook.adriansrj.cv.api.interfaces.ConfigurationSectionWritable;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.jetbrains.annotations.NotNull;

public class VehicleHitBoxConfiguration
implements ConfigurationSectionWritable {
    private final double width;
    private final double height;
    private final double depth;

    public static VehicleHitBoxConfiguration load(ConfigurationSection section) throws InvalidConfigurationException {
        double width = section.getDouble("width");
        double height = section.getDouble("height");
        double depth = section.getDouble("depth");
        if (width <= 0.0 || height <= 0.0 || depth <= 0.0) {
            throw new InvalidConfigurationException("hitbox width, height and depth must all be >= 0.5");
        }
        return new VehicleHitBoxConfiguration(width, height, depth);
    }

    public VehicleHitBoxConfiguration(double width, double height, double depth) {
        Preconditions.checkArgument((width > 0.0 ? 1 : 0) != 0, (Object)"width must be >= 0.5");
        Preconditions.checkArgument((height > 0.0 ? 1 : 0) != 0, (Object)"height must be >= 0.5");
        Preconditions.checkArgument((depth > 0.0 ? 1 : 0) != 0, (Object)"depth must be >= 0.5");
        this.width = width;
        this.height = height;
        this.depth = depth;
    }

    @Override
    public void write(@NotNull ConfigurationSection section) {
        section.set("width", (Object)this.width);
        section.set("height", (Object)this.height);
        section.set("depth", (Object)this.depth);
    }

    public static VehicleHitBoxConfigurationBuilder builder() {
        return new VehicleHitBoxConfigurationBuilder();
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }

    public double getDepth() {
        return this.depth;
    }

    public static class VehicleHitBoxConfigurationBuilder {
        private double width;
        private double height;
        private double depth;

        VehicleHitBoxConfigurationBuilder() {
        }

        public VehicleHitBoxConfigurationBuilder width(double width) {
            this.width = width;
            return this;
        }

        public VehicleHitBoxConfigurationBuilder height(double height) {
            this.height = height;
            return this;
        }

        public VehicleHitBoxConfigurationBuilder depth(double depth) {
            this.depth = depth;
            return this;
        }

        public VehicleHitBoxConfiguration build() {
            return new VehicleHitBoxConfiguration(this.width, this.height, this.depth);
        }

        public String toString() {
            return "VehicleHitBoxConfiguration.VehicleHitBoxConfigurationBuilder(width=" + this.width + ", height=" + this.height + ", depth=" + this.depth + ")";
        }
    }
}

