/*
 * Decompiled with CFR 0.152.
 */
package es.outlook.adriansrj.cv.api.vehicle.configuration.data;

import es.outlook.adriansrj.cv.api.vehicle.configuration.data.DataParser;
import org.bukkit.Color;
import org.bukkit.Particle;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.jetbrains.annotations.NotNull;

public class DustOptionsParser
extends DataParser {
    @Override
    @NotNull
    public String getIdentifier() {
        return "dust-options";
    }

    @Override
    @NotNull
    public Class<?> getType() {
        return Particle.DustOptions.class;
    }

    @Override
    public Object parse(@NotNull ConfigurationSection section) throws InvalidConfigurationException {
        int red = this.checkColorComponent(section.getInt("red"), "red");
        int green = this.checkColorComponent(section.getInt("green"), "green");
        int blue = this.checkColorComponent(section.getInt("blue"), "blue");
        float size = (float)section.getDouble("size");
        return new Particle.DustOptions(Color.fromRGB((int)red, (int)green, (int)blue), size);
    }

    private int checkColorComponent(int component, String name) throws InvalidConfigurationException {
        if (component < 0 || component > 255) {
            throw new InvalidConfigurationException("invalid dust color " + name + " component. must be between 0 and 255");
        }
        return component;
    }

    @Override
    public void write(@NotNull Object value, @NotNull ConfigurationSection section) {
        super.write(value, section);
        if (value instanceof Particle.DustOptions) {
            Particle.DustOptions options = (Particle.DustOptions)value;
            Color color = options.getColor();
            section.set("red", (Object)color.getRed());
            section.set("green", (Object)color.getGreen());
            section.set("blue", (Object)color.getBlue());
            section.set("size", (Object)Float.valueOf(options.getSize()));
        }
    }
}

