/*
 * Decompiled with CFR 0.152.
 */
package es.outlook.adriansrj.cv.api.vehicle.configuration.data;

import es.outlook.adriansrj.cv.api.vehicle.configuration.data.BannerStyleParser;
import es.outlook.adriansrj.cv.api.vehicle.configuration.data.BlockDataParser;
import es.outlook.adriansrj.cv.api.vehicle.configuration.data.DataParser;
import es.outlook.adriansrj.cv.api.vehicle.configuration.data.DustOptionsParser;
import es.outlook.adriansrj.cv.api.vehicle.configuration.data.HeadTextureParser;
import es.outlook.adriansrj.cv.api.vehicle.configuration.data.ItemStackParser;
import es.outlook.adriansrj.cv.api.vehicle.configuration.data.MaterialParser;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.configuration.ConfigurationSection;
import org.jetbrains.annotations.NotNull;

public final class DataParsers {
    private static final Map<String, DataParser> BY_IDENTIFIER = new HashMap<String, DataParser>();
    private static final Map<Class<?>, DataParser> BY_TYPE = new HashMap();

    public static DataParser getParser(@NotNull String identifier) {
        return BY_IDENTIFIER.get(identifier.trim().toLowerCase());
    }

    public static DataParser getParser(@NotNull Class<?> type) {
        for (Map.Entry<Class<?>, DataParser> entry : BY_TYPE.entrySet()) {
            if (!entry.getKey().isAssignableFrom(type)) continue;
            return entry.getValue();
        }
        return null;
    }

    public static DataParser matchParser(@NotNull ConfigurationSection section) {
        return DataParser.getParser(section);
    }

    public static void register(@NotNull DataParser parser) {
        BY_IDENTIFIER.put(parser.getIdentifier().toLowerCase().trim(), parser);
        BY_TYPE.put(parser.getType(), parser);
    }

    static {
        DataParsers.register(new MaterialParser());
        DataParsers.register(new ItemStackParser());
        DataParsers.register(new BlockDataParser());
        DataParsers.register(new DustOptionsParser());
        DataParsers.register(new HeadTextureParser());
        DataParsers.register(new BannerStyleParser());
    }
}

