/*
 * Decompiled with CFR 0.152.
 */
package es.outlook.adriansrj.cv.api.vehicle.configuration.data;

import es.outlook.adriansrj.cv.api.util.reflection.EnumReflection;
import es.outlook.adriansrj.cv.api.vehicle.configuration.data.DataParser;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.data.BlockData;
import org.bukkit.configuration.ConfigurationSection;
import org.jetbrains.annotations.NotNull;

public class BlockDataParser
extends DataParser {
    @Override
    @NotNull
    public String getIdentifier() {
        return "block-data";
    }

    @Override
    @NotNull
    public Class<?> getType() {
        return BlockData.class;
    }

    public BlockData parse(@NotNull ConfigurationSection section) {
        String value = section.getString("value", "");
        try {
            return Bukkit.createBlockData((String)value);
        }
        catch (IllegalArgumentException ex) {
            Material material = EnumReflection.getEnumConstant(Material.class, value.trim().toUpperCase());
            return material != null ? material.createBlockData() : null;
        }
    }

    @Override
    public void write(@NotNull Object value, @NotNull ConfigurationSection section) {
        super.write(value, section);
        if (value instanceof BlockData) {
            section.set("value", (Object)((BlockData)value).getAsString(true));
        }
    }
}

