/*
 * Decompiled with CFR 0.152.
 */
package es.outlook.adriansrj.cv.api.vehicle.configuration.data;

import es.outlook.adriansrj.cv.api.vehicle.configuration.data.BannerStyle;
import es.outlook.adriansrj.cv.api.vehicle.configuration.data.DataParser;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.block.banner.Pattern;
import org.bukkit.configuration.ConfigurationSection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BannerStyleParser
extends DataParser {
    @Override
    @NotNull
    public String getIdentifier() {
        return "banner-style";
    }

    @Override
    @NotNull
    public Class<?> getType() {
        return BannerStyle.class;
    }

    @Override
    @Nullable
    public BannerStyle parse(@NotNull ConfigurationSection section) {
        ArrayList<Pattern> patterns = new ArrayList<Pattern>();
        for (String key : section.getKeys(false)) {
            Pattern pattern = (Pattern)section.getSerializable(key, Pattern.class);
            if (pattern == null) continue;
            patterns.add(pattern);
        }
        return new BannerStyle(patterns);
    }

    @Override
    public void write(@NotNull Object value, @NotNull ConfigurationSection section) {
        super.write(value, section);
        if (value instanceof BannerStyle) {
            BannerStyle bannerStyle = (BannerStyle)value;
            List<Pattern> patterns = bannerStyle.getPatterns();
            for (int i = 0; i < patterns.size(); ++i) {
                section.set("pattern-" + i, (Object)patterns.get(i));
            }
        }
    }
}

