/*
 * Decompiled with CFR 0.152.
 */
package es.outlook.adriansrj.cv.api.vehicle.configuration;

import com.google.common.base.Preconditions;
import es.outlook.adriansrj.cv.api.interfaces.ConfigurationSectionWritable;
import es.outlook.adriansrj.cv.api.util.Constants;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.jetbrains.annotations.NotNull;

public class VehiclePhysicsConfiguration
implements ConfigurationSectionWritable {
    public static final VehiclePhysicsConfiguration DEFAULTS = new VehiclePhysicsConfiguration(false, 3.8, 0.15, 0.015, 0.2, 0.2, 0.6, 0.555, 0.5, 0.2, 0.3, 0.5, 0.9, 1);
    private final boolean floats;
    private final double gravityMaximum;
    private final double gravityAcceleration;
    private final double airFriction;
    private final double frictionOnUnknown;
    private final double frictionOnSolid;
    private final double frictionOnDusty;
    private final double frictionOnSnowy;
    private final double frictionOnSlippery;
    private final double frictionOnWater;
    private final double frictionOnLava;
    private final double frictionThroughWater;
    private final double frictionThroughLava;
    private final int blockClimbCapacity;

    public static VehiclePhysicsConfiguration load(ConfigurationSection section) throws InvalidConfigurationException {
        boolean floats = section.getBoolean("floats");
        double gravityMaximum = VehiclePhysicsConfiguration.checkGravityValue(section.getDouble(Constants.Key.GRAVITY_MAXIMUM), "gravity maximum");
        double gravityAcceleration = VehiclePhysicsConfiguration.checkGravityValue(section.getDouble(Constants.Key.GRAVITY_ACCELERATION), "gravity acceleration");
        double airFriction = VehiclePhysicsConfiguration.checkFrictionValue(section.getDouble(Constants.Key.FRICTION_AIR) / 100.0, "air friction");
        double frictionOnUnknown = VehiclePhysicsConfiguration.checkFrictionValue(section.getDouble(Constants.Key.FRICTION_ON_UNKNOWN) / 100.0, "friction on unknown");
        double frictionOnSolid = VehiclePhysicsConfiguration.checkFrictionValue(section.getDouble(Constants.Key.FRICTION_ON_SOLID) / 100.0, "friction on solid");
        double frictionOnDusty = VehiclePhysicsConfiguration.checkFrictionValue(section.getDouble(Constants.Key.FRICTION_ON_DUSTY) / 100.0, "friction on dusty");
        double frictionOnSnowy = VehiclePhysicsConfiguration.checkFrictionValue(section.getDouble(Constants.Key.FRICTION_ON_SNOWY) / 100.0, "friction on snowy");
        double frictionOnSlippery = VehiclePhysicsConfiguration.checkFrictionValue(section.getDouble(Constants.Key.FRICTION_ON_SLIPPERY) / 100.0, "friction on slippery");
        double frictionOnWater = VehiclePhysicsConfiguration.checkFrictionValue(section.getDouble(Constants.Key.FRICTION_ON_WATER) / 100.0, "friction on water");
        double frictionOnLava = VehiclePhysicsConfiguration.checkFrictionValue(section.getDouble(Constants.Key.FRICTION_ON_LAVA) / 100.0, "friction on lava");
        double frictionThroughWater = VehiclePhysicsConfiguration.checkFrictionValue(section.getDouble(Constants.Key.FRICTION_THROUGH_WATER) / 100.0, "friction through water");
        double frictionThroughLava = VehiclePhysicsConfiguration.checkFrictionValue(section.getDouble(Constants.Key.FRICTION_THROUGH_LAVA) / 100.0, "friction through lava");
        int blockClimbCapacity = section.getInt(Constants.Key.BLOCK_CLIMB_CAPACITY);
        return new VehiclePhysicsConfiguration(floats, gravityMaximum, gravityAcceleration, airFriction, frictionOnUnknown, frictionOnSolid, frictionOnDusty, frictionOnSnowy, frictionOnSlippery, frictionOnWater, frictionOnLava, frictionThroughWater, frictionThroughLava, blockClimbCapacity);
    }

    private static double checkValue(double value, String name) throws InvalidConfigurationException {
        if (value > 0.0) {
            return value;
        }
        throw new InvalidConfigurationException(name + " must be > 0");
    }

    private static double checkGravityValue(double value, String name) throws InvalidConfigurationException {
        if (value >= 0.0) {
            return value;
        }
        throw new InvalidConfigurationException(name + " cannot be negative");
    }

    private static double checkFrictionValue(double value, String name) throws InvalidConfigurationException {
        if (value > 0.0 && value <= 1.0) {
            return value;
        }
        throw new InvalidConfigurationException(name + " must be > 0 and less or equal to 1.0");
    }

    public VehiclePhysicsConfiguration(boolean floats, double gravityMaximum, double gravityAcceleration, double airFriction, double frictionOnUnknown, double frictionOnSolid, double frictionOnDusty, double frictionOnSnowy, double frictionOnSlippery, double frictionOnWater, double frictionOnLava, double frictionThroughWater, double frictionThroughLava, int blockClimbCapacity) {
        Preconditions.checkArgument((gravityMaximum >= 0.0 ? 1 : 0) != 0, (Object)"gravityMaximum cannot be negative");
        Preconditions.checkArgument((gravityAcceleration >= 0.0 ? 1 : 0) != 0, (Object)"gravityAcceleration cannot be negative");
        Preconditions.checkArgument((airFriction > 0.0 ? 1 : 0) != 0, (Object)"airFriction must be > 0");
        Preconditions.checkArgument((frictionOnUnknown > 0.0 ? 1 : 0) != 0, (Object)"frictionOnUnknown must be > 0");
        Preconditions.checkArgument((frictionOnSolid > 0.0 ? 1 : 0) != 0, (Object)"frictionOnSolid must be > 0");
        Preconditions.checkArgument((frictionOnDusty > 0.0 ? 1 : 0) != 0, (Object)"frictionOnDusty must be > 0");
        Preconditions.checkArgument((frictionOnSnowy > 0.0 ? 1 : 0) != 0, (Object)"frictionOnSnowy must be > 0");
        Preconditions.checkArgument((frictionOnSlippery > 0.0 ? 1 : 0) != 0, (Object)"frictionOnSlippery must be > 0");
        Preconditions.checkArgument((frictionOnWater > 0.0 ? 1 : 0) != 0, (Object)"frictionOnWater must be > 0");
        Preconditions.checkArgument((frictionOnLava > 0.0 ? 1 : 0) != 0, (Object)"frictionOnLava must be > 0");
        Preconditions.checkArgument((frictionThroughWater > 0.0 ? 1 : 0) != 0, (Object)"frictionThroughWater must be > 0");
        Preconditions.checkArgument((frictionThroughLava > 0.0 ? 1 : 0) != 0, (Object)"frictionThroughLava must be > 0");
        this.floats = floats;
        this.gravityMaximum = gravityMaximum;
        this.gravityAcceleration = gravityAcceleration;
        this.airFriction = airFriction;
        this.frictionOnUnknown = frictionOnUnknown;
        this.frictionOnSolid = frictionOnSolid;
        this.frictionOnDusty = frictionOnDusty;
        this.frictionOnSnowy = frictionOnSnowy;
        this.frictionOnSlippery = frictionOnSlippery;
        this.frictionOnWater = frictionOnWater;
        this.frictionOnLava = frictionOnLava;
        this.frictionThroughWater = frictionThroughWater;
        this.frictionThroughLava = frictionThroughLava;
        this.blockClimbCapacity = blockClimbCapacity;
    }

    @Override
    public void write(@NotNull ConfigurationSection section) {
        section.set("floats", (Object)this.floats);
        section.set(Constants.Key.GRAVITY_MAXIMUM, (Object)this.gravityMaximum);
        section.set(Constants.Key.GRAVITY_ACCELERATION, (Object)this.gravityAcceleration);
        section.set(Constants.Key.FRICTION_AIR, (Object)(this.airFriction * 100.0));
        section.set(Constants.Key.FRICTION_ON_UNKNOWN, (Object)(this.frictionOnUnknown * 100.0));
        section.set(Constants.Key.FRICTION_ON_SOLID, (Object)(this.frictionOnSolid * 100.0));
        section.set(Constants.Key.FRICTION_ON_DUSTY, (Object)(this.frictionOnDusty * 100.0));
        section.set(Constants.Key.FRICTION_ON_SNOWY, (Object)(this.frictionOnSnowy * 100.0));
        section.set(Constants.Key.FRICTION_ON_SLIPPERY, (Object)(this.frictionOnSlippery * 100.0));
        section.set(Constants.Key.FRICTION_ON_WATER, (Object)(this.frictionOnWater * 100.0));
        section.set(Constants.Key.FRICTION_ON_LAVA, (Object)(this.frictionOnLava * 100.0));
        section.set(Constants.Key.FRICTION_THROUGH_WATER, (Object)(this.frictionThroughWater * 100.0));
        section.set(Constants.Key.FRICTION_THROUGH_LAVA, (Object)(this.frictionThroughLava * 100.0));
        section.set(Constants.Key.BLOCK_CLIMB_CAPACITY, (Object)this.blockClimbCapacity);
    }

    public static VehiclePhysicsConfigurationBuilder builder() {
        return new VehiclePhysicsConfigurationBuilder();
    }

    public boolean isFloats() {
        return this.floats;
    }

    public double getGravityMaximum() {
        return this.gravityMaximum;
    }

    public double getGravityAcceleration() {
        return this.gravityAcceleration;
    }

    public double getAirFriction() {
        return this.airFriction;
    }

    public double getFrictionOnUnknown() {
        return this.frictionOnUnknown;
    }

    public double getFrictionOnSolid() {
        return this.frictionOnSolid;
    }

    public double getFrictionOnDusty() {
        return this.frictionOnDusty;
    }

    public double getFrictionOnSnowy() {
        return this.frictionOnSnowy;
    }

    public double getFrictionOnSlippery() {
        return this.frictionOnSlippery;
    }

    public double getFrictionOnWater() {
        return this.frictionOnWater;
    }

    public double getFrictionOnLava() {
        return this.frictionOnLava;
    }

    public double getFrictionThroughWater() {
        return this.frictionThroughWater;
    }

    public double getFrictionThroughLava() {
        return this.frictionThroughLava;
    }

    public int getBlockClimbCapacity() {
        return this.blockClimbCapacity;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VehiclePhysicsConfiguration)) {
            return false;
        }
        VehiclePhysicsConfiguration other = (VehiclePhysicsConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isFloats() != other.isFloats()) {
            return false;
        }
        if (Double.compare(this.getGravityMaximum(), other.getGravityMaximum()) != 0) {
            return false;
        }
        if (Double.compare(this.getGravityAcceleration(), other.getGravityAcceleration()) != 0) {
            return false;
        }
        if (Double.compare(this.getAirFriction(), other.getAirFriction()) != 0) {
            return false;
        }
        if (Double.compare(this.getFrictionOnUnknown(), other.getFrictionOnUnknown()) != 0) {
            return false;
        }
        if (Double.compare(this.getFrictionOnSolid(), other.getFrictionOnSolid()) != 0) {
            return false;
        }
        if (Double.compare(this.getFrictionOnDusty(), other.getFrictionOnDusty()) != 0) {
            return false;
        }
        if (Double.compare(this.getFrictionOnSnowy(), other.getFrictionOnSnowy()) != 0) {
            return false;
        }
        if (Double.compare(this.getFrictionOnSlippery(), other.getFrictionOnSlippery()) != 0) {
            return false;
        }
        if (Double.compare(this.getFrictionOnWater(), other.getFrictionOnWater()) != 0) {
            return false;
        }
        if (Double.compare(this.getFrictionOnLava(), other.getFrictionOnLava()) != 0) {
            return false;
        }
        if (Double.compare(this.getFrictionThroughWater(), other.getFrictionThroughWater()) != 0) {
            return false;
        }
        if (Double.compare(this.getFrictionThroughLava(), other.getFrictionThroughLava()) != 0) {
            return false;
        }
        return this.getBlockClimbCapacity() == other.getBlockClimbCapacity();
    }

    protected boolean canEqual(Object other) {
        return other instanceof VehiclePhysicsConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isFloats() ? 79 : 97);
        long $gravityMaximum = Double.doubleToLongBits(this.getGravityMaximum());
        result = result * 59 + (int)($gravityMaximum >>> 32 ^ $gravityMaximum);
        long $gravityAcceleration = Double.doubleToLongBits(this.getGravityAcceleration());
        result = result * 59 + (int)($gravityAcceleration >>> 32 ^ $gravityAcceleration);
        long $airFriction = Double.doubleToLongBits(this.getAirFriction());
        result = result * 59 + (int)($airFriction >>> 32 ^ $airFriction);
        long $frictionOnUnknown = Double.doubleToLongBits(this.getFrictionOnUnknown());
        result = result * 59 + (int)($frictionOnUnknown >>> 32 ^ $frictionOnUnknown);
        long $frictionOnSolid = Double.doubleToLongBits(this.getFrictionOnSolid());
        result = result * 59 + (int)($frictionOnSolid >>> 32 ^ $frictionOnSolid);
        long $frictionOnDusty = Double.doubleToLongBits(this.getFrictionOnDusty());
        result = result * 59 + (int)($frictionOnDusty >>> 32 ^ $frictionOnDusty);
        long $frictionOnSnowy = Double.doubleToLongBits(this.getFrictionOnSnowy());
        result = result * 59 + (int)($frictionOnSnowy >>> 32 ^ $frictionOnSnowy);
        long $frictionOnSlippery = Double.doubleToLongBits(this.getFrictionOnSlippery());
        result = result * 59 + (int)($frictionOnSlippery >>> 32 ^ $frictionOnSlippery);
        long $frictionOnWater = Double.doubleToLongBits(this.getFrictionOnWater());
        result = result * 59 + (int)($frictionOnWater >>> 32 ^ $frictionOnWater);
        long $frictionOnLava = Double.doubleToLongBits(this.getFrictionOnLava());
        result = result * 59 + (int)($frictionOnLava >>> 32 ^ $frictionOnLava);
        long $frictionThroughWater = Double.doubleToLongBits(this.getFrictionThroughWater());
        result = result * 59 + (int)($frictionThroughWater >>> 32 ^ $frictionThroughWater);
        long $frictionThroughLava = Double.doubleToLongBits(this.getFrictionThroughLava());
        result = result * 59 + (int)($frictionThroughLava >>> 32 ^ $frictionThroughLava);
        result = result * 59 + this.getBlockClimbCapacity();
        return result;
    }

    public static class VehiclePhysicsConfigurationBuilder {
        private boolean floats;
        private double gravityMaximum;
        private double gravityAcceleration;
        private double airFriction;
        private double frictionOnUnknown;
        private double frictionOnSolid;
        private double frictionOnDusty;
        private double frictionOnSnowy;
        private double frictionOnSlippery;
        private double frictionOnWater;
        private double frictionOnLava;
        private double frictionThroughWater;
        private double frictionThroughLava;
        private int blockClimbCapacity;

        VehiclePhysicsConfigurationBuilder() {
        }

        public VehiclePhysicsConfigurationBuilder floats(boolean floats) {
            this.floats = floats;
            return this;
        }

        public VehiclePhysicsConfigurationBuilder gravityMaximum(double gravityMaximum) {
            this.gravityMaximum = gravityMaximum;
            return this;
        }

        public VehiclePhysicsConfigurationBuilder gravityAcceleration(double gravityAcceleration) {
            this.gravityAcceleration = gravityAcceleration;
            return this;
        }

        public VehiclePhysicsConfigurationBuilder airFriction(double airFriction) {
            this.airFriction = airFriction;
            return this;
        }

        public VehiclePhysicsConfigurationBuilder frictionOnUnknown(double frictionOnUnknown) {
            this.frictionOnUnknown = frictionOnUnknown;
            return this;
        }

        public VehiclePhysicsConfigurationBuilder frictionOnSolid(double frictionOnSolid) {
            this.frictionOnSolid = frictionOnSolid;
            return this;
        }

        public VehiclePhysicsConfigurationBuilder frictionOnDusty(double frictionOnDusty) {
            this.frictionOnDusty = frictionOnDusty;
            return this;
        }

        public VehiclePhysicsConfigurationBuilder frictionOnSnowy(double frictionOnSnowy) {
            this.frictionOnSnowy = frictionOnSnowy;
            return this;
        }

        public VehiclePhysicsConfigurationBuilder frictionOnSlippery(double frictionOnSlippery) {
            this.frictionOnSlippery = frictionOnSlippery;
            return this;
        }

        public VehiclePhysicsConfigurationBuilder frictionOnWater(double frictionOnWater) {
            this.frictionOnWater = frictionOnWater;
            return this;
        }

        public VehiclePhysicsConfigurationBuilder frictionOnLava(double frictionOnLava) {
            this.frictionOnLava = frictionOnLava;
            return this;
        }

        public VehiclePhysicsConfigurationBuilder frictionThroughWater(double frictionThroughWater) {
            this.frictionThroughWater = frictionThroughWater;
            return this;
        }

        public VehiclePhysicsConfigurationBuilder frictionThroughLava(double frictionThroughLava) {
            this.frictionThroughLava = frictionThroughLava;
            return this;
        }

        public VehiclePhysicsConfigurationBuilder blockClimbCapacity(int blockClimbCapacity) {
            this.blockClimbCapacity = blockClimbCapacity;
            return this;
        }

        public VehiclePhysicsConfiguration build() {
            return new VehiclePhysicsConfiguration(this.floats, this.gravityMaximum, this.gravityAcceleration, this.airFriction, this.frictionOnUnknown, this.frictionOnSolid, this.frictionOnDusty, this.frictionOnSnowy, this.frictionOnSlippery, this.frictionOnWater, this.frictionOnLava, this.frictionThroughWater, this.frictionThroughLava, this.blockClimbCapacity);
        }

        public String toString() {
            return "VehiclePhysicsConfiguration.VehiclePhysicsConfigurationBuilder(floats=" + this.floats + ", gravityMaximum=" + this.gravityMaximum + ", gravityAcceleration=" + this.gravityAcceleration + ", airFriction=" + this.airFriction + ", frictionOnUnknown=" + this.frictionOnUnknown + ", frictionOnSolid=" + this.frictionOnSolid + ", frictionOnDusty=" + this.frictionOnDusty + ", frictionOnSnowy=" + this.frictionOnSnowy + ", frictionOnSlippery=" + this.frictionOnSlippery + ", frictionOnWater=" + this.frictionOnWater + ", frictionOnLava=" + this.frictionOnLava + ", frictionThroughWater=" + this.frictionThroughWater + ", frictionThroughLava=" + this.frictionThroughLava + ", blockClimbCapacity=" + this.blockClimbCapacity + ")";
        }
    }
}

