/*
 * Decompiled with CFR 0.152.
 */
package es.outlook.adriansrj.cv.api.vehicle.configuration;

import com.google.common.base.Preconditions;
import es.outlook.adriansrj.cv.api.interfaces.ConfigurationSectionWritable;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.jetbrains.annotations.NotNull;

public class VehicleFuelConfiguration
implements ConfigurationSectionWritable {
    public static final VehicleFuelConfiguration DEFAULTS = new VehicleFuelConfiguration(80.0f, 0.02f, 0.05f);
    private final float capacity;
    private final float minConsumption;
    private final float maxConsumption;

    public static VehicleFuelConfiguration load(ConfigurationSection section) throws InvalidConfigurationException {
        float capacity = VehicleFuelConfiguration.checkValue((float)section.getDouble("capacity"), "capacity");
        float minConsumption = VehicleFuelConfiguration.checkValue((float)section.getDouble("min-consumption"), "minimum consumption");
        float maxConsumption = VehicleFuelConfiguration.checkValue((float)section.getDouble("max-consumption"), "maximum consumption");
        return new VehicleFuelConfiguration(capacity, minConsumption, maxConsumption);
    }

    private static float checkValue(float value, String name) throws InvalidConfigurationException {
        if (value >= 0.0f) {
            return value;
        }
        throw new InvalidConfigurationException(name + " cannot be negative");
    }

    public VehicleFuelConfiguration(float capacity, float minConsumption, float maxConsumption) {
        Preconditions.checkArgument((capacity >= 0.0f ? 1 : 0) != 0, (Object)"capacity cannot be negative");
        Preconditions.checkArgument((minConsumption >= 0.0f ? 1 : 0) != 0, (Object)"minimum consumption cannot be negative");
        Preconditions.checkArgument((maxConsumption >= 0.0f ? 1 : 0) != 0, (Object)"maximum consumption cannot be negative");
        this.capacity = capacity;
        this.minConsumption = minConsumption;
        this.maxConsumption = maxConsumption;
    }

    @Override
    public void write(@NotNull ConfigurationSection section) {
        section.set("capacity", (Object)Float.valueOf(this.capacity));
        section.set("min-consumption", (Object)Float.valueOf(this.minConsumption));
        section.set("max-consumption", (Object)Float.valueOf(this.maxConsumption));
    }

    public float getCapacity() {
        return this.capacity;
    }

    public float getMinConsumption() {
        return this.minConsumption;
    }

    public float getMaxConsumption() {
        return this.maxConsumption;
    }
}

