/*
 * Decompiled with CFR 0.152.
 */
package es.outlook.adriansrj.cv.api.vehicle.configuration;

import es.outlook.adriansrj.cv.api.interfaces.ConfigurationSectionWritable;
import es.outlook.adriansrj.cv.api.interfaces.IDeyed;
import es.outlook.adriansrj.cv.api.util.ConfigurationUtil;
import es.outlook.adriansrj.cv.api.vehicle.controller.VehicleControllerProperties;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VehicleControllersConfiguration
implements ConfigurationSectionWritable {
    public static final VehicleControllersConfiguration EMPTY = new VehicleControllersConfiguration(null);
    @NotNull
    private final Map<String, VehicleControllerProperties> entries = new LinkedHashMap<String, VehicleControllerProperties>();

    public static VehicleControllersConfiguration load(ConfigurationSection root) throws InvalidConfigurationException {
        LinkedHashMap<String, VehicleControllerProperties> entries = new LinkedHashMap<String, VehicleControllerProperties>();
        for (ConfigurationSection section : ConfigurationUtil.getConfigurationSections(root, false)) {
            String controllerId = IDeyed.loadId(section);
            VehicleControllerProperties properties = new VehicleControllerProperties();
            ConfigurationSection propertiesSection = section.getConfigurationSection("properties");
            if (propertiesSection != null) {
                properties = VehicleControllerProperties.load(propertiesSection);
            }
            entries.put(controllerId, properties);
        }
        return new VehicleControllersConfiguration(entries);
    }

    public VehicleControllersConfiguration(@Nullable Map<String, VehicleControllerProperties> entries) {
        if (entries != null) {
            for (Map.Entry<String, VehicleControllerProperties> entry : entries.entrySet()) {
                this.entries.put(IDeyed.idCheck(entry.getKey()), entry.getValue());
            }
        }
    }

    @NotNull
    public Map<String, VehicleControllerProperties> getEntries() {
        return Collections.unmodifiableMap(this.entries);
    }

    @Override
    public void write(@NotNull ConfigurationSection root) {
        int count = 0;
        for (Map.Entry<String, VehicleControllerProperties> entry : this.entries.entrySet()) {
            String controllerId = entry.getKey();
            VehicleControllerProperties properties = entry.getValue();
            ConfigurationSection section = root.createSection("controller-" + count++);
            IDeyed.writeId(controllerId, section);
            properties.write(section.createSection("properties"));
        }
    }

    public static VehicleControllersConfigurationBuilder builder() {
        return new VehicleControllersConfigurationBuilder();
    }

    public static class VehicleControllersConfigurationBuilder {
        private ArrayList<String> entries$key;
        private ArrayList<VehicleControllerProperties> entries$value;

        VehicleControllersConfigurationBuilder() {
        }

        public VehicleControllersConfigurationBuilder entry(String entryKey, VehicleControllerProperties entryValue) {
            if (this.entries$key == null) {
                this.entries$key = new ArrayList();
                this.entries$value = new ArrayList();
            }
            this.entries$key.add(entryKey);
            this.entries$value.add(entryValue);
            return this;
        }

        public VehicleControllersConfigurationBuilder entries(Map<? extends String, ? extends VehicleControllerProperties> entries) {
            if (entries == null) {
                throw new NullPointerException("entries cannot be null");
            }
            if (this.entries$key == null) {
                this.entries$key = new ArrayList();
                this.entries$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends VehicleControllerProperties> $lombokEntry : entries.entrySet()) {
                this.entries$key.add($lombokEntry.getKey());
                this.entries$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public VehicleControllersConfigurationBuilder clearEntries() {
            if (this.entries$key != null) {
                this.entries$key.clear();
                this.entries$value.clear();
            }
            return this;
        }

        public VehicleControllersConfiguration build() {
            Map<String, VehicleControllerProperties> entries;
            switch (this.entries$key == null ? 0 : this.entries$key.size()) {
                case 0: {
                    entries = Collections.emptyMap();
                    break;
                }
                case 1: {
                    entries = Collections.singletonMap(this.entries$key.get(0), this.entries$value.get(0));
                    break;
                }
                default: {
                    entries = new LinkedHashMap<String, VehicleControllerProperties>(this.entries$key.size() < 0x40000000 ? 1 + this.entries$key.size() + (this.entries$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.entries$key.size(); ++$i) {
                        entries.put(this.entries$key.get($i), this.entries$value.get($i));
                    }
                    entries = Collections.unmodifiableMap(entries);
                }
            }
            return new VehicleControllersConfiguration(entries);
        }

        public String toString() {
            return "VehicleControllersConfiguration.VehicleControllersConfigurationBuilder(entries$key=" + this.entries$key + ", entries$value=" + this.entries$value + ")";
        }
    }
}

