/*
 * Decompiled with CFR 0.152.
 */
package es.outlook.adriansrj.cv.api.vehicle.configuration;

import es.outlook.adriansrj.cv.api.enums.EnumExitShortcut;
import es.outlook.adriansrj.cv.api.interfaces.ConfigurationSectionWritable;
import es.outlook.adriansrj.cv.api.interfaces.IDeyed;
import es.outlook.adriansrj.cv.api.interfaces.Named;
import es.outlook.adriansrj.cv.api.item.ItemConfiguration;
import es.outlook.adriansrj.cv.api.registry.Registries;
import es.outlook.adriansrj.cv.api.util.ConfigurationUtil;
import es.outlook.adriansrj.cv.api.util.Constants;
import es.outlook.adriansrj.cv.api.vehicle.configuration.VehicleControllersConfiguration;
import es.outlook.adriansrj.cv.api.vehicle.configuration.VehicleFuelConfiguration;
import es.outlook.adriansrj.cv.api.vehicle.configuration.VehiclePhysicsConfiguration;
import es.outlook.adriansrj.cv.api.vehicle.configuration.model.VehicleModelConfiguration;
import org.apache.commons.lang.StringUtils;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VehicleConfiguration
implements IDeyed,
Named,
ConfigurationSectionWritable {
    @NotNull
    private final String id;
    @NotNull
    private final String name;
    @NotNull
    private final EnumExitShortcut operatorExitShortcut;
    @NotNull
    private final EnumExitShortcut passengerExitShortcut;
    @NotNull
    private final VehicleModelConfiguration model;
    @Nullable
    private final ItemConfiguration pickupItem;
    @NotNull
    private final VehiclePhysicsConfiguration physics;
    @NotNull
    private final VehicleFuelConfiguration fuel;
    @NotNull
    private final VehicleControllersConfiguration controllers;

    public static VehicleConfiguration load(@NotNull ConfigurationSection section) throws InvalidConfigurationException {
        String modelId;
        String id = IDeyed.loadId(section);
        String name = Named.loadName(section, id);
        EnumExitShortcut operatorExitShortcut = ConfigurationUtil.loadEnum(EnumExitShortcut.class, section, Constants.Key.OPERATOR_EXIT_SHORTCUT);
        EnumExitShortcut passengerExitShortcut = ConfigurationUtil.loadEnum(EnumExitShortcut.class, section, Constants.Key.PASSENGER_EXIT_SHORTCUT);
        if (operatorExitShortcut == null) {
            throw new InvalidConfigurationException("invalid exit shortcut");
        }
        if (passengerExitShortcut == null) {
            passengerExitShortcut = operatorExitShortcut;
        }
        if (StringUtils.isBlank((String)(modelId = section.getString("model")))) {
            throw new InvalidConfigurationException("invalid model id");
        }
        VehicleModelConfiguration model = (VehicleModelConfiguration)Registries.getRegistry(VehicleModelConfiguration.class).get(IDeyed.idCheck(modelId.toLowerCase()));
        if (model == null) {
            throw new InvalidConfigurationException("the model '" + modelId + "' is unknown");
        }
        String pickupItemId = section.getString("pickup-item");
        ItemConfiguration pickupItem = pickupItemId != null ? (ItemConfiguration)Registries.getRegistry(ItemConfiguration.class).get(pickupItemId) : null;
        ConfigurationSection physicsSection = section.getConfigurationSection("physics");
        VehiclePhysicsConfiguration physics = physicsSection != null ? VehiclePhysicsConfiguration.load(physicsSection) : VehiclePhysicsConfiguration.DEFAULTS;
        ConfigurationSection fuelSection = section.getConfigurationSection("fuel");
        VehicleFuelConfiguration fuel = fuelSection != null ? VehicleFuelConfiguration.load(fuelSection) : VehicleFuelConfiguration.DEFAULTS;
        ConfigurationSection controllersSection = section.getConfigurationSection("controllers");
        VehicleControllersConfiguration controllers = controllersSection != null ? VehicleControllersConfiguration.load(controllersSection) : VehicleControllersConfiguration.EMPTY;
        return new VehicleConfiguration(id, name, operatorExitShortcut, passengerExitShortcut, model, pickupItem, physics, fuel, controllers);
    }

    public VehicleConfiguration(@NotNull String id, @NotNull String name, @NotNull EnumExitShortcut operatorExitShortcut, @NotNull EnumExitShortcut passengerExitShortcut, @NotNull VehicleModelConfiguration model, @Nullable ItemConfiguration pickupItem, @Nullable VehiclePhysicsConfiguration physics, @Nullable VehicleFuelConfiguration fuel, @Nullable VehicleControllersConfiguration controllers) {
        this.id = IDeyed.idCheck(id.toLowerCase());
        this.name = Named.nameCheck(name);
        this.operatorExitShortcut = operatorExitShortcut;
        this.passengerExitShortcut = passengerExitShortcut;
        this.model = model;
        this.pickupItem = pickupItem;
        this.physics = physics != null ? physics : VehiclePhysicsConfiguration.DEFAULTS;
        this.fuel = fuel != null ? fuel : VehicleFuelConfiguration.DEFAULTS;
        this.controllers = controllers != null ? controllers : VehicleControllersConfiguration.EMPTY;
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public EnumExitShortcut getOperatorExitShortcut() {
        return this.operatorExitShortcut;
    }

    @NotNull
    public EnumExitShortcut getPassengerExitShortcut() {
        return this.passengerExitShortcut;
    }

    @NotNull
    public VehicleModelConfiguration getModel() {
        return this.model;
    }

    @Nullable
    public ItemConfiguration getPickupItem() {
        return this.pickupItem;
    }

    @NotNull
    public VehiclePhysicsConfiguration getPhysics() {
        return this.physics;
    }

    @NotNull
    public VehicleFuelConfiguration getFuel() {
        return this.fuel;
    }

    @NotNull
    public VehicleControllersConfiguration getControllers() {
        return this.controllers;
    }

    @Override
    public void write(@NotNull ConfigurationSection section) {
        IDeyed.writeId(this, section);
        Named.writeName(this, section);
        ConfigurationUtil.writeEnum(this.operatorExitShortcut, section, Constants.Key.OPERATOR_EXIT_SHORTCUT);
        ConfigurationUtil.writeEnum(this.passengerExitShortcut, section, Constants.Key.PASSENGER_EXIT_SHORTCUT);
        section.set("model", (Object)this.model.getId());
        if (this.pickupItem != null) {
            section.set("pickup-item", (Object)this.pickupItem.getId());
        }
        this.physics.write(section.createSection("physics"));
        this.fuel.write(section.createSection("fuel"));
        this.controllers.write(section.createSection("controllers"));
    }

    public static VehicleConfigurationBuilder builder() {
        return new VehicleConfigurationBuilder();
    }

    public static class VehicleConfigurationBuilder {
        private String id;
        private String name;
        private EnumExitShortcut operatorExitShortcut;
        private EnumExitShortcut passengerExitShortcut;
        private VehicleModelConfiguration model;
        private ItemConfiguration pickupItem;
        private VehiclePhysicsConfiguration physics;
        private VehicleFuelConfiguration fuel;
        private VehicleControllersConfiguration controllers;

        VehicleConfigurationBuilder() {
        }

        public VehicleConfigurationBuilder id(@NotNull String id) {
            if (id == null) {
                throw new NullPointerException("id is marked non-null but is null");
            }
            this.id = id;
            return this;
        }

        public VehicleConfigurationBuilder name(@NotNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
            return this;
        }

        public VehicleConfigurationBuilder operatorExitShortcut(@NotNull EnumExitShortcut operatorExitShortcut) {
            if (operatorExitShortcut == null) {
                throw new NullPointerException("operatorExitShortcut is marked non-null but is null");
            }
            this.operatorExitShortcut = operatorExitShortcut;
            return this;
        }

        public VehicleConfigurationBuilder passengerExitShortcut(@NotNull EnumExitShortcut passengerExitShortcut) {
            if (passengerExitShortcut == null) {
                throw new NullPointerException("passengerExitShortcut is marked non-null but is null");
            }
            this.passengerExitShortcut = passengerExitShortcut;
            return this;
        }

        public VehicleConfigurationBuilder model(@NotNull VehicleModelConfiguration model) {
            if (model == null) {
                throw new NullPointerException("model is marked non-null but is null");
            }
            this.model = model;
            return this;
        }

        public VehicleConfigurationBuilder pickupItem(@Nullable ItemConfiguration pickupItem) {
            this.pickupItem = pickupItem;
            return this;
        }

        public VehicleConfigurationBuilder physics(@Nullable VehiclePhysicsConfiguration physics) {
            this.physics = physics;
            return this;
        }

        public VehicleConfigurationBuilder fuel(@Nullable VehicleFuelConfiguration fuel) {
            this.fuel = fuel;
            return this;
        }

        public VehicleConfigurationBuilder controllers(@Nullable VehicleControllersConfiguration controllers) {
            this.controllers = controllers;
            return this;
        }

        public VehicleConfiguration build() {
            return new VehicleConfiguration(this.id, this.name, this.operatorExitShortcut, this.passengerExitShortcut, this.model, this.pickupItem, this.physics, this.fuel, this.controllers);
        }

        public String toString() {
            return "VehicleConfiguration.VehicleConfigurationBuilder(id=" + this.id + ", name=" + this.name + ", operatorExitShortcut=" + (Object)((Object)this.operatorExitShortcut) + ", passengerExitShortcut=" + (Object)((Object)this.passengerExitShortcut) + ", model=" + this.model + ", pickupItem=" + this.pickupItem + ", physics=" + this.physics + ", fuel=" + this.fuel + ", controllers=" + this.controllers + ")";
        }
    }
}

