/*
 * Decompiled with CFR 0.152.
 */
package es.outlook.adriansrj.cv.api.vehicle;

import com.google.common.base.Preconditions;
import gnu.trove.map.hash.THashMap;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;

public final class VehicleState {
    private static final Map<String, VehicleState> REGISTRY = new THashMap();
    public static final VehicleState IDLE = new VehicleState("idle", "Vehicle is not moving/turning", true);
    public static final VehicleState MOVING = new VehicleState("moving", "Vehicle is just moving", true);
    public static final VehicleState MOVING_BACKWARDS = new VehicleState("moving_backwards", "Vehicle is just moving", true);
    public static final VehicleState INCREASING_HEIGHT = new VehicleState("increasing_height", "Vehicle is increasing height", true);
    public static final VehicleState DECREASING_HEIGHT = new VehicleState("decreasing_height", "Vehicle is decreasing height", true);
    public static final VehicleState TURNING_LEFT = new VehicleState("turning_left", "Vehicle is just turning to the left", true);
    public static final VehicleState TURNING_RIGHT = new VehicleState("turning_right", "Vehicle is just turning to the right", true);
    public static final VehicleState MOVING_TURNING_LEFT = new VehicleState("moving_turning_left", "Vehicle is moving and turning to the left at the same time", true);
    public static final VehicleState MOVING_TURNING_RIGHT = new VehicleState("moving_turning_right", "Vehicle is moving and turning to the right at the same time", true);
    public static final VehicleState MOVING_BACKWARDS_TURNING_LEFT = new VehicleState("moving_backwards_turning_left", "Vehicle is moving and turning to the left at the same time", true);
    public static final VehicleState MOVING_BACKWARDS_TURNING_RIGHT = new VehicleState("moving_backwards_turning_right", "Vehicle is moving and turning to the right at the same time", true);
    public static final VehicleState INCREASING_HEIGHT_TURNING_LEFT = new VehicleState("increasing_height_turning_left", "Vehicle is increasing height and turning to the left at the same time", true);
    public static final VehicleState INCREASING_HEIGHT_TURNING_RIGHT = new VehicleState("increasing_height_turning_right", "Vehicle is increasing height and turning to the right at the same time", true);
    public static final VehicleState DECREASING_HEIGHT_TURNING_LEFT = new VehicleState("decreasing_height_turning_left", "Vehicle is decreasing height and turning to the left at the same time", true);
    public static final VehicleState DECREASING_HEIGHT_TURNING_RIGHT = new VehicleState("decreasing_height_turning_right", "Vehicle is decreasing height and turning to the right at the same time", true);
    @NotNull
    private final String name;
    private final boolean predefined;
    @NotNull
    private final String description;

    public static Collection<VehicleState> getValues() {
        return Collections.unmodifiableCollection(REGISTRY.values());
    }

    public static void register(@NotNull VehicleState state) {
        VehicleState predefined = REGISTRY.get(state.getName());
        if (predefined != null && predefined.isPredefined()) {
            throw new IllegalArgumentException("cannot override a pre-defined state");
        }
        REGISTRY.put(state.getName(), state);
    }

    public static void unregister(@NotNull VehicleState state) {
        if (state.isPredefined()) {
            throw new IllegalArgumentException("cannot unregister override a pre-defined");
        }
        REGISTRY.remove(state.getName());
    }

    public VehicleState(@NotNull String name, @NotNull String description) {
        this(name, description, false);
    }

    private VehicleState(@NotNull String name, @NotNull String description, boolean predefined) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)name), (Object)"name cannot be blank");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)description), (Object)"description cannot be blank");
        Preconditions.checkArgument((boolean)name.matches("[a-z0-9/._-]+"), (Object)"invalid name. must match: [a-z0-9/._-]+");
        this.name = name;
        this.description = description;
        this.predefined = predefined;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public String getDescription() {
        return this.description;
    }

    public boolean isPredefined() {
        return this.predefined;
    }

    public String toString() {
        return "VehicleState{name='" + this.name + '\'' + "description='" + this.description + '\'' + "predefined='" + this.predefined + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VehicleState state = (VehicleState)o;
        return this.name.equals(state.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    static {
        for (Field field : VehicleState.class.getFields()) {
            if (!Modifier.isStatic(field.getModifiers()) || !VehicleState.class.isAssignableFrom(field.getType())) continue;
            try {
                VehicleState state = (VehicleState)field.get(null);
                REGISTRY.put(state.getName(), state);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(e);
            }
        }
    }
}

