/*
 * Decompiled with CFR 0.152.
 */
package es.outlook.adriansrj.cv.api.vehicle;

import com.google.common.base.Preconditions;
import es.outlook.adriansrj.cv.api.vehicle.configuration.model.VehicleHitBoxConfiguration;
import org.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import org.apache.commons.math3.util.FastMath;
import org.bukkit.util.BoundingBox;
import org.jetbrains.annotations.NotNull;

public class VehicleHitBox {
    private final double width;
    private final double height;
    private final double depth;
    private double originX;
    private double originY;
    private double originZ;
    private double minX;
    private double minY;
    private double minZ;
    private double maxX;
    private double maxY;
    private double maxZ;

    public static VehicleHitBox of(@NotNull VehicleHitBoxConfiguration configuration) {
        return new VehicleHitBox(Math.max(configuration.getWidth(), 0.5), Math.max(configuration.getHeight(), 0.5), Math.max(configuration.getDepth(), 0.5));
    }

    public VehicleHitBox(double width, double height, double depth) {
        Preconditions.checkArgument((width >= 0.5 ? 1 : 0) != 0, (Object)"width must be >= 0.5");
        Preconditions.checkArgument((height >= 0.5 ? 1 : 0) != 0, (Object)"height must be >= 0.5");
        Preconditions.checkArgument((depth >= 0.5 ? 1 : 0) != 0, (Object)"depth must be >= 0.5");
        this.width = width;
        this.height = height;
        this.depth = depth;
        this.recalculate();
    }

    public int getBlockMinX() {
        return (int)FastMath.floor((double)this.minX);
    }

    public int getBlockMinY() {
        return (int)FastMath.floor((double)this.minY);
    }

    public int getBlockMinZ() {
        return (int)FastMath.floor((double)this.minZ);
    }

    public int getBlockMaxX() {
        return (int)FastMath.floor((double)this.maxX);
    }

    public int getBlockMaxY() {
        return (int)FastMath.floor((double)this.maxY);
    }

    public int getBlockMaxZ() {
        return (int)FastMath.floor((double)this.maxZ);
    }

    public void setOrigin(double x, double y, double z) {
        if (Double.compare(x, this.originX) == 0 && Double.compare(y, this.originY) == 0 && Double.compare(z, this.originZ) == 0) {
            return;
        }
        this.originX = x;
        this.originY = y;
        this.originZ = z;
        this.recalculate();
    }

    public VehicleHitBox future(double originX, double originY, double originZ) {
        VehicleHitBox future = this.copy();
        future.setOrigin(originX, originY, originZ);
        return future;
    }

    public void recalculate() {
        double widthHalf = this.width / 2.0;
        double depthHalf = this.depth / 2.0;
        double minX = this.originX - widthHalf;
        double minZ = this.originZ - depthHalf;
        double maxX = this.originX + widthHalf;
        double maxZ = this.originZ + depthHalf;
        this.minX = Math.min(minX, maxX);
        this.minZ = Math.min(minZ, maxZ);
        this.maxX = Math.max(minX, maxX);
        this.maxZ = Math.max(minZ, maxZ);
        this.minY = this.originY;
        this.maxY = this.originY + this.height;
    }

    public Vector3D getCorner000() {
        return new Vector3D(this.minX, this.minY, this.minZ);
    }

    public Vector3D getCorner001() {
        return new Vector3D(this.minX, this.minY, this.maxZ);
    }

    public Vector3D getCorner010() {
        return new Vector3D(this.minX, this.maxY, this.minZ);
    }

    public Vector3D getCorner011() {
        return new Vector3D(this.minX, this.maxY, this.maxZ);
    }

    public Vector3D getCorner100() {
        return new Vector3D(this.maxX, this.minY, this.minZ);
    }

    public Vector3D getCorner101() {
        return new Vector3D(this.maxX, this.minY, this.maxZ);
    }

    public Vector3D getCorner110() {
        return new Vector3D(this.maxX, this.maxY, this.minZ);
    }

    public Vector3D getCorner111() {
        return new Vector3D(this.maxX, this.maxY, this.maxZ);
    }

    public Vector3D[] getCorners() {
        return new Vector3D[]{this.getCorner000(), this.getCorner001(), this.getCorner010(), this.getCorner011(), this.getCorner100(), this.getCorner101(), this.getCorner110(), this.getCorner111()};
    }

    public BoundingBox toBoundingBox() {
        return new BoundingBox(this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ);
    }

    public VehicleHitBox copy() {
        VehicleHitBox copy = new VehicleHitBox(this.width, this.height, this.depth);
        copy.originX = this.originX;
        copy.originY = this.originY;
        copy.originZ = this.originZ;
        copy.minX = this.minX;
        copy.minY = this.minY;
        copy.minZ = this.minZ;
        copy.maxX = this.maxX;
        copy.maxY = this.maxY;
        copy.maxZ = this.maxZ;
        return copy;
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }

    public double getDepth() {
        return this.depth;
    }

    public double getOriginX() {
        return this.originX;
    }

    public double getOriginY() {
        return this.originY;
    }

    public double getOriginZ() {
        return this.originZ;
    }

    public double getMinX() {
        return this.minX;
    }

    public double getMinY() {
        return this.minY;
    }

    public double getMinZ() {
        return this.minZ;
    }

    public double getMaxX() {
        return this.maxX;
    }

    public double getMaxY() {
        return this.maxY;
    }

    public double getMaxZ() {
        return this.maxZ;
    }
}

