/*
 * Decompiled with CFR 0.152.
 */
package es.outlook.adriansrj.cv.api.vehicle;

import es.outlook.adriansrj.cv.api.enums.EnumSurface;
import es.outlook.adriansrj.cv.api.interfaces.Tickable;
import es.outlook.adriansrj.cv.api.vehicle.VehicleHitBox;
import es.outlook.adriansrj.cv.api.vehicle.VehicleSeat;
import es.outlook.adriansrj.cv.api.vehicle.VehicleState;
import es.outlook.adriansrj.cv.api.vehicle.configuration.VehicleConfiguration;
import es.outlook.adriansrj.cv.api.vehicle.controller.VehicleController;
import es.outlook.adriansrj.cv.api.vehicle.input.PlayerSteerInput;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Vehicle
extends Tickable {
    @NotNull
    public UUID getUniqueId();

    @NotNull
    public VehicleConfiguration getConfiguration();

    @NotNull
    public VehicleHitBox getCurrentHitBox();

    @NotNull
    public World getWorld();

    @NotNull
    public VehicleState getCurrentState();

    public boolean isDestroyed();

    default public float getFuelCapacity() {
        return this.getConfiguration().getFuel().getCapacity();
    }

    public float getFuelLevel();

    public void setFuelLevel(float var1);

    default public void addFuel(float amount) {
        float current = this.getFuelLevel();
        this.setFuelLevel(current + amount);
    }

    default public void consumeFuel(float consumption) {
        float current = this.getFuelLevel();
        this.setFuelLevel(current - consumption);
    }

    @Nullable
    public UUID getOwnerUniqueId();

    @Nullable
    default public Player getOwner() {
        UUID uniqueId = this.getOwnerUniqueId();
        return uniqueId != null ? Bukkit.getPlayer((UUID)uniqueId) : null;
    }

    default public boolean hasOwner() {
        return this.getOwnerUniqueId() != null;
    }

    public void setOwner(@Nullable UUID var1);

    default public void setOwner(@Nullable Player owner) {
        this.setOwner(owner != null ? owner.getUniqueId() : null);
    }

    public boolean isPersistent();

    public void setPersistent(boolean var1);

    @NotNull
    public Map<EnumSurface, Double> getCurrentSurface(@Nullable Collection<EnumSurface> var1);

    @NotNull
    default public Map<EnumSurface, Double> getCurrentSurface() {
        return this.getCurrentSurface(null);
    }

    public boolean isOnGround();

    public boolean isOnSurfaces(EnumSurface ... var1);

    public boolean isOnAnySurface(EnumSurface ... var1);

    public boolean isOnSurface(@NotNull EnumSurface var1);

    public boolean isOnSolidSurface();

    public boolean isOnWaterSurface();

    public boolean isOnLavaSurface();

    public boolean isOnLiquidSurface();

    public boolean isInTheAir();

    public boolean containedWithin(EnumSurface ... var1);

    public boolean containsAnyWithin(EnumSurface ... var1);

    @NotNull
    public Set<? extends VehicleSeat> getSeats();

    @NotNull
    public VehicleSeat getMainSeat();

    @Nullable
    public Entity getOperator();

    public void setOperator(@Nullable Entity var1);

    public boolean hasController(@NotNull VehicleController var1);

    public void addController(@NotNull VehicleController var1);

    public void removeController(@NotNull VehicleController var1);

    public void setState(@NotNull VehicleState var1);

    @NotNull
    public Location getLocation();

    public double getX();

    public double getY();

    public double getZ();

    public float getRotation();

    public void setLocation(double var1, double var3, double var5);

    public void setRotation(float var1);

    public void setLocationAndRotation(double var1, double var3, double var5, float var7);

    public void moveToWorld(@NotNull World var1, double var2, double var4, double var6);

    public double getMomentumX();

    public double getMomentumY();

    public double getMomentumZ();

    public void setMomentumX(double var1);

    public void setMomentumY(double var1);

    public void setMomentumZ(double var1);

    public void setMomentum(double var1, double var3, double var5);

    public void addMomentumX(double var1);

    public void addMomentumY(double var1);

    public void addMomentumZ(double var1);

    public void addMomentum(double var1, double var3, double var5);

    public void input(@NotNull PlayerSteerInput var1);
}

