/*
 * Decompiled with CFR 0.152.
 */
package es.outlook.adriansrj.cv.api.util.reflection;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.jetbrains.annotations.Nullable;

public final class ClassReflection {
    public static boolean isPrimitiveType(Class<?> type) {
        return EnumPrimitives.match(type) != null;
    }

    public static Class<?> getPrimitiveType(Class<?> wrapperType) {
        return Objects.requireNonNull(EnumPrimitives.match(wrapperType), "not a primitive").primitive;
    }

    public static Class<?> getPrimitiveWrapperType(Class<?> primitive) {
        return Objects.requireNonNull(EnumPrimitives.match(primitive), "not a primitive").wrapper;
    }

    public static Class<?>[] getClasses(String packageName) throws ClassNotFoundException, IOException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        assert (classLoader != null);
        String path = packageName.replace('.', '/');
        Enumeration<URL> resources = classLoader.getResources(path);
        ArrayList<File> dirs = new ArrayList<File>();
        while (resources.hasMoreElements()) {
            URL resource = resources.nextElement();
            dirs.add(new File(resource.getFile()));
        }
        ArrayList classes = new ArrayList();
        for (File directory : dirs) {
            classes.addAll(ClassReflection.findClasses(directory, packageName));
        }
        return classes.toArray(new Class[classes.size()]);
    }

    public static List<Class<?>> findClasses(File directory, String packageName) throws ClassNotFoundException {
        File[] files;
        ArrayList classes = new ArrayList();
        if (!directory.exists()) {
            return classes;
        }
        for (File file : files = directory.listFiles()) {
            if (file.isDirectory()) {
                assert (!file.getName().contains("."));
                classes.addAll(ClassReflection.findClasses(file, packageName + "." + file.getName()));
                continue;
            }
            if (!file.getName().endsWith(".class")) continue;
            try {
                classes.add(Class.forName(packageName + '.' + file.getName().substring(0, file.getName().length() - 6)));
            }
            catch (ClassNotFoundException ex) {
                ex.printStackTrace();
            }
        }
        return classes;
    }

    public static Set<String> getClassNames(File jarFile, @Nullable String packageName) {
        HashSet<String> names = new HashSet<String>();
        try {
            JarFile file = new JarFile(jarFile);
            Enumeration<JarEntry> entry = file.entries();
            while (entry.hasMoreElements()) {
                JarEntry jarEntry = entry.nextElement();
                String name = jarEntry.getName().replace("/", ".");
                if (packageName != null && !packageName.trim().isEmpty() && !name.startsWith(packageName.trim()) || !name.endsWith(".class")) continue;
                names.add(name.substring(0, name.lastIndexOf(".class")));
            }
            file.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return names;
    }

    public static Set<Class<?>> getClasses(File jarFile, String packageName) {
        HashSet classes = new HashSet();
        ClassReflection.getClassNames(jarFile, packageName).forEach(class_name -> {
            try {
                classes.add(Class.forName(class_name));
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        });
        return classes;
    }

    private static enum EnumPrimitives {
        INTEGER(Integer.TYPE, Integer.class),
        LONG(Long.TYPE, Long.class),
        DOUBLE(Double.TYPE, Double.class),
        FLOAT(Float.TYPE, Float.class),
        BYTE(Byte.TYPE, Byte.class),
        SHORT(Short.TYPE, Short.class),
        BOOLEAN(Boolean.TYPE, Boolean.class);

        private final Class<?> primitive;
        private final Class<?> wrapper;

        private static EnumPrimitives match(Class<?> clazz) {
            for (EnumPrimitives primitive : EnumPrimitives.values()) {
                if (primitive.primitive != clazz && primitive.wrapper != clazz) continue;
                return primitive;
            }
            return null;
        }

        private EnumPrimitives(Class<?> primitive, Class<?> wrapper) {
            this.primitive = primitive;
            this.wrapper = wrapper;
        }
    }
}

