/*
 * Decompiled with CFR 0.152.
 */
package es.outlook.adriansrj.cv.api.util.inventory;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BannerMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ItemStackUtil {
    public static boolean isBanner(@NotNull Material material) {
        if (material.isBlock() && material.name().endsWith("_BANNER")) {
            return true;
        }
        return Bukkit.getItemFactory().getItemMeta(material) instanceof BannerMeta;
    }

    public static boolean isHead(@NotNull Material material) {
        if (material.isBlock() && material.name().endsWith("_HEAD")) {
            return true;
        }
        return Bukkit.getItemFactory().getItemMeta(material) instanceof SkullMeta;
    }

    @NotNull
    public static ItemStack setDisplayName(@NotNull ItemStack item, @NotNull String displayName) {
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(ItemStackUtil.colorize(displayName));
            item.setItemMeta(meta);
        }
        return item;
    }

    @NotNull
    public static ItemStack setLore(@NotNull ItemStack item, @NotNull List<String> lore) {
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setLore(ItemStackUtil.colorize(lore));
            item.setItemMeta(meta);
        }
        return item;
    }

    @NotNull
    public static ItemStack buildCustomItem(@NotNull Material material, @Nullable Integer customModelData) {
        ItemStack result = new ItemStack(material);
        if (customModelData != null) {
            ItemMeta meta = result.getItemMeta();
            if (meta == null) {
                return result;
            }
            try {
                Method method = ItemMeta.class.getMethod("setCustomModelData", Integer.class);
                try {
                    method.setAccessible(true);
                    method.invoke((Object)meta, customModelData);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
            catch (NoSuchMethodException ex) {
                result.setDurability((short)customModelData.intValue());
            }
            result.setItemMeta(meta);
        }
        return result;
    }

    @NotNull
    public static ItemStack buildCustomItem(@NotNull Material material, @Nullable Integer customModelData, @Nullable String displayName, @Nullable List<String> description) {
        ItemStack result = ItemStackUtil.buildCustomItem(material, customModelData);
        ItemMeta meta = result.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(ItemStackUtil.colorize(displayName));
            meta.setLore(ItemStackUtil.colorize(description));
            result.setItemMeta(meta);
        }
        return result;
    }

    @Nullable
    public static <T, Z> Z getPersistentData(@NotNull ItemStack source, @NotNull NamespacedKey key, @NotNull PersistentDataType<T, Z> type) {
        ItemMeta meta = source.getItemMeta();
        PersistentDataContainer container = meta != null ? meta.getPersistentDataContainer() : null;
        return (Z)(container != null ? container.get(key, type) : null);
    }

    @NotNull
    public static <T, Z> ItemStack setPersistentData(@NotNull ItemStack itemStack, @NotNull NamespacedKey key, @NotNull PersistentDataType<T, Z> type, @NotNull Z value) {
        ItemMeta meta = itemStack.getItemMeta();
        if (meta != null || (meta = Bukkit.getItemFactory().getItemMeta(itemStack.getType())) != null) {
            meta.getPersistentDataContainer().set(key, type, value);
            itemStack.setItemMeta(meta);
        }
        return itemStack;
    }

    @Nullable
    private static String colorize(@Nullable String string) {
        if (string != null) {
            return ChatColor.translateAlternateColorCodes((char)'&', (String)string);
        }
        return null;
    }

    @Nullable
    private static List<String> colorize(@Nullable List<String> stringList) {
        if (stringList == null) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String string : stringList) {
            result.add(ItemStackUtil.colorize(string));
        }
        return result;
    }
}

