/*
 * Decompiled with CFR 0.152.
 */
package es.outlook.adriansrj.cv.api.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public abstract class LangFormatter {
    private static final char ARGUMENT_CHAR = '%';
    @NotNull
    protected final String context;

    public static LangFormatter single(@NotNull String context) {
        return new Single(context);
    }

    public static LangFormatter multi(@NotNull String context) {
        return new Multi(context);
    }

    public LangFormatter(@NotNull String context) {
        this.context = context;
    }

    public abstract LangFormatter arg(char var1, @NotNull String var2);

    @NotNull
    public abstract String format();

    public String toString() {
        return this.format();
    }

    public static class Single
    extends LangFormatter {
        @NotNull
        private final Map<Character, String> arguments = new HashMap<Character, String>();

        public Single(@NotNull String context) {
            super(context);
        }

        @Override
        public LangFormatter arg(char character, @NotNull String value) {
            if (character == '%') {
                throw new IllegalArgumentException("unsupported character");
            }
            this.arguments.put(Character.valueOf(Character.toLowerCase(character)), value);
            return this;
        }

        @Override
        @NotNull
        public String format() {
            StringBuilder builder = new StringBuilder();
            char[] chars = this.context.toCharArray();
            for (int i = 0; i < chars.length; ++i) {
                if (chars[i] != '%' || i + 1 >= chars.length) {
                    builder.append(chars[i]);
                    continue;
                }
                char character = Character.toLowerCase(chars[i + 1]);
                String argument = this.arguments.get(Character.valueOf(character));
                if (argument != null) {
                    builder.append(argument);
                }
                ++i;
            }
            return builder.toString();
        }
    }

    public static class Multi
    extends LangFormatter {
        @NotNull
        private final Map<Character, List<String>> arguments = new HashMap<Character, List<String>>();

        public Multi(@NotNull String context) {
            super(context);
        }

        @Override
        public LangFormatter arg(char character, @NotNull String value) {
            if (character == '%') {
                throw new IllegalArgumentException("unsupported character");
            }
            this.arguments.computeIfAbsent(Character.valueOf(Character.toLowerCase(character)), k -> new ArrayList()).add(value);
            return this;
        }

        @Override
        @NotNull
        public String format() {
            StringBuilder builder = new StringBuilder();
            char[] chars = this.context.toCharArray();
            HashMap<Character, List<String>> map = new HashMap<Character, List<String>>(this.arguments);
            for (int i = 0; i < chars.length; ++i) {
                if (chars[i] != '%' || i + 1 >= chars.length) {
                    builder.append(chars[i]);
                    continue;
                }
                char character = Character.toLowerCase(chars[i + 1]);
                List arguments = (List)map.get(Character.valueOf(character));
                if (arguments != null && arguments.size() > 0) {
                    builder.append((String)arguments.remove(0));
                }
                ++i;
            }
            return builder.toString();
        }
    }
}

