/*
 * Decompiled with CFR 0.152.
 */
package es.outlook.adriansrj.cv.api.util;

import es.outlook.adriansrj.cv.api.interfaces.ConfigurationSectionWritable;
import es.outlook.adriansrj.cv.api.interfaces.IDeyed;
import es.outlook.adriansrj.cv.api.interfaces.Named;
import es.outlook.adriansrj.cv.api.util.reflection.EnumReflection;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigurationUtil {
    private static final Map<Class<?>, LibraryObjectSingleEntryConfigurationWrapper<?>> SINGLE_ENTRY_LIBRARY_OBJECT_WRAPPERS = new HashMap();
    private static final Map<Class<?>, LibraryObjectConfigurationWrapper<?>> LIBRARY_OBJECT_WRAPPERS = new HashMap();

    public static <T> T loadLibrarySingleEntryObject(@NotNull Class<T> type, @NotNull ConfigurationSection section, @NotNull String key) throws InvalidConfigurationException {
        LibraryObjectSingleEntryConfigurationWrapper<?> loader = SINGLE_ENTRY_LIBRARY_OBJECT_WRAPPERS.get(type);
        Object object = loader.load(section, key);
        return object != null ? (T)type.cast(object) : null;
    }

    public static <T> T loadLibraryObject(@NotNull Class<T> type, @NotNull ConfigurationSection section) throws InvalidConfigurationException {
        LibraryObjectConfigurationWrapper<?> loader = LIBRARY_OBJECT_WRAPPERS.get(type);
        Object object = loader.load(section);
        return object != null ? (T)type.cast(object) : null;
    }

    public static <T> T loadLibraryObject(@NotNull Class<T> type, @NotNull ConfigurationSection parent, @NotNull String sectionName) throws InvalidConfigurationException {
        ConfigurationSection section = parent.getConfigurationSection(sectionName);
        if (section != null) {
            return ConfigurationUtil.loadLibraryObject(type, section);
        }
        return null;
    }

    @Nullable
    public static <T extends Enum<T>> T loadEnum(@NotNull Class<T> type, @NotNull ConfigurationSection section, @NotNull String key, boolean upperCase) {
        String name = section.getString(key, "");
        return StringUtils.isNotBlank((String)name) ? (T)EnumReflection.getEnumConstant(type, name.trim().toUpperCase()) : null;
    }

    @Nullable
    public static <T extends Enum<T>> T loadEnum(@NotNull Class<T> type, @NotNull ConfigurationSection section, @NotNull String key) {
        return ConfigurationUtil.loadEnum(type, section, key, true);
    }

    public static <T> void writeSingleEntryLibraryObject(@NotNull Class<T> type, @NotNull T object, @NotNull ConfigurationSection section, @NotNull String key) {
        LibraryObjectSingleEntryConfigurationWrapper<?> writer = SINGLE_ENTRY_LIBRARY_OBJECT_WRAPPERS.get(type);
        writer.write(object, section, key);
    }

    public static <T> void writeLibraryObject(@NotNull Class<T> type, @NotNull T object, @NotNull ConfigurationSection section) {
        LibraryObjectConfigurationWrapper<?> writer = LIBRARY_OBJECT_WRAPPERS.get(type);
        writer.write(object, section);
    }

    public static void writeEnum(@NotNull Enum<?> entry, @NotNull ConfigurationSection section, @NotNull String key) {
        section.set(key, (Object)entry.name());
    }

    public static void writeNullable(@Nullable Object object, @NotNull ConfigurationSection section, @NotNull String key) {
        section.set(key, object);
    }

    public static void writeConfigurationSectionWritables(@NotNull ConfigurationSection section, @NotNull Collection<? extends ConfigurationSectionWritable> writables, @NotNull String subfix) {
        int count = 0;
        for (ConfigurationSectionWritable configurationSectionWritable : writables) {
            if (configurationSectionWritable instanceof Named) {
                configurationSectionWritable.write(section.createSection(((Named)((Object)configurationSectionWritable)).getName()));
            } else if (configurationSectionWritable instanceof IDeyed) {
                configurationSectionWritable.write(section.createSection(((IDeyed)((Object)configurationSectionWritable)).getId()));
            } else {
                configurationSectionWritable.write(section.createSection(subfix + count));
            }
            ++count;
        }
    }

    @NotNull
    public static Set<ConfigurationSection> getConfigurationSectionsAfter(@NotNull ConfigurationSection parent, @NotNull String sectionAfterParent, boolean deep) {
        ConfigurationSection sectionAfter = parent.getConfigurationSection(sectionAfterParent);
        if (sectionAfter != null) {
            return ConfigurationUtil.getConfigurationSections(sectionAfter, deep);
        }
        return new HashSet<ConfigurationSection>();
    }

    @NotNull
    public static Set<ConfigurationSection> getConfigurationSections(@NotNull ConfigurationSection parent, boolean deep) {
        Set keys = parent.getKeys(deep);
        HashSet<ConfigurationSection> result = new HashSet<ConfigurationSection>();
        for (String key : keys) {
            ConfigurationSection subSection = parent.getConfigurationSection(key);
            if (subSection == null) continue;
            result.add(subSection);
        }
        return result;
    }

    static {
        SINGLE_ENTRY_LIBRARY_OBJECT_WRAPPERS.put(UUID.class, new LibraryObjectSingleEntryConfigurationWrapper<UUID>(){

            @Override
            public UUID load(@NotNull ConfigurationSection section, @NotNull String key) throws InvalidConfigurationException {
                try {
                    String string = section.getString(key);
                    return UUID.fromString(string != null ? string : "");
                }
                catch (IllegalArgumentException ex) {
                    throw new InvalidConfigurationException((Throwable)ex);
                }
            }

            @Override
            public void write(@NotNull UUID object, @NotNull ConfigurationSection section, @NotNull String key) {
                section.set(key, (Object)object.toString());
            }
        });
        LIBRARY_OBJECT_WRAPPERS.put(Vector3D.class, new LibraryObjectConfigurationWrapper<Vector3D>(){

            @Override
            public Vector3D load(@NotNull ConfigurationSection section) {
                double x = section.getDouble("x");
                double y = section.getDouble("y");
                double z = section.getDouble("z");
                return new Vector3D(x, y, z);
            }

            @Override
            public void write(@NotNull Vector3D object, @NotNull ConfigurationSection section) {
                section.set("x", (Object)object.getX());
                section.set("y", (Object)object.getY());
                section.set("z", (Object)object.getZ());
            }
        });
    }

    private static interface LibraryObjectSingleEntryConfigurationWrapper<T> {
        public T load(@NotNull ConfigurationSection var1, @NotNull String var2) throws InvalidConfigurationException;

        public void write(@NotNull T var1, @NotNull ConfigurationSection var2, @NotNull String var3);
    }

    private static interface LibraryObjectConfigurationWrapper<T> {
        public T load(@NotNull ConfigurationSection var1) throws InvalidConfigurationException;

        public void write(@NotNull T var1, @NotNull ConfigurationSection var2);
    }
}

