/*
 * Decompiled with CFR 0.152.
 */
package es.outlook.adriansrj.cv.api.service;

import es.outlook.adriansrj.cv.api.enums.EnumSurface;
import es.outlook.adriansrj.cv.api.service.Service;
import org.bukkit.World;
import org.jetbrains.annotations.NotNull;

public interface BlockInfoService
extends Service {
    public boolean isCanStandOnSurfaceAt(World var1, int var2, int var3, int var4);

    public EnumSurface getSurfaceTypeAt(World var1, int var2, int var3, int var4, boolean var5);

    public SurfaceResult getSurfaceTypesAt(World var1, int var2, int var3, int var4, int var5, int var6, boolean var7, boolean var8);

    default public boolean isEmpty(World world, int x, int y, int z) {
        return this.getSurfaceTypeAt(world, x, y, z, false) == EnumSurface.EMPTY;
    }

    default public boolean isSolid(World world, int x, int y, int z, boolean ignoreWeather) {
        return this.getSurfaceTypeAt(world, x, y, z, ignoreWeather) == EnumSurface.SOLID;
    }

    default public boolean isWater(World world, int x, int y, int z) {
        return this.getSurfaceTypeAt(world, x, y, z, false) == EnumSurface.WATER;
    }

    default public boolean isLava(World world, int x, int y, int z) {
        return this.getSurfaceTypeAt(world, x, y, z, false) == EnumSurface.LAVA;
    }

    public static class SurfaceResult {
        private final int minX;
        private final int minZ;
        private final int maxX;
        private final int maxZ;
        @NotNull
        private final EnumSurface[] value;

        @NotNull
        public EnumSurface getSurfaceType(int x, int z) {
            int depth = this.maxZ - this.minZ;
            return this.value[(x -= this.minX) * depth + (z -= this.minZ)];
        }

        public int getMinX() {
            return this.minX;
        }

        public int getMinZ() {
            return this.minZ;
        }

        public int getMaxX() {
            return this.maxX;
        }

        public int getMaxZ() {
            return this.maxZ;
        }

        @NotNull
        public EnumSurface[] getValue() {
            return this.value;
        }

        public SurfaceResult(int minX, int minZ, int maxX, int maxZ, @NotNull EnumSurface[] value) {
            if (value == null) {
                throw new NullPointerException("value is marked non-null but is null");
            }
            this.minX = minX;
            this.minZ = minZ;
            this.maxX = maxX;
            this.maxZ = maxZ;
            this.value = value;
        }
    }
}

