/*
 * Decompiled with CFR 0.152.
 */
package es.outlook.adriansrj.cv.api.registry.types;

import es.outlook.adriansrj.cv.api.CraftyVehicles;
import es.outlook.adriansrj.cv.api.interfaces.ControllerFactoryProvider;
import es.outlook.adriansrj.cv.api.registry.RegistryBase;
import es.outlook.adriansrj.cv.api.util.Constants;
import es.outlook.adriansrj.cv.api.vehicle.Vehicle;
import es.outlook.adriansrj.cv.api.vehicle.controller.VehicleController;
import es.outlook.adriansrj.cv.api.vehicle.controller.VehicleControllerProperties;
import es.outlook.adriansrj.cv.api.vehicle.controller.predefined.FixedWingVehicleController;
import es.outlook.adriansrj.cv.api.vehicle.controller.predefined.GroundVehicleController;
import es.outlook.adriansrj.cv.api.vehicle.controller.predefined.HybridVehicleController;
import es.outlook.adriansrj.cv.api.vehicle.controller.predefined.RotorcraftVehicleController;
import es.outlook.adriansrj.cv.api.vehicle.controller.predefined.WatercraftVehicleController;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VehicleControllerFactoryRegistry
extends RegistryBase<VehicleController.Factory> {
    public VehicleControllerFactoryRegistry() {
        this.register(new VehicleController.Factory(){

            @Override
            @NotNull
            public String getControllerId() {
                return "fixed-wing-vehicle";
            }

            @Override
            @NotNull
            public VehicleController createInstance(@NotNull Vehicle vehicle, @Nullable VehicleControllerProperties properties) {
                return new FixedWingVehicleController(vehicle, properties);
            }
        });
        this.register(new VehicleController.Factory(){

            @Override
            @NotNull
            public String getControllerId() {
                return "ground-vehicle";
            }

            @Override
            @NotNull
            public VehicleController createInstance(@NotNull Vehicle vehicle, @Nullable VehicleControllerProperties properties) {
                return new GroundVehicleController(vehicle, properties);
            }
        });
        this.register(new VehicleController.Factory(){

            @Override
            @NotNull
            public String getControllerId() {
                return "hybrid-vehicle";
            }

            @Override
            @NotNull
            public VehicleController createInstance(@NotNull Vehicle vehicle, @Nullable VehicleControllerProperties properties) {
                return new HybridVehicleController(vehicle, properties);
            }
        });
        this.register(new VehicleController.Factory(){

            @Override
            @NotNull
            public String getControllerId() {
                return "rotorcraft-vehicle";
            }

            @Override
            @NotNull
            public VehicleController createInstance(@NotNull Vehicle vehicle, @Nullable VehicleControllerProperties properties) {
                return new RotorcraftVehicleController(vehicle, properties);
            }
        });
        this.register(new VehicleController.Factory(){

            @Override
            @NotNull
            public String getControllerId() {
                return "watercraft-vehicle";
            }

            @Override
            @NotNull
            public VehicleController createInstance(@NotNull Vehicle vehicle, @Nullable VehicleControllerProperties properties) {
                return new WatercraftVehicleController(vehicle, properties);
            }
        });
    }

    @Override
    public void load() {
        File folder = Constants.Files.VEHICLE_CONTROLLERS_FOLDER;
        File[] jarFiles = folder.listFiles((dir, name) -> name.toLowerCase().endsWith(".jar"));
        try {
            int count = 0;
            if (jarFiles != null && jarFiles.length > 0) {
                count = this.load(jarFiles);
            }
            CraftyVehicles.getPlugin().getLogger().info(count > 0 ? count + " custom controllers were loaded!" : "No custom controllers were loaded!");
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    private int load(File ... jarFiles) throws MalformedURLException {
        int count = 0;
        try (URLClassLoader loader = new URLClassLoader(this.getFileURLs(jarFiles), this.getClass().getClassLoader());){
            for (File file : jarFiles) {
                count += this.load(loader, file);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return count;
    }

    private int load(URLClassLoader loader, File file) {
        int count = 0;
        try (JarFile jar = new JarFile(file);){
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                String className;
                Class<?> clazz;
                JarEntry entry = entries.nextElement();
                if (!entry.getName().endsWith(".class") || (clazz = loader.loadClass(className = entry.getName().replaceAll("/", ".").replace(".class", ""))) == null || !ControllerFactoryProvider.class.isAssignableFrom(clazz)) continue;
                ControllerFactoryProvider provider = (ControllerFactoryProvider)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                for (VehicleController.Factory factory : provider.create()) {
                    if (factory != null) {
                        this.register(factory);
                        ++count;
                        continue;
                    }
                    CraftyVehicles.getPlugin().getLogger().info("Factory provider " + clazz.getName() + " provided a null factory");
                }
                break;
            }
        }
        catch (IOException | ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
        }
        return count;
    }

    private URL[] getFileURLs(File ... files) throws MalformedURLException {
        URL[] urls = new URL[files.length];
        for (int i = 0; i < urls.length; ++i) {
            urls[i] = files[i].toURI().toURL();
        }
        return urls;
    }
}

